/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;

public class UniversalString
extends BaseASN1Object {
    private String value;

    public UniversalString(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(28);
        this.setTagNumber(28);
    }

    public UniversalString(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(28);
        this.setTagNumber(28);
        this.setValue(value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value_par) {
        if (value_par instanceof String) {
            this.value = (String)value_par;
        }
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        this.setType(28);
        try {
            byte[] allBytes = new byte[tagInfo.contentLength];
            System.arraycopy(data, tagInfo.contentIndex, allBytes, 0, tagInfo.contentLength);
            byte[] unicodeBytes = new byte[allBytes.length / 2];
            for (int i = 0; i < unicodeBytes.length; ++i) {
                System.arraycopy(allBytes, i * 4 + 2, unicodeBytes, i * 2, 2);
            }
            this.value = new String(data, tagInfo.contentIndex, tagInfo.contentLength, "UTF-16BE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected byte[] getContentEncoding() {
        try {
            byte[] unicodeBytes = this.value.getBytes("UTF-16BE");
            byte[] resultBytes = new byte[unicodeBytes.length * 2];
            byte[] zeroBytes = new byte[]{0, 0};
            for (int i = 0; i < unicodeBytes.length; i += 2) {
                System.arraycopy(zeroBytes, 0, resultBytes, i * 2, 2);
                System.arraycopy(unicodeBytes, i, resultBytes, i * 2 + 2, 2);
            }
            return resultBytes;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        return new String(super.toString());
    }
}

