/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.cms;

import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.Sequence;
import com.turktrust.cms.CMSVersion;
import com.turktrust.cms.OriginatorIdentifierOrKey;
import com.turktrust.cms.RecipientEncryptedKeys;
import com.turktrust.cms.UserKeyingMaterial;
import com.turktrust.pkcs7.KeyEncryptionAlgorithmIdentifier;

public class KeyAgreeRecipientInfo
extends Sequence {
    private CMSVersion version = new CMSVersion("version");
    private OriginatorIdentifierOrKey originator = new OriginatorIdentifierOrKey("originator");
    private UserKeyingMaterial ukm = new UserKeyingMaterial("ukm");
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm = new KeyEncryptionAlgorithmIdentifier("keyEncryptionAlgorithm");
    private RecipientEncryptedKeys recipientEncryptedKeys = new RecipientEncryptedKeys("recipientEncryptedKeys");

    public KeyAgreeRecipientInfo(String name) {
        super(name);
        this.setUpElements();
    }

    public KeyAgreeRecipientInfo() {
        super("default_KeyAgreeRecipientInfo");
        this.setUpElements();
    }

    protected void setUpElements() {
        this.originator.setTaggingMethod(2);
        this.originator.setTagClass((byte)-128);
        this.originator.setTagNumber(0);
        this.ukm.setOptional(true);
        this.ukm.setTaggingMethod(2);
        this.ukm.setTagClass((byte)-128);
        this.ukm.setTagNumber(1);
        super.addElement(this.version);
        super.addElement(this.originator);
        super.addElement(this.ukm);
        super.addElement((ASN1Object)this.keyEncryptionAlgorithm);
        super.addElement(this.recipientEncryptedKeys);
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.originator;
    }

    public void setOriginator(OriginatorIdentifierOrKey originator) {
        this.originator = originator;
    }

    public RecipientEncryptedKeys getRecipientEncryptedKeys() {
        return this.recipientEncryptedKeys;
    }

    public void setRecipientEncryptedKeys(RecipientEncryptedKeys recipientEncryptedKeys) {
        this.recipientEncryptedKeys = recipientEncryptedKeys;
    }

    public UserKeyingMaterial getUkm() {
        return this.ukm;
    }

    public void setUkm(UserKeyingMaterial ukm) {
        this.ukm = ukm;
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public void setVersion(CMSVersion version) {
        this.version = version;
    }
}

