/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.BMPString;
import com.turktrust.asn1.IA5String;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.UTF8String;
import com.turktrust.x509.DisplayText;
import com.turktrust.x509.NoticeReference;

public class UserNotice
extends Sequence {
    private NoticeReference noticeRef = new NoticeReference("noticeRef");
    private DisplayText explicitText = new DisplayText("displayText");

    public UserNotice() {
        super("defUserNotice");
        this.setUpElements();
    }

    private void setUpElements() {
        this.addElement(this.noticeRef);
        this.noticeRef.setOptional(true);
        this.noticeRef.setEmptyEncodingAllowed(false);
        this.addElement(this.explicitText);
        this.explicitText.setOptional(true);
    }

    public UserNotice(String name, String noticeText) {
        super(name);
        this.setUpElements();
        String boundedNoticeText = "";
        boundedNoticeText = noticeText.length() > 200 ? noticeText.substring(0, 200) : noticeText;
        BMPString noticeTextBMP = new BMPString("userNoticeText");
        noticeTextBMP.setValue(boundedNoticeText);
        this.explicitText.setValue(noticeTextBMP);
        this.commitElementUpdate();
    }

    public boolean isDefaultValue() {
        return this.explicitText.getValue() == null;
    }

    public String getNoticeText() {
        this.explicitText = (DisplayText)this.getElement(1);
        try {
            BMPString bmpString = (BMPString)this.explicitText.getValue();
            return (String)bmpString.getValue();
        }
        catch (ClassCastException ccexc) {
            try {
                UTF8String utf8String = (UTF8String)this.explicitText.getValue();
                return (String)utf8String.getValue();
            }
            catch (ClassCastException ccexc2) {
                IA5String ia5String = (IA5String)this.explicitText.getValue();
                return (String)ia5String.getValue();
            }
        }
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

