/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.api;

import com.turktrust.api.DogrulamaLog;
import com.turktrust.api.OCSPException;
import com.turktrust.api.SertifikaBilgiNesnesi;
import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.GeneralizedTime;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SetOf;
import com.turktrust.asn1.UTCTime;
import com.turktrust.cms.ContentTimeStamp;
import com.turktrust.cms.DigestAlgorithmIdentifiers;
import com.turktrust.cms.EncapsulatedContentInfo;
import com.turktrust.cms.SignedAttributes;
import com.turktrust.cms.SignedData;
import com.turktrust.cms.SignerIdentifier;
import com.turktrust.cms.SignerInfo;
import com.turktrust.cms.SignerInfos;
import com.turktrust.cms.UnsignedAttributes;
import com.turktrust.cms.X509CertificateSet;
import com.turktrust.ess.ESSCertId;
import com.turktrust.ess.ESSCertIdv2;
import com.turktrust.ess.SigningCertificate;
import com.turktrust.ess.SigningCertificateV2;
import com.turktrust.ltes.SignaturePolicyId;
import com.turktrust.ltes.SignaturePolicyIdentifier;
import com.turktrust.ocsp.BasicOCSPResponse;
import com.turktrust.ocsp.RevokedInfo;
import com.turktrust.ocsp.SingleResponse;
import com.turktrust.pkcs1.DigestInfo;
import com.turktrust.pkcs7.ContentInfo;
import com.turktrust.pkcs7.IssuerAndSerialNumber;
import com.turktrust.smyy.utils.AkilliKarttakiSertifika;
import com.turktrust.smyy.utils.Base64;
import com.turktrust.smyy.utils.CMSFabrikasi;
import com.turktrust.smyy.utils.CRLFabrikasi;
import com.turktrust.smyy.utils.HashFabrikasi;
import com.turktrust.smyy.utils.ImzaFabrikasi;
import com.turktrust.smyy.utils.OCSPFabrikasi;
import com.turktrust.smyy.utils.SertifikaFabrikasi;
import com.turktrust.smyy.utils.Smartcard;
import com.turktrust.x509.AccessDescription;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Attribute;
import com.turktrust.x509.AttributeType;
import com.turktrust.x509.AuthorityInfoAccessSyntax;
import com.turktrust.x509.CRLReason;
import com.turktrust.x509.Certificate;
import com.turktrust.x509.CertificateList;
import com.turktrust.x509.CertificateSerialNumber;
import com.turktrust.x509.Extension;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.GeneralName;
import com.turktrust.x509.GeneralNames;
import com.turktrust.x509.Name;
import com.turktrust.x509.QCStatement;
import com.turktrust.x509.QCStatements;
import com.turktrust.x509.RevokedCertificate;
import com.turktrust.x509.SubjectPublicKeyInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class ImzaIslemNesnesi {
    public static final int DURUM_JNI_KUTUPHANESI_YUKLU_DEGIL = 0;
    public static final int DURUM_JNI_KUTUPHANESI_YUKLU = 1;
    public static final int DURUM_FIRMA_KUTUPHANESI_YUKLU = 2;
    public static final int DURUM_KART_OTURUMU_ACILDI = 3;
    public static final int DURUM_KART_LOGIN_TAMAM = 4;
    public static final int DURUM_KARTTAKI_SERTIFIKA_DOGRULANDI = 5;
    public static final int ISLEM_TAMAM = 11;
    public static final int ISLEM_YAPILIRKEN_HATA_OLUSTU = 12;
    public static final int ISLEM_SIRASI_UYGUN_DEGIL = 13;
    public static final int PIN_HATALI = 14;
    public static final int SERTIFIKA_GECERSIZ = 15;
    public static final int SERTIFIKA_KARTTA_BULUNAMADI = 16;
    public static final int PIN_BLOKE = 17;
    public static final int PIN_GIRISI_KALAN_HAK_SAYISI_BILGISI_SAGLANMIYOR = -1;
    public static final int DOGRULAMA_SONUCU_IMZA_GECERLI = 20;
    public static final int DOGRULAMA_SONUCU_IMZA_GECERSIZ = 21;
    public static final int DOGRULAMA_ISLEMINDE_HATA_OLUSTU = 22;
    public static final int DOGRULAMA_ISLEMINDE_BILINMEYEN_IMZA_ALGORITMASI = 23;
    public static final int DOGRULAMA_ISLEMINDE_SERTIFIKA_DOGRULANAMADI = 24;
    public static final int DOGRULAMA_ISLEMINDE_IMZA_VERI_YAPISI_HATALI = 25;
    public static final int DOGRULAMA_ISLEMINDE_IMZA_SAHIBI_SERTIFIKA_BULUNAMADI = 26;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVAP_YAPISI_BOZUK = 27;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_DOGRULANAMADI = 28;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVAP_SERTIFIKASI_DOGRULANAMADI = 29;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_ESKI = 71;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_BASKA_SERTIFIKAYA_AIT = 72;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_SERTIFIKA_IPTAL = 73;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_SERTIFIKA_BILINMIYOR = 74;
    public static final int DOGRULAMA_ISLEMINDE_CRL_VERI_YAPISI_BOZUK = 75;
    public static final int DOGRULAMA_ISLEMINDE_CRL_DOGRULANAMADI = 76;
    public static final int DOGRULAMA_ISLEMINDE_CRL_TARIHI_UYGUN_DEGIL = 77;
    public static final int DOGRULAMA_ISLEMINDE_CRL_SERTIFIKA_IPTAL = 78;
    public static final int DOGRULAMA_ISLEMINDE_ALT_KOK_IPTAL = 79;
    public static final int DOGRULAMA_ISLEMINDE_KOK_CRL_BULUNAMADI = 80;
    public static final int DOGRULAMA_ISLEMINDE_IMZA_ZAMANI_SERTIFIKA_SURESININ_DISINDA = 81;
    public static final int DOGRULAMA_ISLEMINDE_ORIJINAL_VERI_DOSYASI_BULUNAMADI = 82;
    public static final int AKILLI_KART_TAKILI = 30;
    public static final int AKILLI_KART_TAKILI_DEGIL = 31;
    public static final int OCSP_SORGU_YAPILAMAZ_VERI_YAPISI_HATALI = 40;
    public static final int OCSP_SORGU_YAPILAMAZ_ESHS_SERTIFIKASI_BULUNAMADI = 41;
    public static final int OCSP_ADRESI_BULUNAMADI = 42;
    public static final int OCSP_BAGLANTISI_KURULAMADI = 43;
    public static final int OCSP_SUNUCUSUNDA_HATA_OLUSTU = 44;
    public static final int OCSP_YANIT_GECERSIZ = 45;
    public static final int OCSP_YANIT_DOGRULAMA_SERTIFIKASI_BULUNAMADI = 46;
    public static final int OCSP_YANIT_DOGRULAMA_ISLEMINDE_HATA = 47;
    public static final int OCSP_YANIT_BILINMEYEN_IMZA_ALGORITMASI = 48;
    public static final int OCSP_SERTIFIKA_GECERLI = 49;
    public static final int OCSP_SERTIFIKA_IPTAL_EDILMIS = 50;
    public static final int OCSP_SERTIFIKA_BILINMIYOR = 51;
    public static final int OCSP_SORGUSU_YAPILDI = 52;
    public static final int CRL_DOSYASI_OKUNAMADI = 60;
    public static final int CRL_DOSYASI_YAPISI_BOZUK = 61;
    public static final int CRL_KONTROLU_YAPILAMAZ_ESHS_SERTIFIKASI_BULUNAMADI = 62;
    public static final int CRL_DOSYASINI_IMZALAYAN_ESHS_SERTIFIKASI_BILINMIYOR = 63;
    public static final int CRL_DOSYASI_UZERINDEKI_IMZA_GECERSIZ = 64;
    public static final int CRL_KONTROLU_YAPILAMAZ_IMZA_VERI_YAPISI_HATALI = 65;
    public static final int CRL_KONTROLUNE_GORE_SERTIFIKA_GECERLI = 66;
    public static final int CRL_KONTROLUNE_GORE_SERTIFIKA_IPTAL_EDILMIS = 67;
    public static final int CRL_DOSYASI_GECERLILIK_SURESI_DISINDA = 68;
    public static final int CRL_KONTROLUNDE_HATA_OLUSTU = 69;
    public static final int IPTAL_NEDENI_BELIRTILMEMIS = 0;
    public static final int IPTAL_NEDENI_ANAHTAR_GUVENLIK_KAYBI = 1;
    public static final int IPTAL_NEDENI_ESHS_GUVENLIK_KAYBI = 2;
    public static final int IPTAL_NEDENI_BILGI_DEGISIKLIGI = 3;
    public static final int IPTAL_NEDENI_SERTIFIKA_YENILENMIS = 4;
    public static final int IPTAL_NEDENI_OPERASYON_DURMASI = 5;
    public static final int IPTAL_NEDENI_ASKIDA = 6;
    public static final int IPTAL_NEDENI_CRLDEN_CIKARMA = 8;
    public static final int IPTAL_NEDENI_YETKI_KAYBI = 9;
    public static final int IPTAL_NEDENI_YETKI_OTORITESI_GUVENLIK_KAYBI = 10;
    public static final String SHA_1 = "1.3.14.3.2.26";
    public static final String SHA_224 = "2.16.840.1.101.3.4.2.4";
    public static final String SHA_256 = "2.16.840.1.101.3.4.2.1";
    public static final String SHA_384 = "2.16.840.1.101.3.4.2.2";
    public static final String SHA_512 = "2.16.840.1.101.3.4.2.3";
    public static final String WHIRLPOOL = "1.0.10118.3.0.55";
    public static final String BTK_PROFIL_P2 = "2.16.792.1.61.0.1.5070.3.1.1";
    public static final String BTK_PROFIL_P3 = "2.16.792.1.61.0.1.5070.3.2.1";
    public static final String BTK_PROFIL_P4 = "2.16.792.1.61.0.1.5070.3.3.1";
    public static final String BTK_PROFIL_URI_P2 = "http://www.eimza.gov.tr/EimzaPolitikalari/216792161015070311.pdf";
    public static final String BTK_PROFIL_URI_P3 = "http://www.eimza.gov.tr/EimzaPolitikalari/216792161015070321.pdf";
    public static final String BTK_PROFIL_URI_P4 = "http://www.eimza.gov.tr/EimzaPolitikalari/216792161015070331.pdf";
    private static final byte[] BTK_PROFIL_PDF_DOKUMAN_OZET = new byte[]{-1, 57, -67, 41, 70, 51, -125, -10, -101, 32, 82, -84, 71, 67, -98, 6, -50, 124, 59, -122, 70, -24, -120, -74, -27, -82, 62, 70, -70, 8, 17, 122};
    private String jniDLLFilename;
    private String pkcs11DLLFilename;
    private int status = 0;
    private Certificate shsCert;
    private boolean atLeastOneWrongPIN = false;
    private Certificate karttakiSertifika;
    private AkilliKarttakiSertifika[] tumSertifikalar;
    private int secilenSertifikaIndex = -1;
    private int ocspSonSorgudaIptalNedeni;
    private Date ocspSonSorgudaIptalTarihi;
    private int ocspSonSorgudaHataKodu;
    private Vector kokSertifikalar = new Vector();
    private int crlSonKontroldeIptalNedeni;
    private Date crlSonKontroldeIptalTarihi;
    private Vector sonDogrulamaZincir;
    private Vector kokCRLVec = new Vector();
    private String imzaHashAlgoritmasi = "2.16.840.1.101.3.4.2.1";
    private int baglantiZamanAsimiSaniyesi = -1;
    private boolean ocspHatalarindaExceptionKullan = false;
    private String tbsDataMimeType = null;
    private String imzaProfili = null;
    private String imzaProfilDokumaniURLAdresi = null;
    private String imzaSahibiUlke = null;
    private String imzaSahibiSehir = null;
    private String commitmentTypeOIDStr = null;
    private byte[] contentIdBytes = null;
    private byte[] contentTSTBytes = null;
    private String ocspHashAlgoritmasi = "2.16.840.1.101.3.4.2.1";
    private Date disaridanVerilenImzaZamani = null;

    public int jniKutuphanesiYukle(String jniKutuphanesiDosyaAdi) {
        try {
            if (this.status == 0) {
                System.loadLibrary(jniKutuphanesiDosyaAdi);
                this.status = 1;
                this.jniDLLFilename = jniKutuphanesiDosyaAdi;
                return 11;
            }
            return 13;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 12;
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
            return 12;
        }
    }

    public int jniKutuphanesiYukle(File jniKutuphanesiDosyasi) {
        try {
            if (this.status == 0) {
                System.load(jniKutuphanesiDosyasi.getAbsolutePath());
                this.status = 1;
                this.jniDLLFilename = jniKutuphanesiDosyasi.getName().substring(0, jniKutuphanesiDosyasi.getName().lastIndexOf("."));
                return 11;
            }
            return 13;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 12;
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
            return 12;
        }
    }

    public int akilliKartFirmaKutuphanesiYukle(String firmaKutuphanesiDosyaAdi) {
        try {
            if (this.status == 1) {
                int x = Smartcard.initializeSmartCardEnvironment(firmaKutuphanesiDosyaAdi);
                if (x == Smartcard.OK) {
                    this.status = 2;
                    this.pkcs11DLLFilename = firmaKutuphanesiDosyaAdi;
                    return 11;
                }
                System.out.println("kutuphane yukle = " + x);
                return 12;
            }
            return 13;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int akilliKartTakilimiKontrol() {
        try {
            if (Smartcard.isTokenPresent()) {
                return 30;
            }
            return 31;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int akilliKartOturumuAc() {
        try {
            if (this.status == 2) {
                if (Smartcard.openSession(this.pkcs11DLLFilename) == Smartcard.OK) {
                    this.status = 3;
                    this.akilliKarttanSertifikaOku();
                    this.akilliKarttanTumSertifikalariOku();
                    this.secilenSertifikaIndex = -1;
                    return 11;
                }
                return 12;
            }
            return 13;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public Vector tumSertifikalarinIDleriniAl() {
        try {
            if (this.status == 0 || this.status == 1 || this.status == 2) {
                return null;
            }
            if (this.tumSertifikalar == null) {
                return null;
            }
            Vector<byte[]> res = new Vector<byte[]>();
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                res.addElement(this.tumSertifikalar[i].getIdBytes());
            }
            return res;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] akilliKarttakiSertifikayiAl() {
        try {
            if (this.karttakiSertifika != null) {
                return this.karttakiSertifika.getEncoded();
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] akilliKarttakiSertifikayiAl(byte[] sertifikaId) {
        try {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(this.tumSertifikalar[i].getIdBytes(), sertifikaId)) continue;
                return this.tumSertifikalar[i].getCertificate().getEncoded();
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public int akilliKartLogin(String pin) {
        try {
            if (this.status == 3) {
                int loginrv = Smartcard.login(pin);
                if (loginrv == Smartcard.OK) {
                    this.status = 4;
                    this.atLeastOneWrongPIN = false;
                    return 11;
                }
                if (loginrv == Smartcard.PIN_LOCKED) {
                    this.atLeastOneWrongPIN = true;
                    return 17;
                }
                this.atLeastOneWrongPIN = true;
                return 14;
            }
            return 13;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int akilliKartKalanPINDenemeHakSayisiAl() {
        try {
            if (this.status == 3 && this.atLeastOneWrongPIN) {
                if (this.pkcs11DLLFilename.equals("gclib.dll")) {
                    int trialCount = Smartcard.getUserLoginAttemptFlag();
                    return trialCount;
                }
                return -1;
            }
            return 13;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int shsSertifikasiYukle(File shsSertifikaDosyasi) {
        try {
            FileInputStream fis = new FileInputStream(shsSertifikaDosyasi);
            byte[] shsCertBytes = new byte[fis.available()];
            fis.read(shsCertBytes);
            fis.close();
            this.shsCert = new Certificate("shsCert");
            this.shsCert.decode(shsCertBytes);
            this.kokSertifikalar.addElement(this.shsCert);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int shsSertifikasiYukle(byte[] sertifikaByteDizisi) {
        try {
            Certificate yeniShsCert = new Certificate("shsCert");
            yeniShsCert.decode(sertifikaByteDizisi);
            this.kokSertifikalar.addElement(yeniShsCert);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int shsSertifikasiBase64DosyadanYukle(File shsSertifikaDosyasiB64) {
        try {
            FileReader freader = new FileReader(shsSertifikaDosyasiB64);
            BufferedReader bufread = new BufferedReader(freader);
            String line = bufread.readLine();
            String coreInput = "";
            while (line != null) {
                if (!line.substring(0, 5).equals("-----")) {
                    coreInput = coreInput + line;
                }
                line = bufread.readLine();
            }
            Base64 base64 = new Base64();
            byte[] shsCertBytes = base64.decode(coreInput);
            this.shsCert = new Certificate("shsCert");
            this.shsCert.decode(shsCertBytes);
            this.kokSertifikalar.addElement(this.shsCert);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int akilliKarttakiSertifikayiDogrula() {
        try {
            if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0 || this.status != 4) {
                return 13;
            }
            if (this.akilliKarttanSertifikaOku() != null) {
                boolean verif = false;
                for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                    verif = SertifikaFabrikasi.verifyCertificate(this.karttakiSertifika, (Certificate)this.kokSertifikalar.elementAt(i));
                    if (!verif) continue;
                    this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
                    break;
                }
                if (verif) {
                    this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(this.shsCert, this.kokSertifikalar);
                    if (this.sonDogrulamaZincir.size() == 0) {
                        return 15;
                    }
                    this.status = 5;
                    return 11;
                }
                return 15;
            }
            return 16;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int akilliKarttakiSertifikayiDogrula(byte[] sertifikaId) {
        try {
            if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0 || this.status != 4) {
                return 13;
            }
            this.akilliKarttanTumSertifikalariOku();
            this.secilenSertifikaIndex = -1;
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                this.secilenSertifikaIndex = i;
            }
            if (this.secilenSertifikaIndex == -1) {
                return 16;
            }
            boolean verif = false;
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                verif = SertifikaFabrikasi.verifyCertificate(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate(), (Certificate)this.kokSertifikalar.elementAt(i));
                if (!verif) continue;
                this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
                break;
            }
            if (verif) {
                this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(this.shsCert, this.kokSertifikalar);
                if (this.sonDogrulamaZincir.size() == 0) {
                    return 15;
                }
                this.status = 5;
                return 11;
            }
            return 15;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int akilliKarttakiSertifikaOCSPSorgusuYap() throws OCSPException {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return 13;
        }
        if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0) {
            return 13;
        }
        if (this.karttakiSertifika == null) {
            return 16;
        }
        boolean verif = false;
        for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
            verif = SertifikaFabrikasi.verifyCertificate(this.karttakiSertifika, (Certificate)this.kokSertifikalar.elementAt(i));
            if (!verif) continue;
            this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
            break;
        }
        if (verif) {
            this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(this.shsCert, this.kokSertifikalar);
            if (this.sonDogrulamaZincir.size() == 0) {
                return 41;
            }
        } else {
            return 41;
        }
        Vector sorguSonucVec = this.ocspSorgusuYap(this.karttakiSertifika, this.shsCert, null, this.baglantiZamanAsimiSaniyesi, this.ocspHatalarindaExceptionKullan);
        int sorguSonuc = (Integer)sorguSonucVec.elementAt(0);
        if (sorguSonuc == 50 && sorguSonucVec.size() > 2) {
            this.ocspSonSorgudaIptalNedeni = (Integer)sorguSonucVec.elementAt(1);
            this.ocspSonSorgudaIptalTarihi = (Date)sorguSonucVec.elementAt(2);
        } else {
            this.ocspSonSorgudaIptalNedeni = 0;
            this.ocspSonSorgudaIptalTarihi = null;
        }
        this.ocspSonSorgudaHataKodu = sorguSonuc == 49 || sorguSonuc == 50 || sorguSonuc == 51 ? 52 : sorguSonuc;
        return sorguSonuc;
    }

    public int akilliKarttakiSertifikaOCSPSorgusuYap(byte[] sertifikaId) throws OCSPException {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return 13;
        }
        if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0) {
            return 13;
        }
        this.secilenSertifikaIndex = -1;
        for (int i = 0; i < this.tumSertifikalar.length; ++i) {
            if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
            this.secilenSertifikaIndex = i;
        }
        if (this.secilenSertifikaIndex == -1) {
            return 16;
        }
        boolean verif = false;
        for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
            verif = SertifikaFabrikasi.verifyCertificate(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate(), (Certificate)this.kokSertifikalar.elementAt(i));
            if (!verif) continue;
            this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
            break;
        }
        if (verif) {
            this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(this.shsCert, this.kokSertifikalar);
            if (this.sonDogrulamaZincir.size() == 0) {
                return 41;
            }
        } else {
            return 41;
        }
        Vector sorguSonucVec = this.ocspSorgusuYap(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate(), this.shsCert, null, this.baglantiZamanAsimiSaniyesi, this.ocspHatalarindaExceptionKullan);
        int sorguSonuc = (Integer)sorguSonucVec.elementAt(0);
        if (sorguSonuc == 50 && sorguSonucVec.size() > 2) {
            this.ocspSonSorgudaIptalNedeni = (Integer)sorguSonucVec.elementAt(1);
            this.ocspSonSorgudaIptalTarihi = (Date)sorguSonucVec.elementAt(2);
        } else {
            this.ocspSonSorgudaIptalNedeni = 0;
            this.ocspSonSorgudaIptalTarihi = null;
        }
        this.ocspSonSorgudaHataKodu = sorguSonuc == 49 || sorguSonuc == 50 || sorguSonuc == 51 ? 52 : sorguSonuc;
        return sorguSonuc;
    }

    public int akilliKarttakiSertifikaOCSPSorgusuYap(byte[] sertifikaId, String ocspAdresi) throws OCSPException {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return 13;
        }
        if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0) {
            return 13;
        }
        this.secilenSertifikaIndex = -1;
        for (int i = 0; i < this.tumSertifikalar.length; ++i) {
            if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
            this.secilenSertifikaIndex = i;
        }
        if (this.secilenSertifikaIndex == -1) {
            return 16;
        }
        boolean verif = false;
        for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
            verif = SertifikaFabrikasi.verifyCertificate(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate(), (Certificate)this.kokSertifikalar.elementAt(i));
            if (!verif) continue;
            this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
            break;
        }
        if (verif) {
            this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(this.shsCert, this.kokSertifikalar);
            if (this.sonDogrulamaZincir.size() == 0) {
                return 41;
            }
        } else {
            return 41;
        }
        if (ocspAdresi == null) {
            return 42;
        }
        Vector sorguSonucVec = this.ocspSorgusuYap(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate(), this.shsCert, ocspAdresi, this.baglantiZamanAsimiSaniyesi, this.ocspHatalarindaExceptionKullan);
        int sorguSonuc = (Integer)sorguSonucVec.elementAt(0);
        if (sorguSonuc == 50 && sorguSonucVec.size() > 2) {
            this.ocspSonSorgudaIptalNedeni = (Integer)sorguSonucVec.elementAt(1);
            this.ocspSonSorgudaIptalTarihi = (Date)sorguSonucVec.elementAt(2);
        } else {
            this.ocspSonSorgudaIptalNedeni = 0;
            this.ocspSonSorgudaIptalTarihi = null;
        }
        this.ocspSonSorgudaHataKodu = sorguSonuc == 49 || sorguSonuc == 50 || sorguSonuc == 51 ? 52 : sorguSonuc;
        return sorguSonuc;
    }

    public int akilliKarttakiSertifikaCRLKontroluYap() {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return 13;
        }
        if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0) {
            return 13;
        }
        if (this.karttakiSertifika == null) {
            return 16;
        }
        CertificateList crl = CRLFabrikasi.downloadCRL(this.karttakiSertifika);
        if (crl == null) {
            return 60;
        }
        return this.crlKontroluYap(this.karttakiSertifika, crl);
    }

    public int akilliKarttakiSertifikaCRLKontroluYap(byte[] sertifikaId) {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return 13;
        }
        if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0) {
            return 13;
        }
        this.secilenSertifikaIndex = -1;
        for (int i = 0; i < this.tumSertifikalar.length; ++i) {
            if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
            this.secilenSertifikaIndex = i;
        }
        if (this.secilenSertifikaIndex == -1) {
            return 16;
        }
        CertificateList crl = CRLFabrikasi.downloadCRL(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate());
        if (crl == null) {
            return 60;
        }
        return this.crlKontroluYap(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate(), crl);
    }

    public int akilliKarttakiSertifikaCRLKontroluYap(File crlDosyasi) {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return 13;
        }
        if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0) {
            return 13;
        }
        if (this.karttakiSertifika == null) {
            return 16;
        }
        if (!crlDosyasi.exists()) {
            return 60;
        }
        CertificateList crl = new CertificateList("crl");
        byte[] crlBytes = null;
        try {
            FileInputStream fis = new FileInputStream(crlDosyasi);
            crlBytes = new byte[fis.available()];
            fis.read(crlBytes);
            fis.close();
        }
        catch (Exception exc) {
            return 60;
        }
        try {
            crl.decode(crlBytes);
            boolean verif = false;
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                verif = SertifikaFabrikasi.verifyCertificate(this.karttakiSertifika, (Certificate)this.kokSertifikalar.elementAt(i));
                if (!verif) continue;
                this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
                break;
            }
            if (verif) {
                this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(this.shsCert, this.kokSertifikalar);
                if (this.sonDogrulamaZincir.size() == 0) {
                    return 62;
                }
            } else {
                return 62;
            }
            if (!crl.gettbsCertList().getissuer().isEqualTo(this.shsCert.gettbsCertificate().getsubject())) {
                return 63;
            }
            if (!CRLFabrikasi.verifyCRL(crl, this.shsCert)) {
                return 64;
            }
            RevokedCertificate revcert = CRLFabrikasi.isCertificateInCRL(this.karttakiSertifika, crl);
            if (revcert == null) {
                this.crlSonKontroldeIptalNedeni = 0;
                this.crlSonKontroldeIptalTarihi = null;
                return 66;
            }
            try {
                this.crlSonKontroldeIptalTarihi = (Date)((GeneralizedTime)revcert.getRevocationDate().getValue()).getValue();
            }
            catch (ClassCastException ccexc) {
                this.crlSonKontroldeIptalTarihi = (Date)((UTCTime)revcert.getRevocationDate().getValue()).getValue();
            }
            Extension extReas = revcert.getExtensions().getExtensionByOID("2.5.29.21");
            if (extReas != null) {
                CRLReason crlReas = new CRLReason();
                crlReas.decodeExtVal((byte[])extReas.getextnValue().getValue());
                this.crlSonKontroldeIptalNedeni = crlReas.getReasonCode();
            } else {
                this.crlSonKontroldeIptalNedeni = 0;
            }
            return 67;
        }
        catch (Exception exc) {
            return 61;
        }
    }

    public int akilliKarttakiSertifikaCRLKontroluYap(File crlDosyasi, byte[] sertifikaId) {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return 13;
        }
        if (this.kokSertifikalar == null || this.kokSertifikalar.size() == 0) {
            return 13;
        }
        this.secilenSertifikaIndex = -1;
        for (int i = 0; i < this.tumSertifikalar.length; ++i) {
            if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
            this.secilenSertifikaIndex = i;
        }
        if (this.secilenSertifikaIndex == -1) {
            return 16;
        }
        if (!crlDosyasi.exists()) {
            return 60;
        }
        CertificateList crl = new CertificateList("crl");
        byte[] crlBytes = null;
        try {
            FileInputStream fis = new FileInputStream(crlDosyasi);
            crlBytes = new byte[fis.available()];
            fis.read(crlBytes);
            fis.close();
        }
        catch (Exception exc) {
            return 60;
        }
        try {
            crl.decode(crlBytes);
            boolean verif = false;
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                verif = SertifikaFabrikasi.verifyCertificate(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate(), (Certificate)this.kokSertifikalar.elementAt(i));
                if (!verif) continue;
                this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
                break;
            }
            if (verif) {
                this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(this.shsCert, this.kokSertifikalar);
                if (this.sonDogrulamaZincir.size() == 0) {
                    return 62;
                }
            } else {
                return 62;
            }
            if (!crl.gettbsCertList().getissuer().isEqualTo(this.shsCert.gettbsCertificate().getsubject())) {
                return 63;
            }
            if (!CRLFabrikasi.verifyCRL(crl, this.shsCert)) {
                return 64;
            }
            RevokedCertificate revcert = CRLFabrikasi.isCertificateInCRL(this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate(), crl);
            if (revcert == null) {
                this.crlSonKontroldeIptalNedeni = 0;
                this.crlSonKontroldeIptalTarihi = null;
                return 66;
            }
            try {
                this.crlSonKontroldeIptalTarihi = (Date)((GeneralizedTime)revcert.getRevocationDate().getValue()).getValue();
            }
            catch (ClassCastException ccexc) {
                this.crlSonKontroldeIptalTarihi = (Date)((UTCTime)revcert.getRevocationDate().getValue()).getValue();
            }
            Extension extReas = revcert.getExtensions().getExtensionByOID("2.5.29.21");
            if (extReas != null) {
                CRLReason crlReas = new CRLReason();
                crlReas.decodeExtVal((byte[])extReas.getextnValue().getValue());
                this.crlSonKontroldeIptalNedeni = crlReas.getReasonCode();
            } else {
                this.crlSonKontroldeIptalNedeni = 0;
            }
            return 67;
        }
        catch (Exception exc) {
            return 61;
        }
    }

    private Certificate akilliKarttanSertifikaOku() {
        try {
            if (this.status == 3 || this.status == 4 || this.status == 5) {
                byte[] certBytes = Smartcard.readCertificate();
                if (certBytes == null) {
                    return null;
                }
                this.karttakiSertifika = new Certificate("cert");
                this.karttakiSertifika.decode(certBytes);
                return this.karttakiSertifika;
            }
            this.karttakiSertifika = null;
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private void akilliKarttanTumSertifikalariOku() {
        try {
            if (this.status == 3 || this.status == 4 || this.status == 5) {
                this.tumSertifikalar = Smartcard.readAllCertificates();
                if (this.tumSertifikalar.length > 0) {
                    this.karttakiSertifika = this.tumSertifikalar[0].getCertificate();
                }
            } else {
                this.tumSertifikalar = null;
                this.karttakiSertifika = null;
            }
        }
        catch (Exception exc) {
            this.tumSertifikalar = null;
            this.karttakiSertifika = null;
        }
    }

    public boolean imzaOzetAlgoritmasiBelirle(String algoritmaOID) {
        if (!(algoritmaOID.equals(SHA_1) || algoritmaOID.equals(SHA_256) || algoritmaOID.equals(SHA_224) || algoritmaOID.equals(WHIRLPOOL) || algoritmaOID.equals(SHA_384) || algoritmaOID.equals(SHA_512))) {
            return false;
        }
        this.imzaHashAlgoritmasi = algoritmaOID;
        return true;
    }

    public boolean ocspOzetAlgoritmasiBelirle(String algoritmaOID) {
        if (!(algoritmaOID.equals(SHA_1) || algoritmaOID.equals(SHA_256) || algoritmaOID.equals(SHA_224) || algoritmaOID.equals(WHIRLPOOL) || algoritmaOID.equals(SHA_384) || algoritmaOID.equals(SHA_512))) {
            return false;
        }
        this.ocspHashAlgoritmasi = algoritmaOID;
        return true;
    }

    public void imzalanacakVeriTipiBelirle(String veriTipi) {
        this.tbsDataMimeType = veriTipi;
    }

    public void imzaProfiliBelirle(String profilOid) {
        this.imzaProfili = profilOid;
        if (profilOid.equals(BTK_PROFIL_P2)) {
            this.imzaProfilDokumaniURLAdresi = BTK_PROFIL_URI_P2;
        } else if (profilOid.equals(BTK_PROFIL_P3)) {
            this.imzaProfilDokumaniURLAdresi = BTK_PROFIL_URI_P3;
        } else if (profilOid.equals(BTK_PROFIL_P4)) {
            this.imzaProfilDokumaniURLAdresi = BTK_PROFIL_URI_P4;
        }
    }

    public void imzaSahibiUlkeBelirle(String ulke) {
        this.imzaSahibiUlke = ulke;
    }

    public void imzaSahibiSehirBelirle(String sehir) {
        this.imzaSahibiSehir = sehir;
    }

    public void sorumlulukTipiBelirle(String sorumlulukTipiOid) {
        this.commitmentTypeOIDStr = sorumlulukTipiOid;
    }

    public void icerikTanimlayiciVeriBelirle(byte[] icerikTanimlayici) {
        this.contentIdBytes = icerikTanimlayici;
    }

    public void icerikZamanDamgasiEkle(byte[] icerikZamanDamgasi) {
        this.contentTSTBytes = icerikZamanDamgasi;
    }

    public void imzaZamaniDisaridanBelirle(Date imzaZamani) {
        this.disaridanVerilenImzaZamani = imzaZamani;
    }

    public String akilliKarttaImzala(String imzalanacakVeri, boolean veriyiSonucaEkle) {
        try {
            if (this.status == 5) {
                byte[] sonucBytes = this.akilliKarttaImzala(imzalanacakVeri.getBytes("UTF-8"), veriyiSonucaEkle);
                if (sonucBytes == null) {
                    return null;
                }
                return new Base64().encodeToString(sonucBytes, false);
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] akilliKarttaImzala(byte[] imzalanacakVeri, boolean veriyiSonucaEkle) {
        try {
            if (this.status == 5) {
                Certificate cert = this.akilliKarttanSertifikaOku();
                ContentInfo cinfo = ImzaIslemNesnesi.formCMSSignedData(imzalanacakVeri, cert, veriyiSonucaEkle, null, this.imzaHashAlgoritmasi, this.tbsDataMimeType, this.imzaProfili, this.imzaProfilDokumaniURLAdresi, this.imzaSahibiUlke, this.imzaSahibiSehir, this.commitmentTypeOIDStr, this.contentIdBytes, this.contentTSTBytes, this.disaridanVerilenImzaZamani);
                return cinfo.getEncoded();
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String akilliKarttaImzala(String imzalanacakVeri, boolean veriyiSonucaEkle, byte[] sertifikaId) {
        try {
            if (this.status == 5) {
                byte[] sonucBytes = this.akilliKarttaImzala(imzalanacakVeri.getBytes("UTF-8"), veriyiSonucaEkle, sertifikaId);
                if (sonucBytes == null) {
                    return null;
                }
                return new Base64().encodeToString(sonucBytes, false);
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] akilliKarttaImzala(byte[] imzalanacakVeri, boolean veriyiSonucaEkle, byte[] sertifikaId) {
        try {
            if (this.status == 5 && this.secilenSertifikaIndex != -1) {
                if (ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[this.secilenSertifikaIndex].getIdBytes())) {
                    Certificate cert = this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate();
                    ContentInfo cinfo = ImzaIslemNesnesi.formCMSSignedData(imzalanacakVeri, cert, veriyiSonucaEkle, sertifikaId, this.imzaHashAlgoritmasi, this.tbsDataMimeType, this.imzaProfili, this.imzaProfilDokumaniURLAdresi, this.imzaSahibiUlke, this.imzaSahibiSehir, this.commitmentTypeOIDStr, this.contentIdBytes, this.contentTSTBytes, this.disaridanVerilenImzaZamani);
                    return cinfo.getEncoded();
                }
                return null;
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] akilliKarttaDosyaImzala(String dosyaAdi) {
        try {
            if (this.status == 5) {
                Certificate cert = this.akilliKarttanSertifikaOku();
                ContentInfo cinfo = ImzaIslemNesnesi.formCMSSignedDataFromFileInput(dosyaAdi, cert, null, this.imzaHashAlgoritmasi, this.tbsDataMimeType, this.imzaProfili, this.imzaProfilDokumaniURLAdresi, this.imzaSahibiUlke, this.imzaSahibiSehir, this.commitmentTypeOIDStr, this.contentIdBytes, this.contentTSTBytes, this.disaridanVerilenImzaZamani);
                return cinfo.getEncoded();
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public byte[] akilliKarttaDosyaImzala(String dosyaAdi, byte[] sertifikaId) {
        try {
            if (this.status == 5 && this.secilenSertifikaIndex != -1) {
                if (ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[this.secilenSertifikaIndex].getIdBytes())) {
                    Certificate cert = this.tumSertifikalar[this.secilenSertifikaIndex].getCertificate();
                    ContentInfo cinfo = ImzaIslemNesnesi.formCMSSignedDataFromFileInput(dosyaAdi, cert, sertifikaId, this.imzaHashAlgoritmasi, this.tbsDataMimeType, this.imzaProfili, this.imzaProfilDokumaniURLAdresi, this.imzaSahibiUlke, this.imzaSahibiSehir, this.commitmentTypeOIDStr, this.contentIdBytes, this.contentTSTBytes, this.disaridanVerilenImzaZamani);
                    return cinfo.getEncoded();
                }
                return null;
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public int imzaDogrula(String imza, String orijinalVeri) {
        try {
            byte[] imzaBytes = new Base64().decode(imza);
            byte[] orijinalVeriBytes = orijinalVeri.getBytes("UTF-8");
            return this.imzaDogrula(imzaBytes, orijinalVeriBytes);
        }
        catch (Exception exc) {
            return 22;
        }
    }

    public int imzaDogrula(byte[] imza, byte[] orijinalVeri) {
        try {
            Vector resultVec = this.verifyCMSSignedData(imza, orijinalVeri);
            return (Integer)resultVec.elementAt(0);
        }
        catch (Exception exc) {
            return 22;
        }
    }

    public int imzaDogrula(byte[] imza) {
        try {
            Vector resultVec = this.verifyCMSSignedData(imza, null);
            return (Integer)resultVec.elementAt(0);
        }
        catch (Exception exc) {
            return 22;
        }
    }

    public int dosyaImzasiDogrula(byte[] imza, String orijinalVeriDosyasi) {
        try {
            Vector resultVec = this.verifyCMSSignedDataFromFileInput(imza, orijinalVeriDosyasi);
            return (Integer)resultVec.elementAt(0);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 22;
        }
    }

    public int imzaDogrulaOCSPCevabiKullan(byte[] imza, byte[] orijinalVeri, Date imzaZamani, byte[] ocspCevabi) {
        return this.verifySignatureUseOCSP(imza, orijinalVeri, imzaZamani, ocspCevabi);
    }

    public int imzaDogrulaOCSPCevabiKullan(byte[] imza, Date imzaZamani, byte[] ocspCevabi) {
        return this.verifySignatureUseOCSP(imza, null, imzaZamani, ocspCevabi);
    }

    private int verifySignatureUseOCSP(byte[] imza, byte[] orijinalVeri, Date imzaZamani, byte[] ocspCevabi) {
        try {
            Vector resultVec = this.verifyCMSSignedData(imza, orijinalVeri);
            int vres = (Integer)resultVec.elementAt(0);
            if (vres == 20) {
                Certificate signerCert = (Certificate)resultVec.elementAt(1);
                Date certStart = null;
                try {
                    UTCTime utc = (UTCTime)signerCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
                    certStart = (Date)utc.getValue();
                }
                catch (ClassCastException ccexc) {
                    GeneralizedTime gtm = (GeneralizedTime)signerCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
                    certStart = (Date)gtm.getValue();
                }
                Date certFinish = null;
                try {
                    UTCTime utc = (UTCTime)signerCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                    certFinish = (Date)utc.getValue();
                }
                catch (ClassCastException ccexc) {
                    GeneralizedTime gtm = (GeneralizedTime)signerCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                    certFinish = (Date)gtm.getValue();
                }
                if (certStart.compareTo(imzaZamani) > 0 || certFinish.compareTo(imzaZamani) < 0) {
                    return 81;
                }
                BasicOCSPResponse basicResp = new BasicOCSPResponse("basicResp");
                try {
                    basicResp.decode(ocspCevabi);
                }
                catch (Exception dexc) {
                    return 27;
                }
                if (OCSPFabrikasi.verifyBasicOCSPResponse(basicResp) != 0) {
                    return 28;
                }
                Certificate ocspRespCert = OCSPFabrikasi.extractResponderCertFromBasicOCSPResponse(basicResp);
                Vector ocspZincir = ImzaIslemNesnesi.getHierarchyFromSet(ocspRespCert, this.kokSertifikalar);
                if (ocspZincir.size() == 0) {
                    return 29;
                }
                Date respTime = OCSPFabrikasi.getResponseTimeFromResponse(basicResp);
                if (respTime.compareTo(imzaZamani) < 0) {
                    return 71;
                }
                if (basicResp.getTbsResponseData().getReponses().size() == 0) {
                    return 27;
                }
                SingleResponse singleResp = (SingleResponse)basicResp.getTbsResponseData().getReponses().elementAt(0);
                int certOcspStatus = OCSPFabrikasi.getCertStatusFromSingleResponse(singleResp, signerCert);
                if (certOcspStatus == 10) {
                    return 72;
                }
                if (certOcspStatus == 9) {
                    return 74;
                }
                if (certOcspStatus == 8) {
                    RevokedInfo revInfo = singleResp.getCertStatus().getRevokedInfo();
                    if (revInfo == null) {
                        return 73;
                    }
                    Date revokTime = (Date)revInfo.getRevocationTime().getValue();
                    if (imzaZamani.compareTo(revokTime) > 0) {
                        return 73;
                    }
                }
                for (int i = 0; i < this.sonDogrulamaZincir.size() - 1; ++i) {
                    boolean siradakiCRLBulundu = false;
                    for (int y = 0; y < this.kokCRLVec.size(); ++y) {
                        if (!CRLFabrikasi.verifyCRL((CertificateList)this.kokCRLVec.elementAt(y), (Certificate)this.sonDogrulamaZincir.elementAt(i + 1))) continue;
                        Date crlStart = null;
                        try {
                            UTCTime crlstUTC = (UTCTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getthisUpdate().getValue();
                            crlStart = (Date)crlstUTC.getValue();
                        }
                        catch (ClassCastException ccexc) {
                            GeneralizedTime crlstGN = (GeneralizedTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getthisUpdate().getValue();
                            crlStart = (Date)crlstGN.getValue();
                        }
                        Date crlFinish = null;
                        try {
                            UTCTime crlfnUTC = (UTCTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getnextUpdate().getValue();
                            crlFinish = (Date)crlfnUTC.getValue();
                        }
                        catch (ClassCastException ccexc) {
                            GeneralizedTime crlfnGN = (GeneralizedTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getnextUpdate().getValue();
                            crlFinish = (Date)crlfnGN.getValue();
                        }
                        Certificate currentCACert = (Certificate)this.sonDogrulamaZincir.elementAt(i);
                        Date currentCAFinish = null;
                        try {
                            UTCTime utc = (UTCTime)currentCACert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                            currentCAFinish = (Date)utc.getValue();
                        }
                        catch (ClassCastException ccexc) {
                            GeneralizedTime gtm = (GeneralizedTime)currentCACert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                            currentCAFinish = (Date)gtm.getValue();
                        }
                        if (crlStart.compareTo(currentCAFinish) > 0 || crlFinish.compareTo(imzaZamani) < 0) continue;
                        siradakiCRLBulundu = true;
                        if (CRLFabrikasi.isCertificateInCRL(currentCACert, (CertificateList)this.kokCRLVec.elementAt(y)) == null) break;
                        return 79;
                    }
                    if (siradakiCRLBulundu) continue;
                    return 80;
                }
                return 20;
            }
            return vres;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 22;
        }
    }

    public int imzaDogrulaCRLKullan(byte[] imza, byte[] orijinalVeri, Date imzaZamani, byte[] crlByteDizisi) {
        return this.verifySignatureUseCRL(imza, orijinalVeri, imzaZamani, crlByteDizisi);
    }

    public int imzaDogrulaCRLKullan(byte[] imza, Date imzaZamani, byte[] crlByteDizisi) {
        return this.verifySignatureUseCRL(imza, null, imzaZamani, crlByteDizisi);
    }

    private int verifySignatureUseCRL(byte[] imza, byte[] orijinalVeri, Date imzaZamani, byte[] crlByteDizisi) {
        try {
            Vector resultVec = this.verifyCMSSignedData(imza, orijinalVeri);
            int vres = (Integer)resultVec.elementAt(0);
            if (vres == 20) {
                Certificate signerCert = (Certificate)resultVec.elementAt(1);
                Date certStart = null;
                try {
                    UTCTime utc = (UTCTime)signerCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
                    certStart = (Date)utc.getValue();
                }
                catch (ClassCastException ccexc) {
                    GeneralizedTime gtm = (GeneralizedTime)signerCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
                    certStart = (Date)gtm.getValue();
                }
                Date certFinish = null;
                try {
                    UTCTime utc = (UTCTime)signerCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                    certFinish = (Date)utc.getValue();
                }
                catch (ClassCastException ccexc) {
                    GeneralizedTime gtm = (GeneralizedTime)signerCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                    certFinish = (Date)gtm.getValue();
                }
                if (certStart.compareTo(imzaZamani) > 0 || certFinish.compareTo(imzaZamani) < 0) {
                    return 81;
                }
                CertificateList crl = new CertificateList("crl");
                try {
                    crl.decode(crlByteDizisi);
                }
                catch (Exception dexc) {
                    return 75;
                }
                if (!CRLFabrikasi.verifyCRL(crl, (Certificate)this.sonDogrulamaZincir.elementAt(0))) {
                    return 76;
                }
                Date signerCrlStart = null;
                try {
                    UTCTime crlstUTC = (UTCTime)crl.gettbsCertList().getthisUpdate().getValue();
                    signerCrlStart = (Date)crlstUTC.getValue();
                }
                catch (ClassCastException ccexc) {
                    GeneralizedTime crlstGN = (GeneralizedTime)crl.gettbsCertList().getthisUpdate().getValue();
                    signerCrlStart = (Date)crlstGN.getValue();
                }
                Date signerCrlFinish = null;
                try {
                    UTCTime crlstUTC = (UTCTime)crl.gettbsCertList().getnextUpdate().getValue();
                    signerCrlFinish = (Date)crlstUTC.getValue();
                }
                catch (ClassCastException ccexc) {
                    GeneralizedTime crlstGN = (GeneralizedTime)crl.gettbsCertList().getnextUpdate().getValue();
                    signerCrlFinish = (Date)crlstGN.getValue();
                }
                if (signerCrlFinish.compareTo(imzaZamani) < 0) {
                    return 77;
                }
                if (signerCrlStart.compareTo(certFinish) > 0) {
                    return 77;
                }
                RevokedCertificate revCert = CRLFabrikasi.isCertificateInCRL(signerCert, crl);
                if (revCert != null) {
                    Date revokTime = null;
                    try {
                        revokTime = (Date)((UTCTime)revCert.getRevocationDate().getValue()).getValue();
                    }
                    catch (ClassCastException castExc) {
                        revokTime = (Date)((GeneralizedTime)revCert.getRevocationDate().getValue()).getValue();
                    }
                    if (imzaZamani.compareTo(revokTime) > 0) {
                        return 78;
                    }
                }
                for (int i = 0; i < this.sonDogrulamaZincir.size() - 1; ++i) {
                    boolean siradakiCRLBulundu = false;
                    for (int y = 0; y < this.kokCRLVec.size(); ++y) {
                        if (!CRLFabrikasi.verifyCRL((CertificateList)this.kokCRLVec.elementAt(y), (Certificate)this.sonDogrulamaZincir.elementAt(i + 1))) continue;
                        Date crlStart = null;
                        try {
                            UTCTime crlstUTC = (UTCTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getthisUpdate().getValue();
                            crlStart = (Date)crlstUTC.getValue();
                        }
                        catch (ClassCastException ccexc) {
                            GeneralizedTime crlstGN = (GeneralizedTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getthisUpdate().getValue();
                            crlStart = (Date)crlstGN.getValue();
                        }
                        Date crlFinish = null;
                        try {
                            UTCTime crlfnUTC = (UTCTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getnextUpdate().getValue();
                            crlFinish = (Date)crlfnUTC.getValue();
                        }
                        catch (ClassCastException ccexc) {
                            GeneralizedTime crlfnGN = (GeneralizedTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getnextUpdate().getValue();
                            crlFinish = (Date)crlfnGN.getValue();
                        }
                        Certificate currentCACert = (Certificate)this.sonDogrulamaZincir.elementAt(i);
                        Date currentCAFinish = null;
                        try {
                            UTCTime utc = (UTCTime)currentCACert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                            currentCAFinish = (Date)utc.getValue();
                        }
                        catch (ClassCastException ccexc) {
                            GeneralizedTime gtm = (GeneralizedTime)currentCACert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                            currentCAFinish = (Date)gtm.getValue();
                        }
                        if (crlStart.compareTo(currentCAFinish) > 0 || crlFinish.compareTo(imzaZamani) < 0) continue;
                        siradakiCRLBulundu = true;
                        if (CRLFabrikasi.isCertificateInCRL(currentCACert, (CertificateList)this.kokCRLVec.elementAt(y)) == null) break;
                        return 79;
                    }
                    if (siradakiCRLBulundu) continue;
                    return 80;
                }
                return 20;
            }
            return vres;
        }
        catch (Exception exc) {
            return 22;
        }
    }

    public int durumBilgisiAl() {
        return this.status;
    }

    public int akilliKartLogout() {
        try {
            if (this.status == 4 || this.status == 5) {
                Smartcard.logout();
                this.status = 3;
                return 11;
            }
            return 13;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int akilliKartOturumuKapat() {
        try {
            if (this.status == 3 || this.status == 4 || this.status == 5) {
                Smartcard.closeSession();
                this.status = 2;
                this.atLeastOneWrongPIN = false;
                this.karttakiSertifika = null;
                this.tumSertifikalar = null;
                return 11;
            }
            return 13;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int akilliKartIslemleriniSonlandir() {
        try {
            if (this.status == 2) {
                Smartcard.finalizeSmartcard();
                this.status = 1;
                this.atLeastOneWrongPIN = false;
                this.karttakiSertifika = null;
                this.tumSertifikalar = null;
                return 11;
            }
            return 13;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public byte[] orijinalVeriyiAl(byte[] imza) {
        try {
            if (imza[0] == 48 && imza[1] == -128) {
                imza = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(imza);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(imza);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            if (eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.1")) {
                byte[] origBytes = (byte[])eci.getEncapsulatedContent().getValue();
                return origBytes;
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] temelOrijinalVeriyiAl(byte[] imza) {
        try {
            Vector dikeyVec;
            if (imza[0] == 48 && imza[1] == -128) {
                imza = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(imza);
            }
            if ((dikeyVec = this.dikeyImzalariAl(imza)).size() > 0) {
                byte[] icImza = (byte[])dikeyVec.elementAt(dikeyVec.size() - 1);
                return this.orijinalVeriyiAl(icImza);
            }
            return this.orijinalVeriyiAl(imza);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public Vector dikeyImzalariAl(byte[] imza) {
        try {
            int cc;
            if (imza[0] == 48 && imza[1] == -128) {
                imza = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(imza);
            }
            if ((cc = ImzaIslemNesnesi.countCounterSignatures(imza)) > 0) {
                return ImzaIslemNesnesi.getCounterSignaturesList(imza);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(imza);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            byte[] origBytes = (byte[])eci.getEncapsulatedContent().getValue();
            Vector<byte[]> resultVec = new Vector<byte[]>();
            byte[] innerBytes = origBytes;
            ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
            boolean finished = !((String)eci.getEncapsulatedContentType().getValue()).equals((String)idSignedData.getValue());
            while (!finished) {
                try {
                    SignedData innerSd = new SignedData("innerSd");
                    innerSd.decode(innerBytes);
                    ContentInfo resCinfo = new ContentInfo("resCinfo");
                    resCinfo.setcontentType(idSignedData);
                    Any contSignedData = new Any("contSignedData", innerSd);
                    resCinfo.setcontent(contSignedData);
                    resCinfo.commitElementUpdate();
                    resultVec.addElement(resCinfo.getEncoded());
                    EncapsulatedContentInfo innerEci = innerSd.getEncapContentInfo();
                    if (((String)innerEci.getEncapsulatedContentType().getValue()).equals((String)idSignedData.getValue())) {
                        innerBytes = (byte[])innerEci.getEncapsulatedContent().getValue();
                        continue;
                    }
                    finished = true;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return null;
                }
            }
            return resultVec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public Vector paralelImzalariAl(byte[] imza) {
        try {
            if (imza[0] == 48 && imza[1] == -128) {
                imza = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(imza);
            }
            return this.extractParallelSignatures(imza);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public byte[] paralelImzalariBirlestir(Vector paralelImzalar) {
        return this.mergeParallelSignatures(paralelImzalar);
    }

    public String sertifikaninSeriNumarasiniAl() {
        if (this.karttakiSertifika != null) {
            BigInteger serial = (BigInteger)this.karttakiSertifika.gettbsCertificate().getserialNumber().getValue();
            return serial.toString();
        }
        return null;
    }

    public String sertifikaninSeriNumarasiniAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                BigInteger serial = (BigInteger)this.tumSertifikalar[i].getCertificate().gettbsCertificate().getserialNumber().getValue();
                return serial.toString();
            }
            return null;
        }
        return null;
    }

    public String sertifikaSahibiIsimAl() {
        if (this.karttakiSertifika != null) {
            return this.karttakiSertifika.gettbsCertificate().getsubject().getCN();
        }
        return null;
    }

    public String sertifikaSahibiIsimAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                return this.tumSertifikalar[i].getCertificate().gettbsCertificate().getsubject().getCN();
            }
            return null;
        }
        return null;
    }

    public String sertifikaSahibiTanimlayiciNumarasiAl() {
        if (this.karttakiSertifika != null) {
            return this.karttakiSertifika.gettbsCertificate().getsubject().getSerialNo();
        }
        return null;
    }

    public String sertifikaSahibiTanimlayiciNumarasiAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                return this.tumSertifikalar[i].getCertificate().gettbsCertificate().getsubject().getSerialNo();
            }
            return null;
        }
        return null;
    }

    public String sertifikaSahibiUlkeKoduAl() {
        if (this.karttakiSertifika != null) {
            return this.karttakiSertifika.gettbsCertificate().getsubject().getC();
        }
        return null;
    }

    public String sertifikaSahibiUlkeKoduAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                return this.tumSertifikalar[i].getCertificate().gettbsCertificate().getsubject().getC();
            }
            return null;
        }
        return null;
    }

    public String sertifikaSahibiSehirAl() {
        if (this.karttakiSertifika != null) {
            return this.karttakiSertifika.gettbsCertificate().getsubject().getL();
        }
        return null;
    }

    public String sertifikaSahibiSehirAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                return this.tumSertifikalar[i].getCertificate().gettbsCertificate().getsubject().getL();
            }
            return null;
        }
        return null;
    }

    public String sertifikaSahibiKurumAl() {
        if (this.karttakiSertifika != null) {
            return this.karttakiSertifika.gettbsCertificate().getsubject().getO();
        }
        return null;
    }

    public String sertifikaSahibiKurumAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                return this.tumSertifikalar[i].getCertificate().gettbsCertificate().getsubject().getO();
            }
            return null;
        }
        return null;
    }

    public String sertifikaKokIsimAl() {
        if (this.karttakiSertifika != null) {
            return this.karttakiSertifika.gettbsCertificate().getissuer().getCN();
        }
        return null;
    }

    public String sertifikaKokIsimAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                return this.tumSertifikalar[i].getCertificate().gettbsCertificate().getissuer().getCN();
            }
            return null;
        }
        return null;
    }

    public byte[] sertifikaKokDNAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                return this.tumSertifikalar[i].getCertificate().gettbsCertificate().getissuer().getEncoded();
            }
            return null;
        }
        return null;
    }

    public Date sertifikaGecerlilikBaslangicAl() {
        if (this.karttakiSertifika != null) {
            UTCTime utc = (UTCTime)this.karttakiSertifika.gettbsCertificate().getvalidity().getnotBefore().getValue();
            return (Date)utc.getValue();
        }
        return null;
    }

    public Date sertifikaGecerlilikBaslangicAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                UTCTime utc = (UTCTime)this.tumSertifikalar[i].getCertificate().gettbsCertificate().getvalidity().getnotBefore().getValue();
                return (Date)utc.getValue();
            }
            return null;
        }
        return null;
    }

    public Date sertifikaGecerlilikBitisAl() {
        if (this.karttakiSertifika != null) {
            UTCTime utc = (UTCTime)this.karttakiSertifika.gettbsCertificate().getvalidity().getnotAfter().getValue();
            return (Date)utc.getValue();
        }
        return null;
    }

    public Date sertifikaGecerlilikBitisAl(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                UTCTime utc = (UTCTime)this.tumSertifikalar[i].getCertificate().gettbsCertificate().getvalidity().getnotAfter().getValue();
                return (Date)utc.getValue();
            }
            return null;
        }
        return null;
    }

    public boolean sertifikaNitelikKontroluYap() {
        if (this.karttakiSertifika != null) {
            Extension qcExt = this.karttakiSertifika.gettbsCertificate().getextensions().getExtensionByOID("1.3.6.1.5.5.7.1.3");
            if (qcExt == null) {
                return false;
            }
            QCStatements qcs = new QCStatements();
            qcs.decodeExtVal((byte[])qcExt.getextnValue().getValue());
            Vector statsVec = qcs.getStatements();
            boolean etsiIDExists = false;
            boolean tkIDExists = false;
            for (int i = 0; i < statsVec.size(); ++i) {
                QCStatement qctemp = (QCStatement)statsVec.elementAt(i);
                if (((String)qctemp.getStatementId().getValue()).equals("0.4.0.1862.1.1")) {
                    etsiIDExists = true;
                }
                if (!((String)qctemp.getStatementId().getValue()).equals("2.16.792.1.61.0.1.5070.1.1")) continue;
                tkIDExists = true;
            }
            return etsiIDExists && tkIDExists;
        }
        return false;
    }

    public boolean sertifikaNitelikKontroluYap(byte[] sertifikaId) {
        if (this.tumSertifikalar != null) {
            for (int i = 0; i < this.tumSertifikalar.length; ++i) {
                if (!ImzaIslemNesnesi.areByteArraysEqual(sertifikaId, this.tumSertifikalar[i].getIdBytes())) continue;
                Extension qcExt = this.tumSertifikalar[i].getCertificate().gettbsCertificate().getextensions().getExtensionByOID("1.3.6.1.5.5.7.1.3");
                if (qcExt == null) {
                    return false;
                }
                QCStatements qcs = new QCStatements();
                qcs.decodeExtVal((byte[])qcExt.getextnValue().getValue());
                Vector statsVec = qcs.getStatements();
                boolean etsiIDExists = false;
                boolean tkIDExists = false;
                for (int j = 0; j < statsVec.size(); ++j) {
                    QCStatement qctemp = (QCStatement)statsVec.elementAt(j);
                    if (((String)qctemp.getStatementId().getValue()).equals("0.4.0.1862.1.1")) {
                        etsiIDExists = true;
                    }
                    if (!((String)qctemp.getStatementId().getValue()).equals("2.16.792.1.61.0.1.5070.1.1")) continue;
                    tkIDExists = true;
                }
                return etsiIDExists && tkIDExists;
            }
            return false;
        }
        return false;
    }

    public byte[] imzadanSertifikaAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            return signerCert.getEncoded();
        }
        return null;
    }

    public String imzadanSertifikaSeriNumarasiAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            BigInteger serial = (BigInteger)signerCert.gettbsCertificate().getserialNumber().getValue();
            return serial.toString();
        }
        return null;
    }

    public String imzadanSertifikaSahibiIsimAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            return signerCert.gettbsCertificate().getsubject().getCN();
        }
        return null;
    }

    public String imzadanSertifikaSahibiTanimlayiciNoAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            return signerCert.gettbsCertificate().getsubject().getSerialNo();
        }
        return null;
    }

    public String imzadanSertifikaSahibiUlkeKoduAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            return signerCert.gettbsCertificate().getsubject().getC();
        }
        return null;
    }

    public String imzadanSertifikaSahibiSehirAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            return signerCert.gettbsCertificate().getsubject().getL();
        }
        return null;
    }

    public String imzadanSertifikaSahibiKurumAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            return signerCert.gettbsCertificate().getsubject().getO();
        }
        return null;
    }

    public String imzadanOlusturmaZamaniniAl(byte[] imza) {
        return ImzaIslemNesnesi.extractSigningTimeFromCMSSignedData(imza);
    }

    public Date imzadanSertifikaGecerlilikBaslangicAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            UTCTime utc = (UTCTime)signerCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
            return (Date)utc.getValue();
        }
        return null;
    }

    public Date imzadanSertifikaGecerlilikBitisAl(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            UTCTime utc = (UTCTime)signerCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
            return (Date)utc.getValue();
        }
        return null;
    }

    public boolean imzadanSertifikaNitelikKontroluYap(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert != null) {
            Extension qcExt = signerCert.gettbsCertificate().getextensions().getExtensionByOID("1.3.6.1.5.5.7.1.3");
            if (qcExt == null) {
                return false;
            }
            QCStatements qcs = new QCStatements();
            qcs.decodeExtVal((byte[])qcExt.getextnValue().getValue());
            Vector statsVec = qcs.getStatements();
            boolean etsiIDExists = false;
            boolean tkIDExists = false;
            for (int i = 0; i < statsVec.size(); ++i) {
                QCStatement qctemp = (QCStatement)statsVec.elementAt(i);
                if (((String)qctemp.getStatementId().getValue()).equals("0.4.0.1862.1.1")) {
                    etsiIDExists = true;
                }
                if (!((String)qctemp.getStatementId().getValue()).equals("2.16.792.1.61.0.1.5070.1.1")) continue;
                tkIDExists = true;
            }
            return etsiIDExists && tkIDExists;
        }
        return false;
    }

    public int imzadanSertifikaOCSPSorgusuYap(byte[] imza) throws OCSPException {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert == null) {
            return 40;
        }
        Certificate issuerCert = ImzaIslemNesnesi.extractIssuerCertFromCMSSignedData(imza);
        if (issuerCert == null) {
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                if (!SertifikaFabrikasi.verifyCertificate(signerCert, (Certificate)this.kokSertifikalar.elementAt(i))) continue;
                issuerCert = (Certificate)this.kokSertifikalar.elementAt(i);
            }
        }
        if (issuerCert == null) {
            return 41;
        }
        Vector sorguSonucVec = this.ocspSorgusuYap(signerCert, issuerCert, null, this.baglantiZamanAsimiSaniyesi, this.ocspHatalarindaExceptionKullan);
        int sorguSonuc = (Integer)sorguSonucVec.elementAt(0);
        if (sorguSonuc == 50 && sorguSonucVec.size() > 2) {
            this.ocspSonSorgudaIptalNedeni = (Integer)sorguSonucVec.elementAt(1);
            this.ocspSonSorgudaIptalTarihi = (Date)sorguSonucVec.elementAt(2);
        } else {
            this.ocspSonSorgudaIptalNedeni = 0;
            this.ocspSonSorgudaIptalTarihi = null;
        }
        this.ocspSonSorgudaHataKodu = sorguSonuc == 49 || sorguSonuc == 50 || sorguSonuc == 51 ? 52 : sorguSonuc;
        return sorguSonuc;
    }

    public byte[] imzadanSertifikaOCSPSorgusuYapTumCevabiVer(byte[] imza) throws OCSPException {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert == null) {
            this.ocspSonSorgudaHataKodu = 40;
            return null;
        }
        Certificate issuerCert = ImzaIslemNesnesi.extractIssuerCertFromCMSSignedData(imza);
        if (issuerCert == null) {
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                if (!SertifikaFabrikasi.verifyCertificate(signerCert, (Certificate)this.kokSertifikalar.elementAt(i))) continue;
                issuerCert = (Certificate)this.kokSertifikalar.elementAt(i);
            }
        }
        if (issuerCert == null) {
            this.ocspSonSorgudaHataKodu = 41;
            return null;
        }
        Vector sorguSonucVec = this.ocspSorgusuYap(signerCert, issuerCert, null, this.baglantiZamanAsimiSaniyesi, this.ocspHatalarindaExceptionKullan);
        int sorguSonuc = (Integer)sorguSonucVec.elementAt(0);
        if (sorguSonuc == 49 || sorguSonuc == 50 || sorguSonuc == 51) {
            this.ocspSonSorgudaHataKodu = 52;
            if (sorguSonucVec.size() == 2) {
                return ((BasicOCSPResponse)sorguSonucVec.elementAt(1)).getEncoded();
            }
            if (sorguSonuc == 50) {
                this.ocspSonSorgudaIptalNedeni = (Integer)sorguSonucVec.elementAt(1);
                this.ocspSonSorgudaIptalTarihi = (Date)sorguSonucVec.elementAt(2);
            }
            return ((BasicOCSPResponse)sorguSonucVec.elementAt(3)).getEncoded();
        }
        this.ocspSonSorgudaHataKodu = sorguSonuc;
        return null;
    }

    public byte[] imzadanSertifikaOCSPSorgusuYapTumCevabiVer(byte[] imza, String ocspAdresi) throws Exception {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert == null) {
            this.ocspSonSorgudaHataKodu = 40;
            return null;
        }
        Certificate issuerCert = ImzaIslemNesnesi.extractIssuerCertFromCMSSignedData(imza);
        if (issuerCert == null) {
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                if (!SertifikaFabrikasi.verifyCertificate(signerCert, (Certificate)this.kokSertifikalar.elementAt(i))) continue;
                issuerCert = (Certificate)this.kokSertifikalar.elementAt(i);
            }
        }
        if (issuerCert == null) {
            this.ocspSonSorgudaHataKodu = 41;
            return null;
        }
        Vector sorguSonucVec = this.ocspSorgusuYap(signerCert, issuerCert, ocspAdresi, this.baglantiZamanAsimiSaniyesi, this.ocspHatalarindaExceptionKullan);
        int sorguSonuc = (Integer)sorguSonucVec.elementAt(0);
        if (sorguSonuc == 49 || sorguSonuc == 50 || sorguSonuc == 51) {
            this.ocspSonSorgudaHataKodu = 52;
            if (sorguSonucVec.size() == 2) {
                return ((BasicOCSPResponse)sorguSonucVec.elementAt(1)).getEncoded();
            }
            if (sorguSonuc == 50) {
                this.ocspSonSorgudaIptalNedeni = (Integer)sorguSonucVec.elementAt(1);
                this.ocspSonSorgudaIptalTarihi = (Date)sorguSonucVec.elementAt(2);
            }
            return ((BasicOCSPResponse)sorguSonucVec.elementAt(3)).getEncoded();
        }
        this.ocspSonSorgudaHataKodu = sorguSonuc;
        return null;
    }

    public int imzadanSertifikaCRLKontroluYap(byte[] imza) {
        Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
        if (signerCert == null) {
            return 65;
        }
        CertificateList crl = CRLFabrikasi.downloadCRL(signerCert);
        if (crl == null) {
            return 60;
        }
        return this.crlKontroluYap(signerCert, crl);
    }

    public int imzadanSertifikaCRLKontroluYap(byte[] imza, File crlDosyasi) {
        if (!crlDosyasi.exists()) {
            return 60;
        }
        CertificateList crl = new CertificateList("crl");
        byte[] crlBytes = null;
        try {
            FileInputStream fis = new FileInputStream(crlDosyasi);
            crlBytes = new byte[fis.available()];
            fis.read(crlBytes);
            fis.close();
        }
        catch (Exception exc) {
            return 60;
        }
        try {
            crl.decode(crlBytes);
            Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
            if (signerCert == null) {
                return 65;
            }
            Certificate issuerCert = ImzaIslemNesnesi.extractIssuerCertFromCMSSignedData(imza);
            if (issuerCert == null) {
                for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                    if (!SertifikaFabrikasi.verifyCertificate(signerCert, (Certificate)this.kokSertifikalar.elementAt(i))) continue;
                    issuerCert = (Certificate)this.kokSertifikalar.elementAt(i);
                }
            }
            if (issuerCert == null) {
                return 62;
            }
            if (!crl.gettbsCertList().getissuer().isEqualTo(issuerCert.gettbsCertificate().getsubject())) {
                return 63;
            }
            if (!CRLFabrikasi.verifyCRL(crl, issuerCert)) {
                return 64;
            }
            RevokedCertificate revcert = CRLFabrikasi.isCertificateInCRL(signerCert, crl);
            if (revcert == null) {
                this.crlSonKontroldeIptalNedeni = 0;
                this.crlSonKontroldeIptalTarihi = null;
                return 66;
            }
            try {
                this.crlSonKontroldeIptalTarihi = (Date)((GeneralizedTime)revcert.getRevocationDate().getValue()).getValue();
            }
            catch (ClassCastException ccexc) {
                this.crlSonKontroldeIptalTarihi = (Date)((UTCTime)revcert.getRevocationDate().getValue()).getValue();
            }
            Extension extReas = revcert.getExtensions().getExtensionByOID("2.5.29.21");
            if (extReas != null) {
                CRLReason crlReas = new CRLReason();
                crlReas.decodeExtVal((byte[])extReas.getextnValue().getValue());
                this.crlSonKontroldeIptalNedeni = crlReas.getReasonCode();
            } else {
                this.crlSonKontroldeIptalNedeni = 0;
            }
            return 67;
        }
        catch (Exception exc) {
            return 61;
        }
    }

    public byte[] imzadanIcerikZamanDamgasiOku(byte[] imzaBytes) {
        try {
            SignerInfo lastSinfo;
            Attribute attContentTimeStamp;
            if (imzaBytes[0] == 48 && imzaBytes[1] == -128) {
                imzaBytes = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(imzaBytes);
            }
            if ((attContentTimeStamp = CMSFabrikasi.imzadaSignedAttributeBul(lastSinfo = CMSFabrikasi.extractLastSignerInfoFromCMSSignedData(imzaBytes), "1.2.840.113549.1.9.16.2.20")) == null) {
                return null;
            }
            Any contentTimestampAttVal = (Any)((Vector)attContentTimeStamp.getvalues().getValue()).elementAt(0);
            ContentTimeStamp cts = new ContentTimeStamp();
            cts.decode((byte[])contentTimestampAttVal.getValue());
            return cts.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public String imzadanProfilNesneTanimlayiciOku(byte[] imzaBytes) {
        try {
            SignerInfo lastSinfo;
            Attribute attSignaturePolicyId;
            if (imzaBytes[0] == 48 && imzaBytes[1] == -128) {
                imzaBytes = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(imzaBytes);
            }
            if ((attSignaturePolicyId = CMSFabrikasi.imzadaSignedAttributeBul(lastSinfo = CMSFabrikasi.extractLastSignerInfoFromCMSSignedData(imzaBytes), "1.2.840.113549.1.9.16.2.15")) == null) {
                return null;
            }
            Any signaturePolicyIdAttVal = (Any)((Vector)attSignaturePolicyId.getvalues().getValue()).elementAt(0);
            SignaturePolicyIdentifier spid = new SignaturePolicyIdentifier();
            spid.decode((byte[])signaturePolicyIdAttVal.getValue());
            SignaturePolicyId pid = (SignaturePolicyId)spid.getValue();
            return (String)pid.getSigPolicyIdentifier().getValue();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public int sonOCSPSorgusunaGoreIptalNedeniniAl() {
        return this.ocspSonSorgudaIptalNedeni;
    }

    public Date sonOCSPSorgusunaGoreIptalTarihiniAl() {
        return this.ocspSonSorgudaIptalTarihi;
    }

    public int sonOCSPSorgusuHataKodunuAl() {
        return this.ocspSonSorgudaHataKodu;
    }

    public int sonCRLKontroluneGoreIptalNedeniniAl() {
        return this.crlSonKontroldeIptalNedeni;
    }

    public Date sonCRLKontroluneGoreIptalTarihiniAl() {
        return this.crlSonKontroldeIptalTarihi;
    }

    public int sonDogrulamadanKokAltKokSayisiAl() {
        return this.sonDogrulamaZincir.size();
    }

    public byte[] sonDogrulamadanKokAltKokSertifikaAl(int indeks) {
        if (indeks >= 0 && indeks < this.sonDogrulamaZincir.size()) {
            return ((Certificate)this.sonDogrulamaZincir.elementAt(indeks)).getEncoded();
        }
        return null;
    }

    public int shsSertifikalariIcinCRLYukle(File shsCrlDosyasi) {
        try {
            FileInputStream fis = new FileInputStream(shsCrlDosyasi);
            byte[] crlBytes = new byte[fis.available()];
            fis.read(crlBytes);
            fis.close();
            CertificateList crl = new CertificateList("crl");
            crl.decode(crlBytes);
            this.kokCRLVec.addElement(crl);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int shsSertifikalariIcinCRLYukle(byte[] shsCrlDosyasiByteDizisi) {
        try {
            CertificateList crl = new CertificateList("crl");
            crl.decode(shsCrlDosyasiByteDizisi);
            this.kokCRLVec.addElement(crl);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public byte[] shsSertifikalariIcinAdrestenCRLYukle(String shsCrlAdresi) {
        try {
            URL kokCrlURL = new URL(shsCrlAdresi);
            HttpURLConnection conn = (HttpURLConnection)kokCrlURL.openConnection();
            conn.connect();
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            byte[] buf = new byte[100];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            int r = bis.read(buf);
            while (r != -1) {
                bos.write(buf, 0, r);
                r = bis.read(buf);
            }
            bis.close();
            bos.flush();
            byte[] crlBytes = baos.toByteArray();
            bos.close();
            this.shsSertifikalariIcinCRLYukle(crlBytes);
            return crlBytes;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public void yuklenmisSHSSertifikalariniTemizle() {
        try {
            this.kokSertifikalar.clear();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void yuklenmisSHSSertifikasiCRLleriniTemizle() {
        try {
            this.kokCRLVec.clear();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void baglantiZamanAsimiSuresiBelirle(int sure) {
        this.baglantiZamanAsimiSaniyesi = sure;
    }

    public void ocspHatalarindaExceptionKullanimi(boolean kullanim) {
        this.ocspHatalarindaExceptionKullan = kullanim;
    }

    private static ContentInfo formCMSSignedData(byte[] orijinalVeri, Certificate cert, boolean orijVeriTut, byte[] sertifikaId, String hashObjectId, String orijinalVeriMimeType, String imzaProfilOID, String imzaProfilDokUrl, String imzaSahibiUlke, String imzaSahibiSehir, String commitmentTypeOidStr, byte[] contentIdBytes, byte[] contentTSTBytes, Date givenSigningTime) {
        try {
            EncapsulatedContentInfo eci = new EncapsulatedContentInfo("eci");
            ObjectID idData = new ObjectID("idData", "1.2.840.113549.1.7.1");
            ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
            byte[] tbsData = null;
            try {
                ContentInfo ci = new ContentInfo("ci");
                ci.decode(orijinalVeri);
                if (((String)ci.getcontentType().getValue()).equals((String)idSignedData.getValue())) {
                    return ImzaIslemNesnesi.formCounterSignature(ci, cert, sertifikaId, hashObjectId, orijinalVeriMimeType, imzaProfilOID, imzaProfilDokUrl, imzaSahibiUlke, imzaSahibiSehir, commitmentTypeOidStr, contentIdBytes, null, givenSigningTime);
                }
            }
            catch (Exception exc) {
                tbsData = orijinalVeri;
                eci.setEncapsulatedContentType(idData);
            }
            if (orijVeriTut) {
                OctetString tbsOctet = new OctetString("tbsOctet", tbsData);
                eci.setEncapsulatedContent(tbsOctet);
            }
            eci.commitElementUpdate();
            SignerInfo sinfo = new SignerInfo("sinfo");
            ASN1Integer cmsVersion = new ASN1Integer("cmsVersion", "1");
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber("iasn");
            iasn.setissuer(cert.gettbsCertificate().getissuer());
            com.turktrust.pkcs7.CertificateSerialNumber signerSerialNo = new com.turktrust.pkcs7.CertificateSerialNumber("signerSerial");
            signerSerialNo.setValue(cert.gettbsCertificate().getserialNumber());
            iasn.setserialNumber(signerSerialNo);
            iasn.commitElementUpdate();
            SignerIdentifier sid = new SignerIdentifier("sid");
            sid.setIssuerAndSerialNumber(iasn);
            ObjectID hashObjId = new ObjectID("Hash");
            hashObjId.setValue(hashObjectId);
            AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
            hashAlgId.setalgorithm(hashObjId);
            hashAlgId.commitElementUpdate();
            byte[] tbsDataHash = HashFabrikasi.hashAl(tbsData, hashObjectId);
            boolean contentHintsKullan = false;
            if (orijinalVeriMimeType != null) {
                contentHintsKullan = true;
            }
            ContentTimeStamp contentTST = null;
            if (contentTSTBytes != null) {
                contentTST = new ContentTimeStamp();
                contentTST.decode(contentTSTBytes);
            }
            SignedAttributes signedAttrs = CMSFabrikasi.signedAttributesOlustur(false, hashObjectId, tbsDataHash, cert, imzaProfilOID, SHA_256, BTK_PROFIL_PDF_DOKUMAN_OZET, imzaProfilDokUrl, contentHintsKullan, orijinalVeriMimeType, imzaSahibiUlke, imzaSahibiSehir, commitmentTypeOidStr, contentIdBytes, contentTST, givenSigningTime);
            ObjectID rsa_objId = new ObjectID("HashwithRSA");
            rsa_objId.setValue(ImzaFabrikasi.mapHashOIDToSignatureAlgorithmOID(hashObjectId));
            Null parNull2 = new Null("Null_par");
            Any anyNull2 = new Any("Any_null");
            anyNull2.setValue(parNull2);
            AlgorithmIdentifier rsaAlgId = new AlgorithmIdentifier("RSA");
            rsaAlgId.setalgorithm(rsa_objId);
            rsaAlgId.setparameters(anyNull2);
            rsaAlgId.commitElementUpdate();
            byte[] toBeSignedBytes = signedAttrs.getEncoded();
            byte[] hash = HashFabrikasi.hashAl(toBeSignedBytes, hashObjectId);
            OctetString sigOcts = new OctetString("hashOcts", hash);
            DigestInfo dinfo = new DigestInfo();
            dinfo.setDigestAlgorithmIdentifier(hashAlgId);
            dinfo.setDigest(sigOcts);
            dinfo.commitElementUpdate();
            byte[] sigBytes = null;
            sigBytes = sertifikaId == null ? Smartcard.sign(dinfo.getEncoded()) : Smartcard.signWithID(dinfo.getEncoded(), sertifikaId);
            OctetString signatureOcts = new OctetString("signatureOcts", sigBytes);
            sinfo.setCMSVersion(cmsVersion);
            sinfo.setSignerIdentifier(sid);
            sinfo.setDigestAlgorithm(hashAlgId);
            sinfo.setSignedAttributes(signedAttrs);
            sinfo.setSignatureAlgorithm(rsaAlgId);
            sinfo.setSignature(signatureOcts);
            sinfo.commitElementUpdate();
            SignedData sd = new SignedData("sd");
            ASN1Integer sdVersion = new ASN1Integer("sdVersion", "3");
            DigestAlgorithmIdentifiers dais = new DigestAlgorithmIdentifiers("dais");
            dais.addElement(hashAlgId);
            X509CertificateSet certset = new X509CertificateSet("certset");
            certset.addElement(cert);
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(sinfo);
            sd.setCMSVersion(sdVersion);
            sd.setDigestAlgorithms(dais);
            sd.setEncapContentInfo(eci);
            sd.setCertificates(certset);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ci = new ContentInfo("ci");
            ci.setcontentType(idSignedData);
            Any contSignedData = new Any("contSignedData", sd);
            ci.setcontent(contSignedData);
            ci.commitElementUpdate();
            return ci;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static ContentInfo formCounterSignature(ContentInfo existingSignatureCinfo, Certificate cert, byte[] sertifikaId, String hashObjectId, String orijinalVeriMimeType, String imzaProfilOID, String imzaProfilDokUrl, String imzaSahibiUlke, String imzaSahibiSehir, String commitmentTypeOidStr, byte[] contentIdBytes, byte[] contentTSTBytes, Date givenSigningTime) {
        try {
            byte[] existingSignatureBytes = existingSignatureCinfo.getEncoded();
            Vector previousCounterSigs = ImzaIslemNesnesi.getCounterSignaturesList(existingSignatureBytes);
            SignerInfo previousSinfo = null;
            byte[] sdBytes = (byte[])existingSignatureCinfo.getcontent().getValue();
            SignedData topLevelSignedData = new SignedData("topLevelSignedData");
            topLevelSignedData.setTaggingMethod(2);
            topLevelSignedData.setTagClass((byte)-128);
            topLevelSignedData.setTagNumber(0);
            topLevelSignedData.decode(sdBytes);
            if (previousCounterSigs.size() == 0) {
                previousSinfo = (SignerInfo)((Vector)topLevelSignedData.getSignerInfos().getValue()).elementAt(0);
            } else {
                Vector stripped = ImzaIslemNesnesi.removeLastCounterSignature(existingSignatureBytes);
                byte[] outerSinfoBytes = (byte[])stripped.elementAt(1);
                previousSinfo = new SignerInfo("outerSinfo");
                previousSinfo.decode(outerSinfoBytes);
            }
            byte[] tbsData = (byte[])previousSinfo.getSignature().getValue();
            SignerInfo newSinfo = new SignerInfo("sinfo");
            ASN1Integer cmsVersion = new ASN1Integer("cmsVersion", "1");
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber("iasn");
            iasn.setissuer(cert.gettbsCertificate().getissuer());
            com.turktrust.pkcs7.CertificateSerialNumber signerSerialNo = new com.turktrust.pkcs7.CertificateSerialNumber("signerSerial");
            signerSerialNo.setValue(cert.gettbsCertificate().getserialNumber());
            iasn.setserialNumber(signerSerialNo);
            iasn.commitElementUpdate();
            SignerIdentifier sid = new SignerIdentifier("sid");
            sid.setIssuerAndSerialNumber(iasn);
            ObjectID hashObjId = new ObjectID("Hash");
            hashObjId.setValue(hashObjectId);
            AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
            hashAlgId.setalgorithm(hashObjId);
            hashAlgId.commitElementUpdate();
            byte[] tbsDataHash = HashFabrikasi.hashAl(tbsData, hashObjectId);
            boolean contentHintsKullan = false;
            if (orijinalVeriMimeType != null) {
                contentHintsKullan = true;
            }
            SignedAttributes signedAttrs = CMSFabrikasi.signedAttributesOlustur(true, hashObjectId, tbsDataHash, cert, imzaProfilOID, SHA_256, BTK_PROFIL_PDF_DOKUMAN_OZET, imzaProfilDokUrl, contentHintsKullan, orijinalVeriMimeType, imzaSahibiUlke, imzaSahibiSehir, commitmentTypeOidStr, contentIdBytes, null, givenSigningTime);
            ObjectID rsa_objId = new ObjectID("HashwithRSA");
            rsa_objId.setValue(ImzaFabrikasi.mapHashOIDToSignatureAlgorithmOID(hashObjectId));
            Null parNull2 = new Null("Null_par");
            Any anyNull2 = new Any("Any_null");
            anyNull2.setValue(parNull2);
            AlgorithmIdentifier rsaAlgId = new AlgorithmIdentifier("RSA");
            rsaAlgId.setalgorithm(rsa_objId);
            rsaAlgId.setparameters(anyNull2);
            rsaAlgId.commitElementUpdate();
            byte[] toBeSignedBytes = signedAttrs.getEncoded();
            byte[] hash = HashFabrikasi.hashAl(toBeSignedBytes, hashObjectId);
            OctetString sigOcts = new OctetString("hashOcts", hash);
            DigestInfo dinfo = new DigestInfo();
            dinfo.setDigestAlgorithmIdentifier(hashAlgId);
            dinfo.setDigest(sigOcts);
            dinfo.commitElementUpdate();
            byte[] sigBytes = null;
            sigBytes = sertifikaId == null ? Smartcard.sign(dinfo.getEncoded()) : Smartcard.signWithID(dinfo.getEncoded(), sertifikaId);
            OctetString signatureOcts = new OctetString("signatureOcts", sigBytes);
            newSinfo.setCMSVersion(cmsVersion);
            newSinfo.setSignerIdentifier(sid);
            newSinfo.setDigestAlgorithm(hashAlgId);
            newSinfo.setSignedAttributes(signedAttrs);
            newSinfo.setSignatureAlgorithm(rsaAlgId);
            newSinfo.setSignature(signatureOcts);
            newSinfo.commitElementUpdate();
            Attribute attCounterSig = new Attribute("attCounterSig");
            AttributeType attTypeCounterSig = new AttributeType("attTypeCounterSig");
            attTypeCounterSig.setValue("1.2.840.113549.1.9.6");
            SetOf attValsCounterSig = new SetOf("attValsSigCert", new SignerInfo());
            attValsCounterSig.addElement(newSinfo);
            attCounterSig.settype(attTypeCounterSig);
            attCounterSig.setvalues(attValsCounterSig);
            attCounterSig.commitElementUpdate();
            if (previousSinfo.getUnsignedAttributes() != null && previousSinfo.getUnsignedAttributes().getValue() != null) {
                ((Vector)previousSinfo.getUnsignedAttributes().getValue()).add(attCounterSig);
            } else {
                UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                unsignedAttrs.addElement(attCounterSig);
                previousSinfo.setUnsignedAttributes(unsignedAttrs);
            }
            if (previousCounterSigs.size() > 0) {
                SignerInfo childSinfo = previousSinfo;
                for (int i = 0; i < previousCounterSigs.size() - 1; ++i) {
                    byte[] parentCinfoBytes = (byte[])previousCounterSigs.elementAt(i);
                    ContentInfo parentCinfo = new ContentInfo("ci");
                    parentCinfo.decode(parentCinfoBytes);
                    byte[] parentSdataBytes = (byte[])parentCinfo.getcontent().getValue();
                    SignedData parentSdata = new SignedData("sd");
                    parentSdata.setTaggingMethod(2);
                    parentSdata.setTagClass((byte)-128);
                    parentSdata.setTagNumber(0);
                    parentSdata.decode(parentSdataBytes);
                    SignerInfo parentSinfo = (SignerInfo)((Vector)parentSdata.getSignerInfos().getValue()).elementAt(0);
                    Attribute attCounterSigParent = new Attribute("attCounterSig");
                    SetOf attValsCounterSigParent = new SetOf("attValsSigCert", new SignerInfo());
                    attValsCounterSigParent.addElement(childSinfo);
                    attCounterSigParent.settype(attTypeCounterSig);
                    attCounterSigParent.setvalues(attValsCounterSigParent);
                    attCounterSigParent.commitElementUpdate();
                    if (parentSinfo.getUnsignedAttributes() != null && parentSinfo.getUnsignedAttributes().getValue() != null) {
                        ((Vector)parentSinfo.getUnsignedAttributes().getValue()).add(attCounterSigParent);
                    } else {
                        UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                        unsignedAttrs.addElement(attCounterSigParent);
                        parentSinfo.setUnsignedAttributes(unsignedAttrs);
                    }
                    childSinfo = parentSinfo;
                }
                SignerInfo topSinfo = (SignerInfo)((Vector)topLevelSignedData.getSignerInfos().getValue()).elementAt(0);
                Attribute attCounterSigParent = new Attribute("attCounterSig");
                SetOf attValsCounterSigParent = new SetOf("attValsSigCert", new SignerInfo());
                attValsCounterSigParent.addElement(childSinfo);
                attCounterSigParent.settype(attTypeCounterSig);
                attCounterSigParent.setvalues(attValsCounterSigParent);
                attCounterSigParent.commitElementUpdate();
                if (topSinfo.getUnsignedAttributes() != null && topSinfo.getUnsignedAttributes().getValue() != null) {
                    Vector topUnsignedAttsVec = (Vector)topSinfo.getUnsignedAttributes().getValue();
                    boolean updated = false;
                    for (int k = 0; k < topUnsignedAttsVec.size(); ++k) {
                        Attribute tempAtt = (Attribute)topUnsignedAttsVec.elementAt(k);
                        AttributeType tempType = tempAtt.gettype();
                        if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                        tempAtt.setvalues(attValsCounterSigParent);
                        tempAtt.commitElementUpdate();
                        updated = true;
                    }
                    if (!updated) {
                        topUnsignedAttsVec.addElement(attCounterSigParent);
                    }
                } else {
                    UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                    unsignedAttrs.addElement(attCounterSigParent);
                    topSinfo.setUnsignedAttributes(unsignedAttrs);
                }
            }
            Vector existingCertsVec = (Vector)topLevelSignedData.getCertificates().getValue();
            boolean foundCert = false;
            byte[] signerCertBytes = cert.getEncoded();
            for (int j = 0; j < existingCertsVec.size(); ++j) {
                Certificate tempCert = (Certificate)existingCertsVec.elementAt(j);
                if (!ImzaIslemNesnesi.areByteArraysEqual(signerCertBytes, tempCert.getEncoded())) continue;
                foundCert = true;
                break;
            }
            if (!foundCert) {
                ((Vector)topLevelSignedData.getCertificates().getValue()).addElement(cert);
            }
            ContentInfo ci = new ContentInfo("ci");
            ObjectID conTypeSignedDataObjId = new ObjectID("signedData", "1.2.840.113549.1.7.2");
            ci.setcontentType(conTypeSignedDataObjId);
            Any contSignedData = new Any("contSignedData", topLevelSignedData);
            ci.setcontent(contSignedData);
            ci.commitElementUpdate();
            return ci;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private Vector verifyCMSSignedData(byte[] ciBytes, byte[] origData) {
        try {
            Certificate rootestCertInSet;
            BaseASN1Object tempIssuer;
            Vector<Serializable> resultVec = new Vector<Serializable>();
            if (DogrulamaLog.aktif) {
                DogrulamaLog.init();
                DogrulamaLog.logEkle("\u0130mza kontrol\u00fc ba\u015fl\u0131yor...");
            }
            if (ciBytes[0] == 48 && ciBytes[1] == -128) {
                ciBytes = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(ciBytes);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(ciBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza veri yap\u0131s\u0131 SignedData i\u00e7ermiyor.");
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = null;
            int numCounterSignatures = ImzaIslemNesnesi.countCounterSignatures(ciBytes);
            if (numCounterSignatures > 0) {
                Vector lastSigStripped = ImzaIslemNesnesi.removeLastCounterSignature(ciBytes);
                byte[] lastSinfoBytes = (byte[])lastSigStripped.elementAt(1);
                SignerInfo lastSinfo = new SignerInfo("lastSinfo");
                lastSinfo.decode(lastSinfoBytes);
                byte[] parentSinfoBytesForLast = (byte[])lastSigStripped.elementAt(2);
                SignerInfo parentSinfo = new SignerInfo("parentSinfo");
                parentSinfo.decode(parentSinfoBytesForLast);
                byte[] newCinfoBytes = ImzaIslemNesnesi.putCounterSigInSeparateContentInfo(lastSinfo, (byte[])parentSinfo.getSignature().getValue(), sd.getCertificates());
                return this.verifyCMSSignedData(newCinfoBytes, origData);
            }
            sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            if (((BigInteger)sd.getCMSVersion().getValue()).intValue() != 1 && ((BigInteger)sd.getCMSVersion().getValue()).intValue() != 3) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza veri yap\u0131s\u0131nda CMS s\u00fcr\u00fcm\u00fc hatal\u0131.");
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            Vector algIdSet = (Vector)sd.getDigestAlgorithms().getValue();
            for (int i = 0; i < algIdSet.size(); ++i) {
                if (HashFabrikasi.algoritmaDesteklenmeKontrolu((String)((AlgorithmIdentifier)algIdSet.elementAt(i)).getalgorithm().getValue())) continue;
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mzada kullan\u0131lan \u00f6zet algoritmas\u0131 desteklenmiyor.");
                }
                resultVec.addElement(new Integer(23));
                return resultVec;
            }
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            if (!(eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.1") || eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.2") || eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.3") || eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.4"))) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza veri yap\u0131s\u0131nda EncapsulatedContentInfo tipi desteklenmiyor.");
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            byte[] origVerifBytes = origData == null ? (byte[])eci.getEncapsulatedContent().getValue() : origData;
            Vector certsvec = (Vector)sd.getCertificates().getValue();
            if (certsvec == null || certsvec.size() == 0) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza yap\u0131s\u0131nda sertifika bulunamad\u0131.");
                }
                resultVec.addElement(new Integer(26));
                return resultVec;
            }
            int sinfoVer = ((BigInteger)sinfo.getCMSVersion().getValue()).intValue();
            if (sinfoVer != 1 && sinfoVer != 3) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza veri yap\u0131s\u0131nda SignerInfo s\u00fcr\u00fcm\u00fc hatal\u0131.");
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            SignerIdentifier signid = sinfo.getSignerIdentifier();
            Certificate signerCert = null;
            IssuerAndSerialNumber iasn = null;
            OctetString keyHash = null;
            try {
                iasn = (IssuerAndSerialNumber)signid.getValue();
            }
            catch (ClassCastException cce) {
                keyHash = (OctetString)signid.getValue();
            }
            if (iasn != null) {
                Name signerCertIssuerName = iasn.getissuer();
                ASN1Integer serialAsnInt = new ASN1Integer("serialAsnInt");
                serialAsnInt.decode((byte[])iasn.getserialNumber().getValue());
                BigInteger signerCertSerialNo = (BigInteger)serialAsnInt.getValue();
                for (Certificate tempCert : certsvec) {
                    BigInteger tempSerialNo;
                    tempIssuer = tempCert.gettbsCertificate().getissuer();
                    if (!signerCertIssuerName.isEqualTo((Name)tempIssuer) || !signerCertSerialNo.equals(tempSerialNo = (BigInteger)tempCert.gettbsCertificate().getserialNumber().getValue())) continue;
                    signerCert = tempCert;
                }
            } else if (keyHash != null) {
                byte[] subjectKeyIdBytes = (byte[])keyHash.getValue();
                for (Certificate tempCert : certsvec) {
                    SubjectPublicKeyInfo spki = tempCert.gettbsCertificate().getsubjectPublicKeyInfo();
                    byte[] subjectPubKeyBytes = (byte[])spki.getsubjectPublicKey().getValue();
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    byte[] tempPubKeyHash = sha.digest(subjectPubKeyBytes);
                    if (subjectKeyIdBytes.length != tempPubKeyHash.length) continue;
                    boolean match = true;
                    for (int i = 0; i < subjectKeyIdBytes.length; ++i) {
                        if (subjectKeyIdBytes[i] == tempPubKeyHash[i]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    signerCert = tempCert;
                }
            }
            if (signerCert == null) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza sahibi sertifika bulunamad\u0131.");
                }
                resultVec.addElement(new Integer(26));
                return resultVec;
            }
            if (this.kokSertifikalar.size() == 0) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] K\u00f6k sertifika bulunamad\u0131.");
                }
                resultVec.addElement(new Integer(24));
                return resultVec;
            }
            boolean signerCertVerified = false;
            if (DogrulamaLog.aktif) {
                String cn = signerCert.gettbsCertificate().getsubject().getCN();
                BigInteger serial = (BigInteger)signerCert.gettbsCertificate().getserialNumber().getValue();
                String seriNo = serial.toString();
                DogrulamaLog.logEkle("\u0130mzalayan sertifika: CN=" + cn + ", Sertifika seri no= " + seriNo);
            }
            boolean directParentInTrustList = false;
            Certificate directParent = null;
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                Certificate tempIssuer2 = (Certificate)this.kokSertifikalar.elementAt(i);
                if (!SertifikaFabrikasi.verifyCertificate(signerCert, tempIssuer2)) continue;
                directParentInTrustList = true;
                signerCertVerified = true;
                directParent = tempIssuer2;
                break;
            }
            if (!directParentInTrustList && (rootestCertInSet = ImzaIslemNesnesi.findRootestIssuerInSet(signerCert, certsvec)) != null && rootestCertInSet != signerCert) {
                for (int j = 0; j < this.kokSertifikalar.size(); ++j) {
                    tempIssuer = (Certificate)this.kokSertifikalar.elementAt(j);
                    if (!SertifikaFabrikasi.verifyCertificate(rootestCertInSet, (Certificate)tempIssuer)) continue;
                    signerCertVerified = true;
                    break;
                }
            }
            if (!signerCertVerified) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza sahibi sertifika ESHS sertifikalar\u0131yla do\u011frulanamad\u0131.");
                }
                resultVec.addElement(new Integer(24));
                return resultVec;
            }
            if (directParent == null) {
                directParent = ImzaIslemNesnesi.findIssuerInSet(signerCert, certsvec);
            }
            this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(directParent, this.kokSertifikalar);
            if (this.sonDogrulamaZincir == null || this.sonDogrulamaZincir.size() == 0) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] ESHS Sertifika zinciri do\u011frulanamad\u0131.");
                }
                resultVec.addElement(new Integer(24));
                return resultVec;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("\u0130mza sahibi sertifika ESHS sertifikalar\u0131yla do\u011fruland\u0131.");
                for (int i = 0; i < this.sonDogrulamaZincir.size(); ++i) {
                    Certificate zincirCert = (Certificate)this.sonDogrulamaZincir.elementAt(i);
                    String cn = zincirCert.gettbsCertificate().getsubject().getCN();
                    BigInteger serial = (BigInteger)zincirCert.gettbsCertificate().getserialNumber().getValue();
                    DogrulamaLog.logEkle("ESHS:  CN = " + cn + ", Sertifika Seri No = " + serial.toString(10));
                }
            }
            if (!ImzaFabrikasi.algoritmaDesteklenmeKontrolu((String)sinfo.getSignatureAlgorithm().getalgorithm().getValue()) && !sinfo.getSignatureAlgorithm().getalgorithm().getValue().equals("1.2.840.113549.1.1.1")) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] SignerInfo - signatureAlgorithm alan\u0131nda beklenmeyen de\u011fer: " + sinfo.getSignatureAlgorithm().getalgorithm().getValue());
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            byte[] signerSpkiBytes = signerCert.gettbsCertificate().getsubjectPublicKeyInfo().getEncoded();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(signerSpkiBytes);
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            PublicKey signerPubKey = keyFac.generatePublic(xspec);
            byte[] sigBytes = (byte[])sinfo.getSignature().getValue();
            SignedAttributes signedAtts = sinfo.getSignedAttributes();
            byte[] signedAttsBytes = signedAtts.getEncoded();
            byte[] toBeVerifiedBytes = new byte[signedAttsBytes.length];
            System.arraycopy(signedAttsBytes, 0, toBeVerifiedBytes, 0, signedAttsBytes.length);
            toBeVerifiedBytes[0] = 49;
            if (ImzaFabrikasi.verifyPKCS1Signature(sigBytes, signerPubKey, toBeVerifiedBytes)) {
                byte[] origDataHash = null;
                if (!HashFabrikasi.algoritmaDesteklenmeKontrolu((String)sinfo.getDigestAlgorithm().getalgorithm().getValue())) {
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("[X] \u0130mzada kullan\u0131lan \u00f6zet algoritmas\u0131 desteklenmiyor.");
                    }
                    resultVec.addElement(new Integer(23));
                    resultVec.addElement(signerCert);
                    return resultVec;
                }
                origDataHash = HashFabrikasi.hashAl(origVerifBytes, (String)sinfo.getDigestAlgorithm().getalgorithm().getValue());
                boolean signingCertAttExists = false;
                boolean signingCertAttVerif = false;
                boolean vfSonuc = false;
                Vector sVec = (Vector)signedAtts.getValue();
                for (int i = 0; i < sVec.size(); ++i) {
                    BigInteger certNo;
                    CertificateSerialNumber csno;
                    BigInteger writtenNo;
                    boolean issSonuc;
                    Name issname;
                    GeneralName gname;
                    GeneralNames gnames;
                    boolean hkSonuc;
                    OctetString certhash;
                    byte[] signerCertHash;
                    Sequence sc;
                    Any scertAny;
                    Vector vVec;
                    Attribute at = (Attribute)sVec.elementAt(i);
                    if (((String)at.gettype().getValue()).equals("1.2.840.113549.1.9.4")) {
                        vVec = (Vector)at.getvalues().getValue();
                        Any ocsAny = (Any)vVec.get(0);
                        OctetString ocs = new OctetString("ocs");
                        ocs.decode((byte[])ocsAny.getValue());
                        byte[] imzalananDataninHashi = (byte[])ocs.getValue();
                        vfSonuc = ImzaIslemNesnesi.areByteArraysEqual(imzalananDataninHashi, origDataHash);
                        continue;
                    }
                    if (((String)at.gettype().getValue()).equals("1.2.840.113549.1.9.16.2.12")) {
                        signingCertAttExists = true;
                        vVec = (Vector)at.getvalues().getValue();
                        scertAny = (Any)vVec.get(0);
                        sc = new SigningCertificate("sc");
                        sc.decode((byte[])scertAny.getValue());
                        MessageDigest sha = MessageDigest.getInstance("SHA-1");
                        signerCertHash = sha.digest(signerCert.getEncoded());
                        certhash = ((ESSCertId)((SigningCertificate)sc).getESSCertIds().elementAt(0)).getCertHash();
                        hkSonuc = ImzaIslemNesnesi.areByteArraysEqual(signerCertHash, (byte[])certhash.getValue());
                        if (!hkSonuc) continue;
                        gnames = ((ESSCertId)((SigningCertificate)sc).getESSCertIds().elementAt(0)).getIssuerSerial().getIssuer();
                        if (gnames != null && ((Vector)gnames.getValue()).size() > 0) {
                            gname = (GeneralName)((Vector)gnames.getValue()).elementAt(0);
                            issname = gname.getDirectoryName();
                            issSonuc = issname.isEqualTo(signerCert.gettbsCertificate().getissuer());
                            if (!issSonuc || !(writtenNo = (BigInteger)(csno = ((ESSCertId)((SigningCertificate)sc).getESSCertIds().elementAt(0)).getIssuerSerial().getSerialNumber()).getValue()).equals(certNo = (BigInteger)signerCert.gettbsCertificate().getserialNumber().getValue())) continue;
                            signingCertAttVerif = true;
                            continue;
                        }
                        signingCertAttVerif = true;
                        continue;
                    }
                    if (!((String)at.gettype().getValue()).equals("1.2.840.113549.1.9.16.2.47")) continue;
                    signingCertAttExists = true;
                    vVec = (Vector)at.getvalues().getValue();
                    scertAny = (Any)vVec.get(0);
                    sc = new SigningCertificateV2("sc");
                    sc.decode((byte[])scertAny.getValue());
                    String hasAlgObjIdStr = (String)((ESSCertIdv2)((SigningCertificateV2)sc).getESSCertIds().elementAt(0)).getHashAlgorithm().getalgorithm().getValue();
                    signerCertHash = HashFabrikasi.hashAl(signerCert.getEncoded(), hasAlgObjIdStr);
                    certhash = ((ESSCertIdv2)((SigningCertificateV2)sc).getESSCertIds().elementAt(0)).getCertHash();
                    hkSonuc = ImzaIslemNesnesi.areByteArraysEqual(signerCertHash, (byte[])certhash.getValue());
                    if (!hkSonuc) continue;
                    gnames = ((ESSCertIdv2)((SigningCertificateV2)sc).getESSCertIds().elementAt(0)).getIssuerSerial().getIssuer();
                    if (gnames != null && ((Vector)gnames.getValue()).size() > 0) {
                        gname = (GeneralName)((Vector)gnames.getValue()).elementAt(0);
                        issname = gname.getDirectoryName();
                        issSonuc = issname.isEqualTo(signerCert.gettbsCertificate().getissuer());
                        if (!issSonuc || !(writtenNo = (BigInteger)(csno = ((ESSCertIdv2)((SigningCertificateV2)sc).getESSCertIds().elementAt(0)).getIssuerSerial().getSerialNumber()).getValue()).equals(certNo = (BigInteger)signerCert.gettbsCertificate().getserialNumber().getValue())) continue;
                        signingCertAttVerif = true;
                        continue;
                    }
                    signingCertAttVerif = true;
                }
                if (DogrulamaLog.aktif) {
                    if (!vfSonuc) {
                        DogrulamaLog.logEkle("[X] \u0130mza matematiksel olarak do\u011frulanamad\u0131.");
                    } else {
                        DogrulamaLog.logEkle("\u0130mza matematiksel olarak do\u011fruland\u0131.");
                    }
                    if (!signingCertAttExists) {
                        DogrulamaLog.logEkle("[X] \u0130mzalayan sertifika bilgisi bulunamad\u0131.");
                    }
                    if (!signingCertAttVerif) {
                        DogrulamaLog.logEkle("[X] \u0130mzalayan sertifika bilgisi do\u011frulanamad\u0131.");
                    } else {
                        DogrulamaLog.logEkle("\u0130mzalayan sertifika bilgisi do\u011fruland\u0131.");
                    }
                }
                if (vfSonuc && signingCertAttExists && signingCertAttVerif) {
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("Do\u011frulama Sonucu: \u0130mza ge\u00e7erli.");
                    }
                    resultVec.addElement(new Integer(20));
                    resultVec.addElement(signerCert);
                } else {
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("[X] Do\u011frulama Sonucu: \u0130mza ge\u00e7ersiz.");
                    }
                    resultVec.addElement(new Integer(21));
                    resultVec.addElement(signerCert);
                }
                return resultVec;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[X] \u0130mza matematiksel olarak do\u011frulanamad\u0131.");
            }
            resultVec.addElement(new Integer(21));
            resultVec.addElement(signerCert);
            return resultVec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Vector<Integer> resultVec = new Vector<Integer>();
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[X] Do\u011frulama s\u0131ras\u0131nda hata olu\u015ftu.");
            }
            resultVec.addElement(new Integer(25));
            return resultVec;
        }
    }

    private Vector verifyCMSSignedDataFromFileInput(byte[] ciBytes, String origDataFilename) {
        try {
            Certificate rootestCertInSet;
            BaseASN1Object tempIssuer;
            File origDataFile;
            Vector<Serializable> resultVec = new Vector<Serializable>();
            if (DogrulamaLog.aktif) {
                DogrulamaLog.init();
                DogrulamaLog.logEkle("\u0130mza kontrol\u00fc ba\u015fl\u0131yor...");
            }
            if (!(origDataFile = new File(origDataFilename)).exists()) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] Orijinal veri dosyas\u0131 bulunamad\u0131.");
                }
                resultVec.addElement(new Integer(82));
                return resultVec;
            }
            if (ciBytes[0] == 48 && ciBytes[1] == -128) {
                ciBytes = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(ciBytes);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(ciBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza veri yap\u0131s\u0131 SignedData i\u00e7ermiyor.");
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            if (((BigInteger)sd.getCMSVersion().getValue()).intValue() != 1 && ((BigInteger)sd.getCMSVersion().getValue()).intValue() != 3) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza veri yap\u0131s\u0131nda CMS s\u00fcr\u00fcm\u00fc hatal\u0131.");
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            Vector algIdSet = (Vector)sd.getDigestAlgorithms().getValue();
            for (int i = 0; i < algIdSet.size(); ++i) {
                if (HashFabrikasi.algoritmaDesteklenmeKontrolu((String)((AlgorithmIdentifier)algIdSet.elementAt(i)).getalgorithm().getValue())) continue;
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mzada kullan\u0131lan \u00f6zet algoritmas\u0131 desteklenmiyor.");
                }
                resultVec.addElement(new Integer(23));
                return resultVec;
            }
            EncapsulatedContentInfo eci = sd.getEncapContentInfo();
            if (!(eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.1") || eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.2") || eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.3") || eci.getEncapsulatedContentType().getValue().equals("1.2.840.113549.1.7.4"))) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza veri yap\u0131s\u0131nda EncapsulatedContentInfo tipi desteklenmiyor.");
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            Vector certsvec = (Vector)sd.getCertificates().getValue();
            if (certsvec == null || certsvec.size() == 0) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza yap\u0131s\u0131nda sertifika bulunamad\u0131.");
                }
                resultVec.addElement(new Integer(26));
                return resultVec;
            }
            int sinfoVer = ((BigInteger)sinfo.getCMSVersion().getValue()).intValue();
            if (sinfoVer != 1 && sinfoVer != 3) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza veri yap\u0131s\u0131nda SignerInfo s\u00fcr\u00fcm\u00fc hatal\u0131.");
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            SignerIdentifier signid = sinfo.getSignerIdentifier();
            Certificate signerCert = null;
            IssuerAndSerialNumber iasn = null;
            OctetString keyHash = null;
            try {
                iasn = (IssuerAndSerialNumber)signid.getValue();
            }
            catch (ClassCastException cce) {
                keyHash = (OctetString)signid.getValue();
            }
            if (iasn != null) {
                Name signerCertIssuerName = iasn.getissuer();
                ASN1Integer serialAsnInt = new ASN1Integer("serialAsnInt");
                serialAsnInt.decode((byte[])iasn.getserialNumber().getValue());
                BigInteger signerCertSerialNo = (BigInteger)serialAsnInt.getValue();
                for (Certificate tempCert : certsvec) {
                    BigInteger tempSerialNo;
                    tempIssuer = tempCert.gettbsCertificate().getissuer();
                    if (!signerCertIssuerName.isEqualTo((Name)tempIssuer) || !signerCertSerialNo.equals(tempSerialNo = (BigInteger)tempCert.gettbsCertificate().getserialNumber().getValue())) continue;
                    signerCert = tempCert;
                }
            } else if (keyHash != null) {
                byte[] subjectKeyIdBytes = (byte[])keyHash.getValue();
                for (Certificate tempCert : certsvec) {
                    SubjectPublicKeyInfo spki = tempCert.gettbsCertificate().getsubjectPublicKeyInfo();
                    byte[] subjectPubKeyBytes = (byte[])spki.getsubjectPublicKey().getValue();
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    byte[] tempPubKeyHash = sha.digest(subjectPubKeyBytes);
                    if (subjectKeyIdBytes.length != tempPubKeyHash.length) continue;
                    boolean match = true;
                    for (int i = 0; i < subjectKeyIdBytes.length; ++i) {
                        if (subjectKeyIdBytes[i] == tempPubKeyHash[i]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    signerCert = tempCert;
                }
            }
            if (signerCert == null) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza sahibi sertifika bulunamad\u0131.");
                }
                resultVec.addElement(new Integer(26));
                return resultVec;
            }
            if (this.kokSertifikalar.size() == 0) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] K\u00f6k sertifika bulunamad\u0131.");
                }
                resultVec.addElement(new Integer(24));
                return resultVec;
            }
            boolean signerCertVerified = false;
            if (DogrulamaLog.aktif) {
                String cn = signerCert.gettbsCertificate().getsubject().getCN();
                BigInteger serial = (BigInteger)signerCert.gettbsCertificate().getserialNumber().getValue();
                String seriNo = serial.toString();
                DogrulamaLog.logEkle("\u0130mzalayan sertifika: CN=" + cn + ", Sertifika seri no= " + seriNo);
            }
            boolean directParentInTrustList = false;
            Certificate directParent = null;
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                Certificate tempIssuer2 = (Certificate)this.kokSertifikalar.elementAt(i);
                if (!SertifikaFabrikasi.verifyCertificate(signerCert, tempIssuer2)) continue;
                directParentInTrustList = true;
                signerCertVerified = true;
                directParent = tempIssuer2;
                break;
            }
            if (!directParentInTrustList && (rootestCertInSet = ImzaIslemNesnesi.findRootestIssuerInSet(signerCert, certsvec)) != null && rootestCertInSet != signerCert) {
                for (int j = 0; j < this.kokSertifikalar.size(); ++j) {
                    tempIssuer = (Certificate)this.kokSertifikalar.elementAt(j);
                    if (!SertifikaFabrikasi.verifyCertificate(rootestCertInSet, (Certificate)tempIssuer)) continue;
                    signerCertVerified = true;
                    break;
                }
            }
            if (!signerCertVerified) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] \u0130mza sahibi sertifika ESHS sertifikalar\u0131yla do\u011frulanamad\u0131.");
                }
                resultVec.addElement(new Integer(24));
                return resultVec;
            }
            if (directParent == null) {
                directParent = ImzaIslemNesnesi.findIssuerInSet(signerCert, certsvec);
            }
            this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(directParent, this.kokSertifikalar);
            if (this.sonDogrulamaZincir == null || this.sonDogrulamaZincir.size() == 0) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] ESHS Sertifika zinciri do\u011frulanamad\u0131.");
                }
                resultVec.addElement(new Integer(24));
                return resultVec;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("\u0130mza sahibi sertifika ESHS sertifikalar\u0131yla do\u011fruland\u0131.");
                for (int i = 0; i < this.sonDogrulamaZincir.size(); ++i) {
                    Certificate zincirCert = (Certificate)this.sonDogrulamaZincir.elementAt(i);
                    String cn = zincirCert.gettbsCertificate().getsubject().getCN();
                    BigInteger serial = (BigInteger)zincirCert.gettbsCertificate().getserialNumber().getValue();
                    DogrulamaLog.logEkle("ESHS:  CN = " + cn + ", Sertifika Seri No = " + serial.toString(10));
                }
            }
            if (!ImzaFabrikasi.algoritmaDesteklenmeKontrolu((String)sinfo.getSignatureAlgorithm().getalgorithm().getValue()) && !sinfo.getSignatureAlgorithm().getalgorithm().getValue().equals("1.2.840.113549.1.1.1")) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[X] SignerInfo - signatureAlgorithm alan\u0131nda beklenmeyen de\u011fer: " + sinfo.getSignatureAlgorithm().getalgorithm().getValue());
                }
                resultVec.addElement(new Integer(25));
                return resultVec;
            }
            byte[] signerSpkiBytes = signerCert.gettbsCertificate().getsubjectPublicKeyInfo().getEncoded();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(signerSpkiBytes);
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            PublicKey signerPubKey = keyFac.generatePublic(xspec);
            byte[] sigBytes = (byte[])sinfo.getSignature().getValue();
            SignedAttributes signedAtts = sinfo.getSignedAttributes();
            byte[] signedAttsBytes = signedAtts.getEncoded();
            byte[] toBeVerifiedBytes = new byte[signedAttsBytes.length];
            System.arraycopy(signedAttsBytes, 0, toBeVerifiedBytes, 0, signedAttsBytes.length);
            toBeVerifiedBytes[0] = 49;
            if (ImzaFabrikasi.verifyPKCS1Signature(sigBytes, signerPubKey, toBeVerifiedBytes)) {
                FileInputStream fis;
                MessageDigest mdig2;
                byte[] origDataHash = null;
                if (HashFabrikasi.algoritmaDesteklenmeKontrolu((String)sinfo.getDigestAlgorithm().getalgorithm().getValue())) {
                    byte[] buffer;
                    int readCount;
                    mdig2 = HashFabrikasi.messageDigestNesnesiAl((String)sinfo.getDigestAlgorithm().getalgorithm().getValue());
                    int blockSize = 102400;
                    fis = new FileInputStream(origDataFilename);
                    while ((readCount = fis.read(buffer = new byte[blockSize])) != -1) {
                        byte[] hashInput = null;
                        if (readCount < blockSize) {
                            hashInput = new byte[readCount];
                            System.arraycopy(buffer, 0, hashInput, 0, readCount);
                        } else {
                            hashInput = buffer;
                        }
                        mdig2.update(hashInput);
                    }
                } else {
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("[X] \u0130mzada kullan\u0131lan \u00f6zet algoritmas\u0131 desteklenmiyor.");
                    }
                    resultVec.addElement(new Integer(23));
                    resultVec.addElement(signerCert);
                    return resultVec;
                }
                fis.close();
                origDataHash = mdig2.digest();
                boolean signingCertAttExists = false;
                boolean signingCertAttVerif = false;
                boolean vfSonuc = false;
                Vector sVec = (Vector)signedAtts.getValue();
                for (int i = 0; i < sVec.size(); ++i) {
                    BigInteger certNo;
                    CertificateSerialNumber csno;
                    BigInteger writtenNo;
                    boolean issSonuc;
                    Name issname;
                    GeneralName gname;
                    GeneralNames gnames;
                    boolean hkSonuc;
                    OctetString certhash;
                    byte[] signerCertHash;
                    Sequence sc;
                    Any scertAny;
                    Vector vVec;
                    Attribute at = (Attribute)sVec.elementAt(i);
                    if (((String)at.gettype().getValue()).equals("1.2.840.113549.1.9.4")) {
                        vVec = (Vector)at.getvalues().getValue();
                        Any ocsAny = (Any)vVec.get(0);
                        OctetString ocs = new OctetString("ocs");
                        ocs.decode((byte[])ocsAny.getValue());
                        byte[] imzalananDataninHashi = (byte[])ocs.getValue();
                        vfSonuc = ImzaIslemNesnesi.areByteArraysEqual(imzalananDataninHashi, origDataHash);
                        continue;
                    }
                    if (((String)at.gettype().getValue()).equals("1.2.840.113549.1.9.16.2.12")) {
                        signingCertAttExists = true;
                        vVec = (Vector)at.getvalues().getValue();
                        scertAny = (Any)vVec.get(0);
                        sc = new SigningCertificate("sc");
                        sc.decode((byte[])scertAny.getValue());
                        MessageDigest sha = MessageDigest.getInstance("SHA-1");
                        signerCertHash = sha.digest(signerCert.getEncoded());
                        certhash = ((ESSCertId)((SigningCertificate)sc).getESSCertIds().elementAt(0)).getCertHash();
                        hkSonuc = ImzaIslemNesnesi.areByteArraysEqual(signerCertHash, (byte[])certhash.getValue());
                        if (!hkSonuc) continue;
                        gnames = ((ESSCertId)((SigningCertificate)sc).getESSCertIds().elementAt(0)).getIssuerSerial().getIssuer();
                        if (gnames != null && ((Vector)gnames.getValue()).size() > 0) {
                            gname = (GeneralName)((Vector)gnames.getValue()).elementAt(0);
                            issname = gname.getDirectoryName();
                            issSonuc = issname.isEqualTo(signerCert.gettbsCertificate().getissuer());
                            if (!issSonuc || !(writtenNo = (BigInteger)(csno = ((ESSCertId)((SigningCertificate)sc).getESSCertIds().elementAt(0)).getIssuerSerial().getSerialNumber()).getValue()).equals(certNo = (BigInteger)signerCert.gettbsCertificate().getserialNumber().getValue())) continue;
                            signingCertAttVerif = true;
                            continue;
                        }
                        signingCertAttVerif = true;
                        continue;
                    }
                    if (!((String)at.gettype().getValue()).equals("1.2.840.113549.1.9.16.2.47")) continue;
                    signingCertAttExists = true;
                    vVec = (Vector)at.getvalues().getValue();
                    scertAny = (Any)vVec.get(0);
                    sc = new SigningCertificateV2("sc");
                    sc.decode((byte[])scertAny.getValue());
                    String hasAlgObjIdStr = (String)((ESSCertIdv2)((SigningCertificateV2)sc).getESSCertIds().elementAt(0)).getHashAlgorithm().getalgorithm().getValue();
                    signerCertHash = HashFabrikasi.hashAl(signerCert.getEncoded(), hasAlgObjIdStr);
                    certhash = ((ESSCertIdv2)((SigningCertificateV2)sc).getESSCertIds().elementAt(0)).getCertHash();
                    hkSonuc = ImzaIslemNesnesi.areByteArraysEqual(signerCertHash, (byte[])certhash.getValue());
                    if (!hkSonuc) continue;
                    gnames = ((ESSCertIdv2)((SigningCertificateV2)sc).getESSCertIds().elementAt(0)).getIssuerSerial().getIssuer();
                    if (gnames != null && ((Vector)gnames.getValue()).size() > 0) {
                        gname = (GeneralName)((Vector)gnames.getValue()).elementAt(0);
                        issname = gname.getDirectoryName();
                        issSonuc = issname.isEqualTo(signerCert.gettbsCertificate().getissuer());
                        if (!issSonuc || !(writtenNo = (BigInteger)(csno = ((ESSCertIdv2)((SigningCertificateV2)sc).getESSCertIds().elementAt(0)).getIssuerSerial().getSerialNumber()).getValue()).equals(certNo = (BigInteger)signerCert.gettbsCertificate().getserialNumber().getValue())) continue;
                        signingCertAttVerif = true;
                        continue;
                    }
                    signingCertAttVerif = true;
                }
                if (DogrulamaLog.aktif) {
                    if (!vfSonuc) {
                        DogrulamaLog.logEkle("[X] \u0130mza matematiksel olarak do\u011frulanamad\u0131.");
                    } else {
                        DogrulamaLog.logEkle("\u0130mza matematiksel olarak do\u011fruland\u0131.");
                    }
                    if (!signingCertAttExists) {
                        DogrulamaLog.logEkle("[X] \u0130mzalayan sertifika bilgisi bulunamad\u0131.");
                    }
                    if (!signingCertAttVerif) {
                        DogrulamaLog.logEkle("[X] \u0130mzalayan sertifika bilgisi do\u011frulanamad\u0131.");
                    } else {
                        DogrulamaLog.logEkle("\u0130mzalayan sertifika bilgisi do\u011fruland\u0131.");
                    }
                }
                if (vfSonuc && (signingCertAttExists && signingCertAttVerif || !signingCertAttExists)) {
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("Do\u011frulama Sonucu: \u0130mza ge\u00e7erli.");
                    }
                    resultVec.addElement(new Integer(20));
                    resultVec.addElement(signerCert);
                } else {
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("[X] Do\u011frulama Sonucu: \u0130mza ge\u00e7ersiz.");
                    }
                    resultVec.addElement(new Integer(21));
                    resultVec.addElement(signerCert);
                }
                return resultVec;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[X] \u0130mza matematiksel olarak do\u011frulanamad\u0131.");
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[X] Do\u011frulama s\u0131ras\u0131nda hata olu\u015ftu.");
            }
            resultVec.addElement(new Integer(21));
            resultVec.addElement(signerCert);
            return resultVec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[X] Do\u011frulama s\u0131ras\u0131nda hata olu\u015ftu.");
            }
            Vector<Integer> resultVec = new Vector<Integer>();
            resultVec.addElement(new Integer(25));
            return resultVec;
        }
    }

    private static Certificate extractSignerCertFromCMSSignedData(byte[] ciBytes) {
        try {
            if (ciBytes[0] == 48 && ciBytes[1] == -128) {
                ciBytes = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(ciBytes);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(ciBytes);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector certsvec = (Vector)sd.getCertificates().getValue();
            if (certsvec == null || certsvec.size() == 0) {
                return null;
            }
            SignerInfo sinfo = null;
            int numCounterSignatures = ImzaIslemNesnesi.countCounterSignatures(ciBytes);
            if (numCounterSignatures > 0) {
                Vector lastSigStripped = ImzaIslemNesnesi.removeLastCounterSignature(ciBytes);
                byte[] lastSinfoBytes = (byte[])lastSigStripped.elementAt(1);
                SignerInfo lastSinfo = new SignerInfo("lastSinfo");
                lastSinfo.decode(lastSinfoBytes);
                byte[] parentSinfoBytesForLast = (byte[])lastSigStripped.elementAt(2);
                SignerInfo parentSinfo = new SignerInfo("parentSinfo");
                parentSinfo.decode(parentSinfoBytesForLast);
                sinfo = lastSinfo;
            } else {
                sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            }
            SignerIdentifier signid = sinfo.getSignerIdentifier();
            Certificate signerCert = null;
            IssuerAndSerialNumber iasn = null;
            OctetString keyHash = null;
            try {
                iasn = (IssuerAndSerialNumber)signid.getValue();
            }
            catch (ClassCastException cce) {
                keyHash = (OctetString)signid.getValue();
            }
            if (iasn != null) {
                Name signerCertIssuerName = iasn.getissuer();
                ASN1Integer serialAsnInt = new ASN1Integer("serialAsnInt");
                serialAsnInt.decode((byte[])iasn.getserialNumber().getValue());
                BigInteger signerCertSerialNo = (BigInteger)serialAsnInt.getValue();
                for (Certificate tempCert : certsvec) {
                    BigInteger tempSerialNo;
                    Name tempIssuer = tempCert.gettbsCertificate().getissuer();
                    if (!signerCertIssuerName.isEqualTo(tempIssuer) || !signerCertSerialNo.equals(tempSerialNo = (BigInteger)tempCert.gettbsCertificate().getserialNumber().getValue())) continue;
                    signerCert = tempCert;
                }
            } else if (keyHash != null) {
                byte[] subjectKeyIdBytes = (byte[])keyHash.getValue();
                for (Certificate tempCert : certsvec) {
                    SubjectPublicKeyInfo spki = tempCert.gettbsCertificate().getsubjectPublicKeyInfo();
                    byte[] subjectPubKeyBytes = (byte[])spki.getsubjectPublicKey().getValue();
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    byte[] tempPubKeyHash = sha.digest(subjectPubKeyBytes);
                    if (subjectKeyIdBytes.length != tempPubKeyHash.length) continue;
                    boolean match = true;
                    for (int i = 0; i < subjectKeyIdBytes.length; ++i) {
                        if (subjectKeyIdBytes[i] == tempPubKeyHash[i]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    signerCert = tempCert;
                }
            }
            return signerCert;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static Certificate extractIssuerCertFromCMSSignedData(byte[] ciBytes) {
        try {
            Certificate signerCert;
            if (ciBytes[0] == 48 && ciBytes[1] == -128) {
                ciBytes = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(ciBytes);
            }
            if ((signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(ciBytes)) == null) {
                return null;
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(ciBytes);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector certsvec = (Vector)sd.getCertificates().getValue();
            if (certsvec == null || certsvec.size() == 0) {
                return null;
            }
            for (int i = 0; i < certsvec.size(); ++i) {
                if (!SertifikaFabrikasi.verifyCertificate(signerCert, (Certificate)certsvec.elementAt(i))) continue;
                return (Certificate)certsvec.elementAt(i);
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static String extractSigningTimeFromCMSSignedData(byte[] ciBytes) {
        try {
            if (ciBytes[0] == 48 && ciBytes[1] == -128) {
                ciBytes = ImzaIslemNesnesi.convertFromIndefiniteLengthBERToDER(ciBytes);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(ciBytes);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = null;
            int numCounterSignatures = ImzaIslemNesnesi.countCounterSignatures(ciBytes);
            if (numCounterSignatures > 0) {
                Vector lastSigStripped = ImzaIslemNesnesi.removeLastCounterSignature(ciBytes);
                byte[] lastSinfoBytes = (byte[])lastSigStripped.elementAt(1);
                SignerInfo lastSinfo = new SignerInfo("lastSinfo");
                lastSinfo.decode(lastSinfoBytes);
                byte[] parentSinfoBytesForLast = (byte[])lastSigStripped.elementAt(2);
                SignerInfo parentSinfo = new SignerInfo("parentSinfo");
                parentSinfo.decode(parentSinfoBytesForLast);
                sinfo = lastSinfo;
            } else {
                sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            }
            Vector signedAttsVec = (Vector)sinfo.getSignedAttributes().getValue();
            for (int i = 0; i < signedAttsVec.size(); ++i) {
                Attribute tempAtt = (Attribute)signedAttsVec.elementAt(i);
                AttributeType tempType = tempAtt.gettype();
                if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.5")) continue;
                Any signTimeAttVal = (Any)((Vector)tempAtt.getvalues().getValue()).elementAt(0);
                UTCTime utcSignTime = new UTCTime("utcSignTime");
                utcSignTime.decode((byte[])signTimeAttVal.getValue());
                Date stdate = (Date)utcSignTime.getValue();
                SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                return df.format(stdate);
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static Certificate findIssuerInSet(Certificate leafCert, Vector certSet) {
        if (leafCert == null || certSet == null) {
            return null;
        }
        if (certSet.size() == 0) {
            return null;
        }
        for (int i = 0; i < certSet.size(); ++i) {
            if (!SertifikaFabrikasi.verifyCertificate(leafCert, (Certificate)certSet.elementAt(i))) continue;
            return (Certificate)certSet.elementAt(i);
        }
        return null;
    }

    private static Certificate findRootestIssuerInSet(Certificate leafCert, Vector certSet) {
        if (certSet == null) {
            return null;
        }
        if (certSet.size() == 0) {
            return null;
        }
        boolean leafInSet = false;
        for (int i = 0; i < certSet.size(); ++i) {
            Certificate tempCert = (Certificate)certSet.elementAt(i);
            if (leafCert.gettbsCertificate().getsubject().isEqualTo(tempCert.gettbsCertificate().getsubject())) {
                if (SertifikaFabrikasi.verifyCertificate(leafCert, tempCert)) {
                    if (ImzaIslemNesnesi.areByteArraysEqual(leafCert.getEncoded(), tempCert.getEncoded())) {
                        return leafCert;
                    }
                } else if (ImzaIslemNesnesi.areByteArraysEqual(leafCert.getEncoded(), tempCert.getEncoded())) {
                    leafInSet = true;
                }
            }
            if (!leafCert.gettbsCertificate().getissuer().isEqualTo(tempCert.gettbsCertificate().getsubject()) || !SertifikaFabrikasi.verifyCertificate(leafCert, tempCert)) continue;
            return ImzaIslemNesnesi.findRootestIssuerInSet(tempCert, certSet);
        }
        if (leafInSet) {
            return leafCert;
        }
        return null;
    }

    private static Vector getHierarchyFromSet(Certificate leafCert, Vector certSet) {
        Vector<Certificate> zincir = new Vector<Certificate>();
        if (leafCert == null || certSet == null) {
            return null;
        }
        if (certSet.size() == 0) {
            return zincir;
        }
        Certificate kontrolCert = leafCert;
        int issuerIndex = -1;
        while (true) {
            byte[] issuerBytes;
            boolean verif = false;
            for (int i = 0; i < certSet.size(); ++i) {
                if (!SertifikaFabrikasi.verifyCertificate(kontrolCert, (Certificate)certSet.elementAt(i))) continue;
                zincir.addElement(kontrolCert);
                issuerIndex = i;
                verif = true;
                break;
            }
            if (!verif) break;
            byte[] kontrolCertBytes = kontrolCert.getEncoded();
            if (ImzaIslemNesnesi.areByteArraysEqual(kontrolCertBytes, issuerBytes = ((Certificate)certSet.elementAt(issuerIndex)).getEncoded())) {
                return zincir;
            }
            kontrolCert = (Certificate)certSet.elementAt(issuerIndex);
        }
        zincir.clear();
        return zincir;
    }

    private Vector ocspSorgusuYap(Certificate sorgulanacakSertifika, Certificate kokSertifika, String ocspAdresi, int zamanAsimiSaniye, boolean exceptionKullanimi) throws OCSPException {
        Vector<Serializable> resultVec = new Vector<Serializable>();
        try {
            String adres = null;
            if (ocspAdresi == null) {
                Extensions exts = sorgulanacakSertifika.gettbsCertificate().getextensions();
                Extension authInfoExt = exts.getExtensionByOID("1.3.6.1.5.5.7.1.1");
                if (authInfoExt == null) {
                    if (exceptionKullanimi) {
                        throw new OCSPException(42);
                    }
                    resultVec.addElement(new Integer(42));
                    return resultVec;
                }
                AuthorityInfoAccessSyntax aias = new AuthorityInfoAccessSyntax();
                aias.decodeExtVal((byte[])authInfoExt.getextnValue().getValue());
                Vector vecAccess = aias.getAccessDescriptions();
                for (int i = 0; i < vecAccess.size(); ++i) {
                    AccessDescription acDesc = (AccessDescription)vecAccess.elementAt(i);
                    if (!((String)acDesc.getAccessMethod().getValue()).equals("1.3.6.1.5.5.7.48.1")) continue;
                    adres = acDesc.getAccessLocation().getURI();
                }
                if (adres == null) {
                    if (exceptionKullanimi) {
                        throw new OCSPException(42);
                    }
                    resultVec.addElement(new Integer(42));
                    return resultVec;
                }
            } else {
                adres = ocspAdresi;
            }
            Vector sonucVec = OCSPFabrikasi.queryUsingOCSP(sorgulanacakSertifika, kokSertifika, adres, zamanAsimiSaniye, this.ocspHashAlgoritmasi);
            int sorguSonuc = (Integer)sonucVec.elementAt(0);
            switch (sorguSonuc) {
                case 5: {
                    if (exceptionKullanimi) {
                        throw new OCSPException(43);
                    }
                    resultVec.addElement(new Integer(43));
                    return resultVec;
                }
                case 6: {
                    if (exceptionKullanimi) {
                        throw new OCSPException(44);
                    }
                    resultVec.addElement(new Integer(44));
                    return resultVec;
                }
                case 2: {
                    if (exceptionKullanimi) {
                        throw new OCSPException(45);
                    }
                    resultVec.addElement(new Integer(45));
                    return resultVec;
                }
                case 1: {
                    if (exceptionKullanimi) {
                        throw new OCSPException(46);
                    }
                    resultVec.addElement(new Integer(46));
                    return resultVec;
                }
                case 3: {
                    if (exceptionKullanimi) {
                        throw new OCSPException(47);
                    }
                    resultVec.addElement(new Integer(47));
                    return resultVec;
                }
                case 4: {
                    if (exceptionKullanimi) {
                        throw new OCSPException(48);
                    }
                    resultVec.addElement(new Integer(48));
                    return resultVec;
                }
                case 7: {
                    resultVec.addElement(new Integer(49));
                    resultVec.addElement(OCSPFabrikasi.getBasicResponseFromResponse((byte[])sonucVec.elementAt(1)));
                    return resultVec;
                }
                case 9: {
                    resultVec.addElement(new Integer(51));
                    resultVec.addElement(OCSPFabrikasi.getBasicResponseFromResponse((byte[])sonucVec.elementAt(1)));
                    return resultVec;
                }
                case 8: {
                    resultVec.addElement(new Integer(50));
                    if (sonucVec.size() >= 5) {
                        resultVec.addElement((Integer)sonucVec.elementAt(1));
                        resultVec.addElement((Date)sonucVec.elementAt(2));
                        resultVec.addElement(OCSPFabrikasi.getBasicResponseFromResponse((byte[])sonucVec.elementAt(3)));
                    } else {
                        resultVec.addElement(OCSPFabrikasi.getBasicResponseFromResponse((byte[])sonucVec.elementAt(1)));
                    }
                    return resultVec;
                }
            }
            if (exceptionKullanimi) {
                throw new OCSPException(45);
            }
            resultVec.addElement(new Integer(45));
            return resultVec;
        }
        catch (Exception exc) {
            if (exceptionKullanimi) {
                throw new OCSPException(40);
            }
            resultVec.addElement(new Integer(40));
            return resultVec;
        }
    }

    private int crlKontroluYap(Certificate sorgulanacakSertifika, CertificateList crl) {
        try {
            boolean verif = false;
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                verif = SertifikaFabrikasi.verifyCertificate(sorgulanacakSertifika, (Certificate)this.kokSertifikalar.elementAt(i));
                if (!verif) continue;
                this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
                break;
            }
            if (verif) {
                this.sonDogrulamaZincir = ImzaIslemNesnesi.getHierarchyFromSet(this.shsCert, this.kokSertifikalar);
                if (this.sonDogrulamaZincir.size() == 0) {
                    return 62;
                }
            } else {
                return 62;
            }
            if (!crl.gettbsCertList().getissuer().isEqualTo(this.shsCert.gettbsCertificate().getsubject())) {
                return 63;
            }
            if (!CRLFabrikasi.verifyCRL(crl, this.shsCert)) {
                return 64;
            }
            if (!CRLFabrikasi.isCRLUptoDate(crl)) {
                return 68;
            }
            RevokedCertificate revcert = CRLFabrikasi.isCertificateInCRL(sorgulanacakSertifika, crl);
            if (revcert != null) {
                try {
                    this.crlSonKontroldeIptalTarihi = (Date)((GeneralizedTime)revcert.getRevocationDate().getValue()).getValue();
                }
                catch (ClassCastException ccexc) {
                    this.crlSonKontroldeIptalTarihi = (Date)((UTCTime)revcert.getRevocationDate().getValue()).getValue();
                }
                Extension extReas = revcert.getExtensions().getExtensionByOID("2.5.29.21");
                if (extReas != null) {
                    CRLReason crlReas = new CRLReason();
                    crlReas.decodeExtVal((byte[])extReas.getextnValue().getValue());
                    this.crlSonKontroldeIptalNedeni = crlReas.getReasonCode();
                } else {
                    this.crlSonKontroldeIptalNedeni = 0;
                }
                return 67;
            }
            return 66;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 69;
        }
    }

    private static boolean areByteArraysEqual(byte[] bar1, byte[] bar2) {
        if (bar1.length != bar2.length) {
            return false;
        }
        for (int i = 0; i < bar1.length; ++i) {
            if (bar1[i] == bar2[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] computeHashOfFile(File inputFile) {
        try {
            FileInputStream fis = new FileInputStream(inputFile);
            BufferedInputStream bufis = new BufferedInputStream(fis);
            byte[] bufbytes = new byte[0x100000];
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] result = null;
            boolean finished = false;
            while (bufis.available() > 0) {
                int count = bufis.read(bufbytes);
                if (count < bufbytes.length) {
                    byte[] actualbytes = new byte[count];
                    System.arraycopy(bufbytes, 0, actualbytes, 0, count);
                    result = sha1.digest(actualbytes);
                    finished = true;
                    continue;
                }
                sha1.update(bufbytes);
            }
            if (!finished) {
                result = sha1.digest();
            }
            bufis.close();
            fis.close();
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static byte[] convertFromIndefiniteLengthBERToDER(byte[] input) {
        try {
            byte[] lengthOctets;
            if (input.length < 5) {
                return null;
            }
            int len = input.length - 4;
            if (len < 128) {
                lengthOctets = new byte[]{(byte)len};
            } else {
                byte[] tmp;
                String ls = Integer.toString(len);
                BigInteger bi = new BigInteger(ls);
                lengthOctets = bi.toByteArray();
                if (lengthOctets[0] == 0) {
                    tmp = new byte[lengthOctets.length - 1];
                    System.arraycopy(lengthOctets, 1, tmp, 0, tmp.length);
                    lengthOctets = tmp;
                }
                tmp = new byte[lengthOctets.length + 1];
                tmp[0] = (byte)(0x80 | lengthOctets.length);
                System.arraycopy(lengthOctets, 0, tmp, 1, lengthOctets.length);
                lengthOctets = tmp;
            }
            byte[] result = new byte[1 + lengthOctets.length + len];
            result[0] = 48;
            System.arraycopy(lengthOctets, 0, result, 1, lengthOctets.length);
            System.arraycopy(input, 2, result, 1 + lengthOctets.length, len);
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static ContentInfo formCMSSignedDataFromFileInput(String filename, Certificate cert, byte[] sertifikaId, String hashObjectId, String orijinalVeriMimeType, String imzaProfilOID, String imzaProfilDokUrl, String imzaSahibiUlke, String imzaSahibiSehir, String commitmentTypeOidStr, byte[] contentIdBytes, byte[] contentTSTBytes, Date givenSigningTime) {
        try {
            byte[] buffer;
            int readCount;
            EncapsulatedContentInfo eci = new EncapsulatedContentInfo("eci");
            ObjectID idData = new ObjectID("idData", "1.2.840.113549.1.7.1");
            ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
            boolean dikeyimza = false;
            eci.setEncapsulatedContentType(idData);
            eci.commitElementUpdate();
            SignerInfo sinfo = new SignerInfo("sinfo");
            ASN1Integer cmsVersion = new ASN1Integer("cmsVersion", "1");
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber("iasn");
            iasn.setissuer(cert.gettbsCertificate().getissuer());
            com.turktrust.pkcs7.CertificateSerialNumber signerSerialNo = new com.turktrust.pkcs7.CertificateSerialNumber("signerSerial");
            signerSerialNo.setValue(cert.gettbsCertificate().getserialNumber());
            iasn.setserialNumber(signerSerialNo);
            iasn.commitElementUpdate();
            SignerIdentifier sid = new SignerIdentifier("sid");
            sid.setIssuerAndSerialNumber(iasn);
            ObjectID hashObjId = new ObjectID("Hash");
            hashObjId.setValue(hashObjectId);
            AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
            hashAlgId.setalgorithm(hashObjId);
            hashAlgId.commitElementUpdate();
            MessageDigest mdig = HashFabrikasi.messageDigestNesnesiAl(hashObjectId);
            int blockSize = 102400;
            FileInputStream fis = new FileInputStream(filename);
            while ((readCount = fis.read(buffer = new byte[blockSize])) != -1) {
                byte[] hashInput = null;
                if (readCount < blockSize) {
                    hashInput = new byte[readCount];
                    System.arraycopy(buffer, 0, hashInput, 0, readCount);
                } else {
                    hashInput = buffer;
                }
                mdig.update(hashInput);
            }
            fis.close();
            byte[] tbsDataHash = mdig.digest();
            boolean contentHintsKullan = false;
            if (orijinalVeriMimeType != null) {
                contentHintsKullan = true;
            }
            ContentTimeStamp contentTST = null;
            if (contentTSTBytes != null) {
                contentTST = new ContentTimeStamp();
                contentTST.decode(contentTSTBytes);
            }
            SignedAttributes signedAttrs = CMSFabrikasi.signedAttributesOlustur(false, hashObjectId, tbsDataHash, cert, imzaProfilOID, SHA_256, BTK_PROFIL_PDF_DOKUMAN_OZET, imzaProfilDokUrl, contentHintsKullan, orijinalVeriMimeType, imzaSahibiUlke, imzaSahibiSehir, commitmentTypeOidStr, contentIdBytes, contentTST, givenSigningTime);
            ObjectID rsa_objId = new ObjectID("HashwithRSA");
            rsa_objId.setValue(ImzaFabrikasi.mapHashOIDToSignatureAlgorithmOID(hashObjectId));
            Null parNull2 = new Null("Null_par");
            Any anyNull2 = new Any("Any_null");
            anyNull2.setValue(parNull2);
            AlgorithmIdentifier rsaAlgId = new AlgorithmIdentifier("RSA");
            rsaAlgId.setalgorithm(rsa_objId);
            rsaAlgId.setparameters(anyNull2);
            rsaAlgId.commitElementUpdate();
            byte[] toBeSignedBytes = signedAttrs.getEncoded();
            byte[] hash = HashFabrikasi.hashAl(toBeSignedBytes, hashObjectId);
            OctetString sigOcts = new OctetString("hashOcts", hash);
            DigestInfo dinfo = new DigestInfo();
            dinfo.setDigestAlgorithmIdentifier(hashAlgId);
            dinfo.setDigest(sigOcts);
            dinfo.commitElementUpdate();
            byte[] sigBytes = null;
            sigBytes = sertifikaId == null ? Smartcard.sign(dinfo.getEncoded()) : Smartcard.signWithID(dinfo.getEncoded(), sertifikaId);
            OctetString signatureOcts = new OctetString("signatureOcts", sigBytes);
            sinfo.setCMSVersion(cmsVersion);
            sinfo.setSignerIdentifier(sid);
            sinfo.setDigestAlgorithm(hashAlgId);
            sinfo.setSignedAttributes(signedAttrs);
            sinfo.setSignatureAlgorithm(rsaAlgId);
            sinfo.setSignature(signatureOcts);
            sinfo.commitElementUpdate();
            SignedData sd = new SignedData("sd");
            ASN1Integer sdVersion = new ASN1Integer("sdVersion", "3");
            DigestAlgorithmIdentifiers dais = new DigestAlgorithmIdentifiers("dais");
            dais.addElement(hashAlgId);
            X509CertificateSet certset = new X509CertificateSet("certset");
            certset.addElement(cert);
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(sinfo);
            sd.setCMSVersion(sdVersion);
            sd.setDigestAlgorithms(dais);
            sd.setEncapContentInfo(eci);
            sd.setCertificates(certset);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ci = new ContentInfo("ci");
            ci.setcontentType(idSignedData);
            Any contSignedData = new Any("contSignedData", sd);
            ci.setcontent(contSignedData);
            ci.commitElementUpdate();
            return ci;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected static Vector getCounterSignaturesList(byte[] input) {
        try {
            Vector<byte[]> result = new Vector<byte[]>();
            int count = ImzaIslemNesnesi.countCounterSignatures(input);
            if (count == -1) {
                return null;
            }
            if (count == 0) {
                return result;
            }
            Vector initialStripped = ImzaIslemNesnesi.removeLastCounterSignature(input);
            byte[] allInnerSigs = (byte[])initialStripped.elementAt(0);
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(allInnerSigs);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            byte[] beingProcessedBytes = allInnerSigs;
            for (int remaining = count; remaining > 1; --remaining) {
                Vector stripped = ImzaIslemNesnesi.removeLastCounterSignature(beingProcessedBytes);
                byte[] innerSigs = (byte[])stripped.elementAt(0);
                byte[] outerSinfoBytes = (byte[])stripped.elementAt(1);
                byte[] parentSinfoBytes = (byte[])stripped.elementAt(2);
                SignerInfo outerSinfo = new SignerInfo("outerSinfo");
                outerSinfo.decode(outerSinfoBytes);
                SignerInfo parentSinfo = new SignerInfo("parentSinfo");
                parentSinfo.decode(parentSinfoBytes);
                byte[] outerCinfoBytes = ImzaIslemNesnesi.putCounterSigInSeparateContentInfo(outerSinfo, (byte[])parentSinfo.getSignature().getValue(), sd.getCertificates());
                result.add(outerCinfoBytes);
                beingProcessedBytes = innerSigs;
            }
            result.add(beingProcessedBytes);
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected static int countCounterSignatures(byte[] input) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(input);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            if (sinfo.getUnsignedAttributes() == null) {
                return 0;
            }
            int count = 0;
            Vector unsignedAttsVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            for (int i = 0; i < unsignedAttsVec.size(); ++i) {
                Attribute tempAtt = (Attribute)unsignedAttsVec.elementAt(i);
                AttributeType tempType = tempAtt.gettype();
                if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                Any counterSigAttVal = (Any)((Vector)tempAtt.getvalues().getValue()).elementAt(0);
                SignerInfo counterSignerInfo = new SignerInfo("counterSignerInfo");
                counterSignerInfo.decode((byte[])counterSigAttVal.getValue());
                byte[] sepContentInfo = ImzaIslemNesnesi.putCounterSigInSeparateContentInfo(counterSignerInfo, (byte[])sinfo.getSignature().getValue(), sd.getCertificates());
                count = 1 + ImzaIslemNesnesi.countCounterSignatures(sepContentInfo);
            }
            return count;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    protected static byte[] putCounterSigInSeparateContentInfo(SignerInfo counterSignerInfo, byte[] signatureInputBytes, X509CertificateSet certificateSet) {
        try {
            EncapsulatedContentInfo eci = new EncapsulatedContentInfo("eci");
            ObjectID idData = new ObjectID("idData", "1.2.840.113549.1.7.1");
            eci.setEncapsulatedContentType(idData);
            OctetString tbsOctet = new OctetString("tbsOctet", signatureInputBytes);
            eci.setEncapsulatedContent(tbsOctet);
            eci.commitElementUpdate();
            SignedData sd = new SignedData("sd");
            ASN1Integer sdVersion = new ASN1Integer("sdVersion", "3");
            DigestAlgorithmIdentifiers dais = new DigestAlgorithmIdentifiers("dais");
            dais.addElement(counterSignerInfo.getDigestAlgorithm());
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(counterSignerInfo);
            sd.setCMSVersion(sdVersion);
            sd.setDigestAlgorithms(dais);
            sd.setEncapContentInfo(eci);
            sd.setCertificates(certificateSet);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ci = new ContentInfo("ci");
            ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
            ci.setcontentType(idSignedData);
            Any contSignedData = new Any("contSignedData", sd);
            ci.setcontent(contSignedData);
            ci.commitElementUpdate();
            return ci.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected static Vector removeLastCounterSignature(byte[] input) {
        try {
            Vector<byte[]> result = new Vector<byte[]>();
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(input);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            if (sinfo.getUnsignedAttributes() == null) {
                result.add(input);
                return result;
            }
            boolean foundAtleastOneCounterSignature = false;
            boolean searchComplete = false;
            int count = 0;
            Vector unsignedAttsVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            int attributeIndex = -1;
            BaseASN1Object parentSignerInfo = sinfo;
            BaseASN1Object childSignerInfo = null;
            Vector<BaseASN1Object> sinfoVec = new Vector<BaseASN1Object>();
            Vector<Integer> counterIndexVec = new Vector<Integer>();
            while (!searchComplete) {
                boolean foundCounterSignatureInNode = false;
                for (int i = 0; i < unsignedAttsVec.size(); ++i) {
                    Attribute tempAtt = (Attribute)unsignedAttsVec.elementAt(i);
                    AttributeType tempType = tempAtt.gettype();
                    if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                    ++count;
                    foundAtleastOneCounterSignature = true;
                    foundCounterSignatureInNode = true;
                    attributeIndex = i;
                    Any counterSigAttVal = (Any)((Vector)tempAtt.getvalues().getValue()).elementAt(0);
                    SignerInfo counterSignerInfo = new SignerInfo("counterSignerInfo");
                    counterSignerInfo.decode((byte[])counterSigAttVal.getValue());
                    if (childSignerInfo != null) {
                        parentSignerInfo = childSignerInfo;
                    }
                    childSignerInfo = counterSignerInfo;
                    sinfoVec.add(parentSignerInfo);
                    counterIndexVec.add(new Integer(i));
                    unsignedAttsVec = (Vector)((SignerInfo)childSignerInfo).getUnsignedAttributes().getValue();
                    break;
                }
                if (foundCounterSignatureInNode) continue;
                searchComplete = true;
            }
            if (foundAtleastOneCounterSignature) {
                Vector uavecToUpdate = (Vector)((SignerInfo)parentSignerInfo).getUnsignedAttributes().getValue();
                uavecToUpdate.removeElementAt(attributeIndex);
                ((SignerInfo)parentSignerInfo).getUnsignedAttributes().setValue(uavecToUpdate);
                if (count > 1) {
                    for (int j = sinfoVec.size() - 2; j >= 0; --j) {
                        SignerInfo upperSignerInfo = (SignerInfo)sinfoVec.elementAt(j);
                        SignerInfo lowerSignerInfo = (SignerInfo)sinfoVec.elementAt(j + 1);
                        Any updatedCounterSigAttVal = new Any("updatedCounterSigAttVal", lowerSignerInfo);
                        int upperLevelAttIndex = (Integer)counterIndexVec.elementAt(j);
                        Vector upperAttributes = (Vector)upperSignerInfo.getUnsignedAttributes().getValue();
                        Attribute tbuAtt = (Attribute)upperAttributes.elementAt(upperLevelAttIndex);
                        ((Vector)tbuAtt.getvalues().getValue()).removeElementAt(0);
                        ((Vector)tbuAtt.getvalues().getValue()).add(0, updatedCounterSigAttVal);
                    }
                }
                ContentInfo cinfo = new ContentInfo("cinfo");
                ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
                cinfo.setcontentType(idSignedData);
                Any contSignedData = new Any("contSignedData", sd);
                cinfo.setcontent(contSignedData);
                cinfo.commitElementUpdate();
                result.add(cinfo.getEncoded());
                result.add(childSignerInfo.getEncoded());
                result.add(parentSignerInfo.getEncoded());
                return result;
            }
            result.add(input);
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected Vector extractParallelSignatures(byte[] input) {
        try {
            Vector<byte[]> result = new Vector<byte[]>();
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(input);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            for (int i = 0; i < sinfoVec.size(); ++i) {
                SignedData sdcopy = new SignedData("sdcopy");
                sdcopy.setCMSVersion(sd.getCMSVersion());
                sdcopy.setEncapContentInfo(sd.getEncapContentInfo());
                sdcopy.setDigestAlgorithms(sd.getDigestAlgorithms());
                sdcopy.setCertificates(sd.getCertificates());
                sdcopy.setCRLs(sd.getCRLs());
                SignerInfos sinfoset = new SignerInfos("sinfoset");
                sinfoset.addElement((SignerInfo)sinfoVec.elementAt(i));
                sdcopy.setSignerInfos(sinfoset);
                sdcopy.commitElementUpdate();
                ContentInfo cinfo = new ContentInfo("cinfo");
                cinfo.setcontentType(idSignedData);
                Any contSignedData = new Any("contSignedData", sdcopy);
                cinfo.setcontent(contSignedData);
                cinfo.commitElementUpdate();
                result.add(cinfo.getEncoded());
            }
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected byte[] mergeParallelSignatures(Vector parallelSignatures) {
        try {
            byte[] siradakiOrijinalVeri;
            int i;
            if (parallelSignatures == null || parallelSignatures.size() == 0) {
                return null;
            }
            byte[] ilkImza = (byte[])parallelSignatures.elementAt(0);
            byte[] orijinalVeri = this.temelOrijinalVeriyiAl(ilkImza);
            if (orijinalVeri != null) {
                for (i = 1; i < parallelSignatures.size(); ++i) {
                    siradakiOrijinalVeri = this.temelOrijinalVeriyiAl((byte[])parallelSignatures.elementAt(i));
                    if (ImzaIslemNesnesi.areByteArraysEqual(orijinalVeri, siradakiOrijinalVeri)) continue;
                    return null;
                }
            } else {
                for (i = 1; i < parallelSignatures.size(); ++i) {
                    siradakiOrijinalVeri = this.temelOrijinalVeriyiAl((byte[])parallelSignatures.elementAt(i));
                    if (siradakiOrijinalVeri == null) continue;
                    return null;
                }
            }
            ContentInfo contentInfoIlkImza = new ContentInfo("ci");
            contentInfoIlkImza.decode(ilkImza);
            byte[] sdBytes = (byte[])contentInfoIlkImza.getcontent().getValue();
            SignedData sdIlkImza = new SignedData("sd");
            sdIlkImza.setTaggingMethod(2);
            sdIlkImza.setTagClass((byte)-128);
            sdIlkImza.setTagNumber(0);
            sdIlkImza.decode(sdBytes);
            Vector ilkImzaCertsVec = (Vector)sdIlkImza.getCertificates().getValue();
            Vector<Certificate> cumulativeCertsVec = new Vector<Certificate>();
            cumulativeCertsVec.addAll(ilkImzaCertsVec);
            Vector ilkImzaSinfoVec = (Vector)sdIlkImza.getSignerInfos().getValue();
            for (int i2 = 1; i2 < parallelSignatures.size(); ++i2) {
                ContentInfo contentInfoSiradakiImza = new ContentInfo("ci");
                contentInfoSiradakiImza.decode((byte[])parallelSignatures.elementAt(i2));
                byte[] sdSiradakiBytes = (byte[])contentInfoSiradakiImza.getcontent().getValue();
                SignedData sdSiradakiImza = new SignedData("sd");
                sdSiradakiImza.setTaggingMethod(2);
                sdSiradakiImza.setTagClass((byte)-128);
                sdSiradakiImza.setTagNumber(0);
                sdSiradakiImza.decode(sdSiradakiBytes);
                Vector sinfoVec = (Vector)sdSiradakiImza.getSignerInfos().getValue();
                for (int k = 0; k < sinfoVec.size(); ++k) {
                    ilkImzaSinfoVec.addElement((SignerInfo)sinfoVec.elementAt(k));
                }
                Vector siradakiCerts = (Vector)sdSiradakiImza.getCertificates().getValue();
                for (int c = 0; c < siradakiCerts.size(); ++c) {
                    Certificate scert = (Certificate)siradakiCerts.elementAt(c);
                    byte[] scertBytes = scert.getEncoded();
                    boolean certFound = false;
                    for (int s = 0; s < cumulativeCertsVec.size(); ++s) {
                        Certificate icert = (Certificate)cumulativeCertsVec.elementAt(s);
                        byte[] icertBytes = icert.getEncoded();
                        if (!ImzaIslemNesnesi.areByteArraysEqual(scertBytes, icertBytes)) continue;
                        certFound = true;
                        break;
                    }
                    if (certFound) continue;
                    cumulativeCertsVec.addElement(scert);
                }
            }
            X509CertificateSet cset = new X509CertificateSet("cset");
            cset.setValue(cumulativeCertsVec);
            sdIlkImza.setCertificates(cset);
            sdIlkImza.commitElementUpdate();
            ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
            ContentInfo resultCinfo = new ContentInfo("cinfo");
            resultCinfo.setcontentType(idSignedData);
            Any contSignedData = new Any("contSignedData", sdIlkImza);
            resultCinfo.setcontent(contSignedData);
            resultCinfo.commitElementUpdate();
            return resultCinfo.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public byte[] imzaSahibiSertifikaKokCRLYukle(byte[] imza) {
        try {
            Certificate signerCert = ImzaIslemNesnesi.extractSignerCertFromCMSSignedData(imza);
            if (signerCert == null) {
                return null;
            }
            boolean verif = false;
            for (int i = 0; i < this.kokSertifikalar.size(); ++i) {
                verif = SertifikaFabrikasi.verifyCertificate(signerCert, (Certificate)this.kokSertifikalar.elementAt(i));
                if (!verif) continue;
                this.shsCert = (Certificate)this.kokSertifikalar.elementAt(i);
                break;
            }
            if (!verif) {
                return null;
            }
            String kokCrlAdres = null;
            Extensions exts = this.shsCert.gettbsCertificate().getextensions();
            Extension crldpExt = exts.getExtensionByOID("2.5.29.31");
            if (crldpExt == null) {
                return null;
            }
            SertifikaBilgiNesnesi sbn = new SertifikaBilgiNesnesi();
            sbn.sertifikaYukle(this.shsCert.getEncoded());
            String[] kokCrlAdresleri = sbn.sertifikaCRLDagitimNoktalariListesiAl();
            for (int c = 0; c < kokCrlAdresleri.length; ++c) {
                if (!kokCrlAdresleri[c].startsWith("http")) continue;
                kokCrlAdres = kokCrlAdresleri[c];
                break;
            }
            if (kokCrlAdres == null) {
                return null;
            }
            URL kokCrlURL = new URL(kokCrlAdres);
            HttpURLConnection conn = (HttpURLConnection)kokCrlURL.openConnection();
            conn.connect();
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            byte[] buf = new byte[100];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            int r = bis.read(buf);
            while (r != -1) {
                bos.write(buf, 0, r);
                r = bis.read(buf);
            }
            bis.close();
            bos.flush();
            byte[] crlBytes = baos.toByteArray();
            bos.close();
            this.shsSertifikalariIcinCRLYukle(crlBytes);
            return crlBytes;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public String apiVersiyonNumarasiAl() {
        return "3.1.3";
    }
}

