/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.api;

import com.turktrust.asn1.GeneralizedTime;
import com.turktrust.asn1.UTCTime;
import com.turktrust.pkcs1.RSAPublicKey;
import com.turktrust.x509.Certificate;
import com.turktrust.x509.Extension;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.KeyUsage;
import com.turktrust.x509.QCStatement;
import com.turktrust.x509.QCStatements;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class SertifikaBilgiNesnesi {
    public static final int SERTIFIKA_BASARIYLA_YUKLENDI = 11;
    public static final int SERTIFIKA_YUKLENEMEDI = 12;
    private Certificate cert;

    public int sertifikaYukle(byte[] sertifikaByteDizisi) {
        try {
            this.cert = new Certificate("cert");
            this.cert.decode(sertifikaByteDizisi);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public String sertifikaSahibiIsimAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getsubject().getCN();
    }

    public String sertifikaSahibiUlkeAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getsubject().getC();
    }

    public String sertifikaSahibiBolgeAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getsubject().getS();
    }

    public String sertifikaSahibiSehirAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getsubject().getL();
    }

    public String sertifikaSahibiKurumAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getsubject().getO();
    }

    public String sertifikaSahibiBirimAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getsubject().getOU();
    }

    public String sertifikaSahibiTanimlayiciNoAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getsubject().getSerialNo();
    }

    public String sertifikaSahibiUnvanAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getsubject().getTitle();
    }

    public String sertifikaKokIsimAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getissuer().getCN();
    }

    public String sertifikaKokUlkeAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getissuer().getC();
    }

    public String sertifikaKokBolgeAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getissuer().getS();
    }

    public String sertifikaKokSehirAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getissuer().getL();
    }

    public String sertifikaKokKurumAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getissuer().getO();
    }

    public String sertifikaKokBirimAl() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.gettbsCertificate().getissuer().getOU();
    }

    public Date sertifikaGecerlilikBaslangicAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            UTCTime utc = (UTCTime)this.cert.gettbsCertificate().getvalidity().getnotBefore().getValue();
            return (Date)utc.getValue();
        }
        catch (ClassCastException ccexc) {
            GeneralizedTime gtm = (GeneralizedTime)this.cert.gettbsCertificate().getvalidity().getnotBefore().getValue();
            return (Date)gtm.getValue();
        }
    }

    public Date sertifikaGecerlilikBitisAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            UTCTime utc = (UTCTime)this.cert.gettbsCertificate().getvalidity().getnotAfter().getValue();
            return (Date)utc.getValue();
        }
        catch (ClassCastException ccexc) {
            GeneralizedTime gtm = (GeneralizedTime)this.cert.gettbsCertificate().getvalidity().getnotAfter().getValue();
            return (Date)gtm.getValue();
        }
    }

    public String sertifikaSeriNoAl() {
        if (this.cert == null) {
            return null;
        }
        BigInteger serial = (BigInteger)this.cert.gettbsCertificate().getserialNumber().getValue();
        return serial.toString();
    }

    public String sertifikaImzaAlgoritmasiAl() {
        if (this.cert == null) {
            return null;
        }
        String algOid = (String)this.cert.getsignatureAlgorithm().getalgorithm().getValue();
        if (algOid.equals("1.2.840.113549.1.1.5")) {
            return "SHA-1 with RSA";
        }
        if (algOid.equals("1.2.840.113549.1.1.4")) {
            return "MD5 with RSA";
        }
        return algOid;
    }

    public String sertifikaAcikAnahtarAl() {
        if (this.cert == null) {
            return null;
        }
        byte[] pubKeyBytes = (byte[])this.cert.gettbsCertificate().getsubjectPublicKeyInfo().getsubjectPublicKey().getValue();
        String pubKeyStr = "";
        for (int i = 0; i < pubKeyBytes.length; ++i) {
            int tb = pubKeyBytes[i];
            if (tb < 0) {
                tb += 256;
            }
            if (tb < 10) {
                pubKeyStr = pubKeyStr + "0";
            }
            pubKeyStr = pubKeyStr + Integer.toHexString(tb);
            if (i >= pubKeyBytes.length - 1) continue;
            pubKeyStr = pubKeyStr + " ";
        }
        return pubKeyStr;
    }

    public int sertifikaAnahtarUzunluguAl() {
        if (this.cert == null) {
            return -1;
        }
        byte[] pubKeyBytes = (byte[])this.cert.gettbsCertificate().getsubjectPublicKeyInfo().getsubjectPublicKey().getValue();
        RSAPublicKey rsaPubKey = new RSAPublicKey("rsaPubKey");
        try {
            rsaPubKey.decode(pubKeyBytes);
        }
        catch (Exception exc) {
            return -1;
        }
        return ((BigInteger)rsaPubKey.getmodulus().getValue()).bitLength();
    }

    public String sertifikaESHSAnahtarTanimlayicisiAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension akiExt = exts.getExtensionByOID("2.5.29.35");
            if (akiExt == null) {
                return "";
            }
            return akiExt.getTurkishExplanation();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public String sertifikaSahibiAnahtarTanimlayicisiAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension skiExt = exts.getExtensionByOID("2.5.29.14");
            if (skiExt == null) {
                return "";
            }
            return skiExt.getTurkishExplanation();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public String sertifikaIlkeleriAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension polExt = exts.getExtensionByOID("2.5.29.32");
            if (polExt == null) {
                return "";
            }
            return polExt.getTurkishExplanation();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public String sertifikaTemelKisitlamalarAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension bcExt = exts.getExtensionByOID("2.5.29.19");
            if (bcExt == null) {
                return "";
            }
            return bcExt.getTurkishExplanation();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public String sertifikaCRLDagitimNoktalariAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension crldpExt = exts.getExtensionByOID("2.5.29.31");
            if (crldpExt == null) {
                return "";
            }
            return crldpExt.getTurkishExplanation();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public String[] sertifikaCRLDagitimNoktalariListesiAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension crldpExt = exts.getExtensionByOID("2.5.29.31");
            if (crldpExt == null) {
                return null;
            }
            String allURLs = crldpExt.getTurkishExplanation();
            StringTokenizer stok = new StringTokenizer(allURLs, "\n");
            Vector<String> adresVec = new Vector<String>();
            while (stok.hasMoreTokens()) {
                adresVec.addElement(stok.nextToken());
            }
            String[] res = new String[adresVec.size()];
            for (int i = 0; i < adresVec.size(); ++i) {
                res[i] = (String)adresVec.elementAt(i);
            }
            return res;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String sertifikaESHSBilgiErisimiAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension aiaExt = exts.getExtensionByOID("1.3.6.1.5.5.7.1.1");
            if (aiaExt == null) {
                return "";
            }
            return aiaExt.getTurkishExplanation();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public String sertifikaAnahtarKullanimiBitleriAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension kuExt = exts.getExtensionByOID("2.5.29.15");
            if (kuExt == null) {
                return "";
            }
            return ((KeyUsage)kuExt.getSubInstance()).getKeyUsageBits();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public String sertifikaAnahtarKullanimiAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension kuExt = exts.getExtensionByOID("2.5.29.15");
            if (kuExt == null) {
                return "";
            }
            return kuExt.getTurkishExplanation();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public boolean sertifikaAnahtarKullanimiNESUygunlukKontrolu() {
        if (this.cert == null) {
            return false;
        }
        try {
            Extensions exts = this.cert.gettbsCertificate().getextensions();
            Extension kuExt = exts.getExtensionByOID("2.5.29.15");
            if (kuExt == null) {
                return false;
            }
            String str = kuExt.getTurkishExplanation();
            return str.contains("Elektronik \u0130mza") && str.contains("\u0130nkar Edilemezlik");
        }
        catch (Exception exc) {
            return false;
        }
    }

    public String sertifikaSHA1ParmakIziAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            MessageDigest mdig = MessageDigest.getInstance("SHA-1");
            byte[] resultBytes = mdig.digest(this.cert.getEncoded());
            String resultStr = "";
            for (int i = 0; i < resultBytes.length; ++i) {
                int tb = resultBytes[i];
                if (tb < 0) {
                    tb += 256;
                }
                resultStr = resultStr + Integer.toHexString(tb);
                if (i >= resultBytes.length - 1) continue;
                resultStr = resultStr + " ";
            }
            return resultStr;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String[] sertifikaNitelikliBelirtimleriniAl() {
        if (this.cert == null) {
            return null;
        }
        try {
            Vector<String> statIdVec = new Vector<String>();
            Extension qcExt = this.cert.gettbsCertificate().getextensions().getExtensionByOID("1.3.6.1.5.5.7.1.3");
            if (qcExt == null) {
                return new String[0];
            }
            QCStatements qcs = new QCStatements();
            qcs.decodeExtVal((byte[])qcExt.getextnValue().getValue());
            Vector statsVec = qcs.getStatements();
            boolean etsiIDExists = false;
            boolean tkIDExists = false;
            for (int i = 0; i < statsVec.size(); ++i) {
                QCStatement qctemp = (QCStatement)statsVec.elementAt(i);
                statIdVec.addElement((String)qctemp.getStatementId().getValue());
            }
            String[] res = new String[statIdVec.size()];
            res = statIdVec.toArray(res);
            return res;
        }
        catch (Exception exc) {
            return null;
        }
    }
}

