/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.io.Serializable;
import java.math.BigInteger;

public abstract class BaseASN1Object
implements ASN1Object,
Serializable {
    protected byte tagClass = 0;
    protected int tagMethod = 0;
    protected int tagNumber = -1;
    protected int type = -1;
    protected boolean constructed = false;
    protected boolean optional = false;
    private String name;
    private static boolean TRACE = false;
    protected int forcedTagMethod = 0;
    protected int internalTagMethod = 0;
    protected boolean choice = false;
    protected int externalTagNumber = -1;
    protected boolean objectHasDefaultValue = false;

    public BaseASN1Object() {
    }

    public BaseASN1Object(String name) {
        this.name = name;
    }

    public BaseASN1Object(String name, Object value) {
        this.name = name;
        this.setValue(value);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTagClass(byte tagClass) {
        this.tagClass = tagClass;
    }

    public byte getTagClass() {
        return this.tagClass;
    }

    public void setTaggingMethod(int method) {
        this.tagMethod = method;
    }

    public int getTaggingMethod() {
        return this.tagMethod;
    }

    public boolean isImplicitlyTagged() {
        return this.tagMethod == 1;
    }

    public boolean isExplicityTagged() {
        return this.tagMethod == 2;
    }

    public void setTagNumber(int tagNumber) {
        this.tagNumber = tagNumber;
    }

    public int getTagNumber() {
        if (this.externalTagNumber == -1) {
            return this.tagNumber;
        }
        return this.externalTagNumber;
    }

    public void setType(int objectType) {
        this.type = objectType;
    }

    public int getType() {
        return this.type;
    }

    public void setConstructed(boolean flag) {
        this.constructed = flag;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public void setOptional(boolean flag) {
        this.optional = flag;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setDefaultValue(Object value) {
    }

    public Object getDefaultValue() {
        return this.getValue();
    }

    public boolean isDefaultValue() {
        return this.objectHasDefaultValue;
    }

    public void setDefaulting(boolean val) {
        this.objectHasDefaultValue = val;
    }

    public void decode(byte[] data) throws DecodeException {
    }

    public byte[] getEncoded() {
        byte[] contents = this.getContentEncoding();
        if (contents == null && this.isOptional()) {
            BaseASN1Object.trace("BaseASN1Object." + this.getName() + ".getEncoded: no contents for optional field, returning null");
            return null;
        }
        byte[] length = this.getLengthEncoding(contents);
        int cl = contents.length;
        int ll = length.length;
        int bl = 1 + ll + cl;
        byte[] buffer = new byte[bl];
        if (this.tagMethod == 0) {
            this.tagNumber = this.type;
        }
        buffer[0] = this.internalTagMethod == 0 ? (this.tagMethod == 2 ? (byte)this.type : (byte)(this.tagClass | this.tagNumber)) : (this.internalTagMethod == 1 ? (byte)(this.tagClass | this.tagNumber) : (byte)this.type);
        if (this.constructed) {
            buffer[0] = (byte)(buffer[0] | 0x20);
        }
        int idx = 1;
        System.arraycopy(length, 0, buffer, idx, ll);
        System.arraycopy(contents, 0, buffer, idx += ll, cl);
        if (this.tagMethod == 2) {
            length = this.getLengthEncoding(buffer);
            ll = 1 + length.length + buffer.length;
            byte[] tmp = new byte[ll];
            tmp[0] = this.externalTagNumber == -1 ? (byte)(this.tagClass | 0x20 | this.tagNumber) : (byte)(this.tagClass | 0x20 | this.externalTagNumber);
            System.arraycopy(length, 0, tmp, 1, length.length);
            System.arraycopy(buffer, 0, tmp, 1 + length.length, buffer.length);
            buffer = tmp;
        }
        return buffer;
    }

    public TagInfo getTagInfo(byte[] data, int index) {
        int octetVal;
        int i;
        int kodlananUzunluk;
        int numLengthOctets;
        TagInfo tagInfo = new TagInfo();
        tagInfo.tagIndex = index;
        tagInfo.tagMethod = 0;
        tagInfo.tagClass = (byte)(data[index] & 0xFFFFFFC0);
        tagInfo.tagNumber = data[index] & 0x1F;
        switch (tagInfo.tagClass) {
            case 64: {
                BaseASN1Object.trace("Application class");
                break;
            }
            case -128: {
                BaseASN1Object.trace("Context class");
                break;
            }
            case -64: {
                BaseASN1Object.trace("Private class");
            }
        }
        if ((data[index] & 0x20) != 0) {
            if (tagInfo.tagClass != 0) {
                if (this.forcedTagMethod != 1) {
                    tagInfo.tagMethod = 2;
                    if ((data[++index] & 0x80) == 0) {
                        if (++index + data[index - 1] > data.length) {
                            return null;
                        }
                    } else {
                        numLengthOctets = data[index] & 0x7F;
                        if (index + numLengthOctets > data.length) {
                            return null;
                        }
                        kodlananUzunluk = 0;
                        for (i = 0; i < numLengthOctets; ++i) {
                            octetVal = data[index + numLengthOctets - i];
                            if (octetVal < 0) {
                                octetVal += 256;
                            }
                            kodlananUzunluk = (int)((double)kodlananUzunluk + (double)octetVal * Math.pow(256.0, i));
                        }
                        if (index + numLengthOctets + 1 + kodlananUzunluk > data.length) {
                            return null;
                        }
                        index = index + (data[index] & 0x7F) + 1;
                    }
                    tagInfo.internalTagIndex = index;
                } else {
                    tagInfo.tagMethod = 1;
                }
            }
        } else if (tagInfo.tagClass != 0) {
            tagInfo.tagMethod = 1;
        }
        if (tagInfo.tagMethod != 1) {
            tagInfo.type = data[index] & 0x1F;
        }
        switch (tagInfo.tagMethod) {
            case 1: {
                BaseASN1Object.trace("Implicit tag " + tagInfo.tagNumber);
                break;
            }
            case 2: {
                BaseASN1Object.trace("Explicit tag " + tagInfo.tagNumber);
            }
        }
        if ((data[++index] & 0x80) == 0) {
            tagInfo.contentLength = data[index++] & 0x7F;
            if (index + data[index - 1] > data.length) {
                return null;
            }
        } else {
            int ll;
            numLengthOctets = data[index] & 0x7F;
            if (index + numLengthOctets > data.length) {
                return null;
            }
            kodlananUzunluk = 0;
            for (i = 0; i < numLengthOctets; ++i) {
                octetVal = data[index + numLengthOctets - i];
                if (octetVal < 0) {
                    octetVal += 256;
                }
                kodlananUzunluk = (int)((double)kodlananUzunluk + (double)octetVal * Math.pow(256.0, i));
            }
            if (index + numLengthOctets + 1 + kodlananUzunluk > data.length) {
                return null;
            }
            tagInfo.contentLength = 0;
            if (index - 1 + (ll = data[index++] & 0x7F) > data.length) {
                return null;
            }
            for (int i2 = 0; i2 < ll; ++i2) {
                tagInfo.contentLength = tagInfo.contentLength << 8 | data[index++] & 0xFF;
            }
            if (index + tagInfo.contentLength > data.length) {
                return null;
            }
        }
        tagInfo.contentIndex = index;
        return tagInfo;
    }

    protected byte[] getLengthEncoding(byte[] contents) {
        byte[] llb;
        if (contents == null) {
            byte[] llb2 = new byte[]{0};
            return llb2;
        }
        int cl = contents.length;
        if (cl < 128) {
            llb = new byte[]{(byte)cl};
        } else {
            byte[] tmp;
            String ls = Integer.toString(cl);
            BigInteger bi = new BigInteger(ls);
            llb = bi.toByteArray();
            if (llb[0] == 0) {
                tmp = new byte[llb.length - 1];
                System.arraycopy(llb, 1, tmp, 0, tmp.length);
                llb = tmp;
            }
            tmp = new byte[llb.length + 1];
            tmp[0] = (byte)(0x80 | llb.length);
            System.arraycopy(llb, 0, tmp, 1, llb.length);
            llb = tmp;
        }
        return llb;
    }

    protected byte[] getContentEncoding() {
        return null;
    }

    public String toString() {
        String x = new String("[");
        switch (this.tagClass) {
            case 64: {
                x = x.concat("Application ");
                break;
            }
            case -128: {
                x = x.concat("Context ");
                break;
            }
            case -64: {
                x = x.concat("Private ");
                break;
            }
            default: {
                x = x.concat("Universal ");
            }
        }
        switch (this.tagMethod) {
            case 1: {
                x = x.concat("Implicit ");
                break;
            }
            case 2: {
                x = x.concat("Explicit ");
            }
        }
        if (this.tagClass == 0) {
            switch (this.tagNumber) {
                case 2: {
                    x = x.concat("Integer");
                    break;
                }
                case 3: {
                    x = x.concat("Bit string");
                    break;
                }
                case 4: {
                    x = x.concat("Octet string");
                    break;
                }
                case 5: {
                    x = x.concat("NULL");
                    break;
                }
                case 6: {
                    x = x.concat("OID");
                    break;
                }
                case 16: {
                    x = x.concat("Sequence");
                    break;
                }
                case 17: {
                    x = x.concat("Set");
                    break;
                }
                case 19: {
                    x = x.concat("Printable\tstring");
                    break;
                }
                case 20: {
                    x = x.concat("T61 string");
                    break;
                }
                case 22: {
                    x = x.concat("IA5 string");
                    break;
                }
                case 23: {
                    x = x.concat("UTC Time");
                }
            }
        } else {
            x = x.concat(Integer.toString(this.tagNumber));
        }
        x = x.concat(" " + this.getName() + "]");
        return x;
    }

    protected void hexDump(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            int j = data[i] & 0xFF;
            if (j < 16) {
                System.out.print("0" + Integer.toString(j, 16) + " ");
            } else {
                System.out.print(Integer.toString(j, 16) + " ");
            }
            if ((i + 1) % 8 == 0) {
                System.out.print(" ");
            }
            if ((i + 1) % 16 != 0) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    public void setForcedTagMethod(int ftm) {
        this.forcedTagMethod = ftm;
    }

    public int getForcedTagMethod() {
        return this.forcedTagMethod;
    }

    public void setInternalTagMethod(int itm) {
        this.internalTagMethod = itm;
    }

    public int getInternalTagMethod() {
        return this.internalTagMethod;
    }

    public void setChoice(boolean isAChoiceObject) {
        this.choice = isAChoiceObject;
    }

    public boolean isChoice() {
        return this.choice;
    }

    public void setExternalTagNumber(int etn) {
        this.externalTagNumber = etn;
    }

    public int getExternalTagNumber() {
        return this.externalTagNumber;
    }

    protected static void trace(String message) {
        if (TRACE) {
            System.out.println(message);
        }
    }
}

