/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;

public class BitString
extends BaseASN1Object {
    private byte[] value;
    private int numUnusedBits;

    public BitString() {
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(3);
        this.setTagNumber(3);
        this.numUnusedBits = 0;
    }

    public BitString(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(3);
        this.setTagNumber(3);
        this.numUnusedBits = 0;
    }

    public BitString(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(3);
        this.setTagNumber(3);
        this.numUnusedBits = 0;
        if (value instanceof byte[]) {
            this.setValue(value);
        }
    }

    public void setValue(Object value) {
        this.value = (byte[])value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setNumberOfUnusedBits(int nub) {
        this.numUnusedBits = nub;
    }

    public int getNumberOfUnusedBits() {
        return this.numUnusedBits;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        this.numUnusedBits = data[tagInfo.contentIndex];
        if (this.numUnusedBits < 0 || this.numUnusedBits > 7) {
            throw new DecodeException();
        }
        if (tagInfo.contentLength > 1) {
            this.value = new byte[tagInfo.contentLength - 1];
            System.arraycopy(data, tagInfo.contentIndex + 1, this.value, 0, tagInfo.contentLength - 1);
        } else if (tagInfo.contentLength == 0 && this.numUnusedBits == 0) {
            this.value = new byte[1];
            this.value[0] = 0;
        } else {
            throw new DecodeException();
        }
    }

    protected byte[] getContentEncoding() {
        if (this.value == null) {
            BitString.trace("BitString." + this.getName() + ".getContentEncoding: value not set, returning null");
            return null;
        }
        byte[] x = new byte[this.value.length + 1];
        x[0] = (byte)this.numUnusedBits;
        System.arraycopy(this.value, 0, x, 1, this.value.length);
        BitString.trace("BitString." + this.getName() + ".getContentEncoding: returning a " + x.length + " length byte array");
        return x;
    }

    public String toString() {
        if (this.value != null) {
            return new String(super.toString() + " length =\t" + this.value.length);
        }
        return new String(super.toString());
    }

    public static void main(String[] args) throws DecodeException {
        byte[] a = new byte[]{3, 6, 0, 97, 116, 105, 100, 0};
        BitString i = new BitString("TestBitString");
        i.decode(a);
        System.out.println(i.toString());
        a = i.getEncoded();
        for (int z = 0; z < a.length; ++z) {
            System.out.println(Integer.toString(a[z] & 0xFF, 16));
        }
    }
}

