/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.util.StringTokenizer;
import java.util.Vector;

public class ObjectID
extends BaseASN1Object {
    private String value;
    private static int exp2 = (int)Math.pow(128.0, 2.0);
    private static int exp3 = (int)Math.pow(128.0, 3.0);
    private static int[] mults = new int[]{1, 128, exp2, exp3};

    public ObjectID() {
        super("");
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(6);
        this.setTagNumber(6);
    }

    public ObjectID(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(6);
        this.setTagNumber(6);
    }

    public ObjectID(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(6);
        this.setTagNumber(6);
        if (value instanceof String) {
            this.value = (String)value;
        }
    }

    public boolean equals(Object object) {
        if (this.value == null) {
            return false;
        }
        if (object instanceof ObjectID) {
            object = (String)((ObjectID)object).getValue();
        }
        if (object instanceof String) {
            return this.value.equals((String)object);
        }
        return false;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.value = (String)value;
        }
        if (value instanceof ObjectID) {
            this.value = (String)((ObjectID)value).getValue();
        }
        ObjectID.trace("ObjectID." + this.getName() + ".setValue: new value is " + value);
    }

    public Object getValue() {
        return this.value;
    }

    public void decode(byte[] data) throws DecodeException {
        int i;
        int numBytes;
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        byte[] oidBytes = new byte[tagInfo.contentLength];
        System.arraycopy(data, tagInfo.contentIndex, oidBytes, 0, tagInfo.contentLength);
        int valueX = 0;
        Vector<Integer> values = new Vector<Integer>();
        valueX = oidBytes[0] / 40;
        values.addElement(new Integer(valueX));
        valueX = oidBytes[0] % 40;
        values.addElement(new Integer(valueX));
        for (i = 1; i < tagInfo.contentLength; i += numBytes) {
            valueX = 0;
            numBytes = 1;
            if ((oidBytes[i] & 0x80) != 0) {
                while ((oidBytes[i + numBytes] & 0x80) != 0) {
                    ++numBytes;
                }
                ++numBytes;
            }
            for (int j = 0; j < numBytes; ++j) {
                int exponent = numBytes - j - 1;
                int multiplier = mults[exponent];
                int k = oidBytes[i + j] & 0x7F;
                valueX += multiplier * k;
            }
            values.addElement(new Integer(valueX));
        }
        this.value = new String(values.elementAt(0).toString());
        for (i = 1; i < values.size(); ++i) {
            this.value = this.value.concat(".");
            this.value = this.value.concat(values.elementAt(i).toString());
        }
        ObjectID.trace("ObjectID." + this.getName() + ".decode: value set to " + this.value);
    }

    protected byte[] getContentEncoding() {
        Vector<Object> numbers = new Vector<Object>();
        Vector<byte[]> bytes = new Vector<byte[]>();
        if (this.value == null) {
            ObjectID.trace("ObjectID." + this.getName() + ".getContentEncoding: null value!");
            return null;
        }
        StringTokenizer st = new StringTokenizer(this.value, ".", false);
        while (st.hasMoreElements()) {
            numbers.addElement(st.nextElement());
        }
        byte[] ba = new byte[]{(byte)(Integer.parseInt((String)numbers.elementAt(0)) * 40 + Integer.parseInt((String)numbers.elementAt(1)))};
        bytes.add(ba);
        int cl = 1;
        for (int i = 2; i < numbers.size(); ++i) {
            int num = Integer.parseInt((String)numbers.elementAt(i));
            int l = 1;
            if (num / mults[3] > 0) {
                l = 4;
            } else if (num / mults[2] > 0) {
                l = 3;
            } else if (num / mults[1] > 0) {
                l = 2;
            }
            ba = new byte[l];
            for (int j = 0; j < l; ++j) {
                int k = l - j - 1;
                ba[j] = (byte)(num / mults[k]);
                num -= ba[j] * mults[k];
                if (j >= l - 1) continue;
                ba[j] = (byte)(ba[j] | 0xFFFFFF80);
            }
            bytes.add(ba);
            cl += l;
        }
        byte[] contents = new byte[cl];
        int j = 0;
        for (int i = 0; i < bytes.size(); ++i) {
            ba = (byte[])bytes.elementAt(i);
            System.arraycopy(ba, 0, contents, j, ba.length);
            j += ba.length;
        }
        return contents;
    }

    public String toString() {
        if (this.value != null) {
            return new String(super.toString() + " value = " + this.value.toString());
        }
        return new String(super.toString());
    }

    public static void main(String[] args) throws DecodeException {
        byte[] x = new byte[]{6, 6, 42, -122, 72, -122, -9, 13};
        ObjectID y = new ObjectID("RSADSI");
        y.decode(x);
        System.out.println(y.toString());
        x = y.getEncoded();
        for (int z = 0; z < x.length; ++z) {
            System.out.println(Integer.toString(x[z] & 0xFF, 16));
        }
        byte[] a = new byte[]{6, 7, 42, -122, 72, -50, 56, 4, 1};
        y = new ObjectID("DSA");
        y.decode(a);
        System.out.println(y.toString());
        x = y.getEncoded();
        for (int z = 0; z < x.length; ++z) {
            System.out.println(Integer.toString(x[z] & 0xFF, 16));
        }
    }
}

