/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.cms;

import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.Sequence;
import com.turktrust.cms.CMSVersion;
import com.turktrust.cms.OriginatorInfo;
import com.turktrust.cms.RecipientInfos;
import com.turktrust.cms.UnprotectedAttributes;
import com.turktrust.pkcs7.EncryptedContentInfo;

public class EnvelopedData
extends Sequence {
    private CMSVersion version = new CMSVersion("version");
    private OriginatorInfo originatorInfo = new OriginatorInfo("originatorInfo");
    private RecipientInfos recipientInfos = new RecipientInfos("recipientInfos");
    private EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo("encryptedContentInfo");
    private UnprotectedAttributes unprotectedAttrs = new UnprotectedAttributes("unprotectedAttrs");

    public EnvelopedData(String name) {
        super(name);
        this.setUpElements();
    }

    public EnvelopedData() {
        super("default_EnvelopedData");
        this.setUpElements();
    }

    protected void setUpElements() {
        this.originatorInfo.setOptional(true);
        this.originatorInfo.setTaggingMethod(1);
        this.originatorInfo.setTagClass((byte)-128);
        this.originatorInfo.setTagNumber(0);
        this.unprotectedAttrs.setOptional(true);
        this.unprotectedAttrs.setTaggingMethod(1);
        this.unprotectedAttrs.setTagClass((byte)-128);
        this.unprotectedAttrs.setTagNumber(1);
        super.addElement(this.version);
        super.addElement(this.originatorInfo);
        super.addElement(this.recipientInfos);
        super.addElement((ASN1Object)this.encryptedContentInfo);
        super.addElement(this.unprotectedAttrs);
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public void setEncryptedContentInfo(EncryptedContentInfo encryptedContentInfo) {
        this.encryptedContentInfo = encryptedContentInfo;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
    }

    public RecipientInfos getRecipientInfos() {
        return this.recipientInfos;
    }

    public void setRecipientInfos(RecipientInfos recipientInfos) {
        this.recipientInfos = recipientInfos;
    }

    public UnprotectedAttributes getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    public void setUnprotectedAttrs(UnprotectedAttributes unprotectedAttrs) {
        this.unprotectedAttrs = unprotectedAttrs;
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public void setVersion(CMSVersion version) {
        this.version = version;
    }
}

