/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.cms;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Sequence;
import com.turktrust.cms.CertificateRevocationLists;
import com.turktrust.cms.DigestAlgorithmIdentifiers;
import com.turktrust.cms.EncapsulatedContentInfo;
import com.turktrust.cms.SignerInfos;
import com.turktrust.cms.X509CertificateSet;

public class SignedData
extends Sequence {
    private ASN1Integer cmsVersion = new ASN1Integer("cmsVersion");
    private DigestAlgorithmIdentifiers digestAlgorithms = new DigestAlgorithmIdentifiers("digestAlgorithms");
    private EncapsulatedContentInfo encapContentInfo = new EncapsulatedContentInfo("encapContentInfo");
    private X509CertificateSet certificates = new X509CertificateSet("certificates");
    private CertificateRevocationLists crls = new CertificateRevocationLists("crls");
    private SignerInfos signerInfos = new SignerInfos("signerInfos");

    public SignedData() {
        super("default_signedData");
        this.setUpElements();
    }

    public SignedData(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.cmsVersion);
        super.addElement(this.digestAlgorithms);
        super.addElement(this.encapContentInfo);
        super.addElement(this.certificates);
        this.certificates.setOptional(true);
        this.certificates.setTaggingMethod(1);
        this.certificates.setForcedTagMethod(1);
        this.certificates.setTagClass((byte)-128);
        this.certificates.setTagNumber(0);
        super.addElement(this.crls);
        this.crls.setOptional(true);
        this.crls.setTaggingMethod(1);
        this.crls.setForcedTagMethod(1);
        this.crls.setTagClass((byte)-128);
        this.crls.setTagNumber(1);
        super.addElement(this.signerInfos);
    }

    public void setCMSVersion(ASN1Integer value) {
        this.cmsVersion = value;
    }

    public ASN1Integer getCMSVersion() {
        return this.cmsVersion;
    }

    public void setDigestAlgorithms(DigestAlgorithmIdentifiers value) {
        this.digestAlgorithms = value;
    }

    public DigestAlgorithmIdentifiers getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public void setEncapContentInfo(EncapsulatedContentInfo value) {
        this.encapContentInfo = value;
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    public void setCertificates(X509CertificateSet value) {
        this.certificates = value;
    }

    public X509CertificateSet getCertificates() {
        return this.certificates;
    }

    public void setCRLs(CertificateRevocationLists value) {
        this.crls = value;
    }

    public CertificateRevocationLists getCRLs() {
        return this.crls;
    }

    public void setSignerInfos(SignerInfos value) {
        this.signerInfos = value;
    }

    public SignerInfos getSignerInfos() {
        return this.signerInfos;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

