/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ltes;

import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.ltes.OtherRevVals;
import com.turktrust.ocsp.BasicOCSPResponse;
import com.turktrust.x509.CertificateList;
import java.util.Vector;

public class RevocationValues
extends Sequence {
    private SequenceOf crlVals = new SequenceOf("crlVals", new CertificateList("crl"));
    private SequenceOf ocspVals = new SequenceOf("ocspVals", new BasicOCSPResponse());
    private OtherRevVals otherRevVals = new OtherRevVals();

    public RevocationValues() {
        super("default_RevocationValues");
        this.setUpElements();
    }

    public RevocationValues(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.crlVals);
        this.crlVals.setTaggingMethod(2);
        this.crlVals.setTagClass((byte)-128);
        this.crlVals.setTagNumber(0);
        this.crlVals.setOptional(true);
        super.addElement(this.ocspVals);
        this.ocspVals.setTaggingMethod(2);
        this.ocspVals.setTagClass((byte)-128);
        this.ocspVals.setTagNumber(1);
        this.ocspVals.setOptional(true);
        super.addElement(this.otherRevVals);
        this.otherRevVals.setTaggingMethod(2);
        this.otherRevVals.setTagClass((byte)-128);
        this.otherRevVals.setTagNumber(2);
        this.otherRevVals.setOptional(true);
    }

    public void addCRLVal(CertificateList crl) {
        this.crlVals.addElement(crl);
    }

    public Vector getCRLVals() {
        return (Vector)this.crlVals.getValue();
    }

    public void addOCSPVal(BasicOCSPResponse resp) {
        this.ocspVals.addElement(resp);
    }

    public Vector getOCSPVals() {
        return (Vector)this.ocspVals.getValue();
    }

    public void setOtherRevVals(OtherRevVals value) {
        this.otherRevVals = value;
    }

    public OtherRevVals getOtherRevVals() {
        return this.otherRevVals;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

