/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.Choice;
import com.turktrust.asn1.Null;
import com.turktrust.ocsp.RevokedInfo;

public class CertStatus
extends Choice {
    public static final int GOOD = 0;
    public static final int REVOKED = 1;
    public static final int UNKNOWN = 2;
    private Null good = new Null("default_good");
    private RevokedInfo revoked = new RevokedInfo("default_revokedInfo");
    private Null unknown = new Null("default_unknown");

    public CertStatus() {
        super("default_certStatus");
        super.setForcedTagMethod(1);
        this.setUpElements();
    }

    public CertStatus(String name) {
        super(name);
        super.setForcedTagMethod(1);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.good);
        this.good.setTaggingMethod(1);
        this.good.setTagClass((byte)-128);
        this.good.setTagNumber(0);
        super.addElement(this.revoked);
        this.revoked.setTaggingMethod(1);
        this.revoked.setTagClass((byte)-128);
        this.revoked.setTagNumber(1);
        this.revoked.setForcedTagMethod(1);
        super.addElement(this.unknown);
        this.unknown.setTaggingMethod(1);
        this.unknown.setTagClass((byte)-128);
        this.unknown.setTagNumber(2);
    }

    public void setGood() {
        super.setValue(this.good);
    }

    public void setRevokedInfo(RevokedInfo value) {
        this.revoked = value;
        this.revoked.setTaggingMethod(1);
        this.revoked.setTagClass((byte)-128);
        this.revoked.setTagNumber(1);
        this.revoked.setForcedTagMethod(1);
        super.setValue(this.revoked);
    }

    public void setUnkown() {
        super.setValue(this.unknown);
    }

    public int getStatus() {
        if (super.getValue() instanceof RevokedInfo) {
            return 1;
        }
        return super.getTagNumber();
    }

    public RevokedInfo getRevokedInfo() {
        return (RevokedInfo)super.getValue();
    }
}

