/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.x509.Extension;

public class Nonce
extends Extension {
    public static final String EXT_OBJ_ID = "1.3.6.1.5.5.7.48.1.2";
    private byte[] nonceValue;

    public Nonce(String name, boolean critical, byte[] nonceBytes) {
        super(name);
        this.nonceValue = nonceBytes;
        ObjectID nonceObjId = new ObjectID("nonceObjId");
        nonceObjId.setValue(EXT_OBJ_ID);
        this.setextnID(nonceObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        OctetString nonceValOcts = new OctetString("nonceOctets", nonceBytes);
        byte[] nonceValBytes = nonceValOcts.getEncoded();
        OctetString extOcts = new OctetString("nonceExtOcts", nonceValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public Nonce() {
        super("default_nonce");
        ObjectID nonceObjId = new ObjectID("nonceObjId");
        nonceObjId.setValue(EXT_OBJ_ID);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        this.nonceValue = extValBytes;
    }
}

