/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.Sequence;
import com.turktrust.ocsp.OCSPResponseStatus;
import com.turktrust.ocsp.ResponseBytes;

public class OCSPResponse
extends Sequence {
    private OCSPResponseStatus responseStatus = new OCSPResponseStatus("default_responseStatus");
    private ResponseBytes responseBytes = new ResponseBytes("default_responseBytes");

    public OCSPResponse() {
        super("default_ocspResponse");
        this.setUpElements();
    }

    public OCSPResponse(String name) {
        super(name);
        this.setUpElements();
    }

    private void setUpElements() {
        super.addElement(this.responseStatus);
        super.addElement(this.responseBytes);
        this.responseBytes.setOptional(true);
        this.responseBytes.setTaggingMethod(2);
        this.responseBytes.setTagClass((byte)-128);
        this.responseBytes.setTagNumber(0);
    }

    public void setResponseStatus(OCSPResponseStatus value) {
        this.responseStatus = value;
    }

    public OCSPResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseBytes(ResponseBytes value) {
        this.responseBytes = value;
    }

    public ResponseBytes getResponseBytes() {
        return this.responseBytes;
    }

    public void commitElementUpdate() {
        super.clearElements();
        if (this.responseBytes == null) {
            super.addElement(this.responseStatus);
        } else {
            this.setUpElements();
        }
    }
}

