/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.pkcs10;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SetOf;
import com.turktrust.x509.Attribute;
import com.turktrust.x509.Name;
import com.turktrust.x509.SubjectPublicKeyInfo;

public class CertificationRequestInfo
extends Sequence {
    private ASN1Integer version = new ASN1Integer("version");
    private Name subject = new Name("subject");
    private SubjectPublicKeyInfo subjectPKInfo = new SubjectPublicKeyInfo("subjectPKInfo");
    private SetOf attributes = new SetOf("attributes", new Attribute("default_attr"));

    public CertificationRequestInfo(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.version);
        super.addElement(this.subject);
        super.addElement(this.subjectPKInfo);
        super.addElement(this.attributes);
        this.attributes.setTaggingMethod(1);
        this.attributes.setForcedTagMethod(1);
        this.attributes.setTagClass((byte)-128);
        this.attributes.setTagNumber(0);
    }

    public ASN1Integer getversion() {
        return this.version;
    }

    public void setversion(ASN1Integer value) {
        this.version = value;
    }

    public Name getsubject() {
        return this.subject;
    }

    public void setsubject(Name value) {
        this.subject = value;
    }

    public SubjectPublicKeyInfo getsubjectPKInfo() {
        return this.subjectPKInfo;
    }

    public void setsubjectPKInfo(SubjectPublicKeyInfo value) {
        this.subjectPKInfo = value;
    }

    public SetOf getattributes() {
        return this.attributes;
    }

    public void setattributes(SetOf value) {
        this.attributes = value;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] data) throws DecodeException {
        this.setForcedTagMethod(1);
        super.decode(data);
        this.setversion((ASN1Integer)super.getElement(0));
        this.setsubject((Name)super.getElement(1));
        this.setsubjectPKInfo((SubjectPublicKeyInfo)super.getElement(2));
        this.setattributes((SetOf)super.getElement(3));
        this.commitElementUpdate();
    }
}

