/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.AccessDescription;
import com.turktrust.x509.Extension;
import com.turktrust.x509.GeneralName;
import java.util.Vector;

public class AuthorityInfoAccessSyntax
extends Extension {
    public static final String EXT_OBJ_ID = "1.3.6.1.5.5.7.1.1";
    private Vector vecAccDesc;

    public AuthorityInfoAccessSyntax(String name, boolean critical, Vector accessDescVec) {
        super(name);
        this.vecAccDesc = accessDescVec;
        SequenceOf seqAD = new SequenceOf("seqAD", new AccessDescription());
        for (AccessDescription ad : this.vecAccDesc) {
            seqAD.addElement(ad);
        }
        ObjectID authInfoAccessObjId = new ObjectID("authInfoAccess");
        authInfoAccessObjId.setValue(EXT_OBJ_ID);
        this.setextnID(authInfoAccessObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        byte[] octBytes = seqAD.getEncoded();
        OctetString extOcts = new OctetString("extAuthInfoAccess");
        extOcts.setValue(octBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public AuthorityInfoAccessSyntax() {
        super("default_AIA");
        this.vecAccDesc = null;
        ObjectID authInfoAccessObjId = new ObjectID("authInfoAccess");
        authInfoAccessObjId.setValue(EXT_OBJ_ID);
        this.setextnID(authInfoAccessObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) throws DecodeException {
        SequenceOf seq = new SequenceOf("accessDescs", new AccessDescription());
        seq.decode(extValBytes);
        this.vecAccDesc = (Vector)seq.getValue();
        OctetString octs = new OctetString("seq", extValBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public Vector getAccessDescriptions() {
        return this.vecAccDesc;
    }

    public String getExtensionTitle() {
        return "Authority Info Access";
    }

    public String getTurkishExtensionTitle() {
        return "ESHS Bilgi Eri\u015fimi";
    }

    public String getExplanation() {
        String exp = "";
        for (int i = 0; i < this.vecAccDesc.size(); ++i) {
            AccessDescription ad = (AccessDescription)this.vecAccDesc.elementAt(i);
            ObjectID acMethodId = ad.getAccessMethod();
            if (acMethodId.equals("1.3.6.1.5.5.7.48.2")) {
                exp = exp + "CA Issuers: ";
            } else if (acMethodId.equals("1.3.6.1.5.5.7.48.1")) {
                exp = exp + "OCSP: ";
            }
            GeneralName gn = ad.getAccessLocation();
            if (gn.getURI() == null || gn.getURI().length() <= 0) continue;
            exp = exp + gn.getURI();
            if (i >= this.vecAccDesc.size() - 1) continue;
            exp = exp + "\n";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        for (int i = 0; i < this.vecAccDesc.size(); ++i) {
            AccessDescription ad = (AccessDescription)this.vecAccDesc.elementAt(i);
            ObjectID acMethodId = ad.getAccessMethod();
            if (acMethodId.equals("1.3.6.1.5.5.7.48.2")) {
                exp = exp + "K\u00f6k sertifika: ";
            } else if (acMethodId.equals("1.3.6.1.5.5.7.48.1")) {
                exp = exp + "OCSP: ";
            }
            GeneralName gn = ad.getAccessLocation();
            if (gn.getURI() == null || gn.getURI().length() <= 0) continue;
            exp = exp + gn.getURI();
            if (i >= this.vecAccDesc.size() - 1) continue;
            exp = exp + "\n";
        }
        return exp;
    }
}

