/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Sequence;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.Time;

public class RevokedCertificate
extends Sequence {
    private ASN1Integer serialNoAsn = new ASN1Integer("serialNo");
    private Time revDateAsn = new Time("revDateAsn");
    private Extensions extsAsn = new Extensions("crlEntryExtensions");

    public RevokedCertificate() {
        super("default_revokedCertificate");
        this.setUpElements();
    }

    public RevokedCertificate(String name) {
        super(name);
        this.setUpElements();
    }

    private void setUpElements() {
        super.addElement(this.serialNoAsn);
        super.addElement(this.revDateAsn);
        super.addElement(this.extsAsn);
        this.extsAsn.setOptional(true);
    }

    public void setSerialNo(ASN1Integer givenSerial) {
        this.serialNoAsn = givenSerial;
    }

    public ASN1Integer getSerialNo() {
        return this.serialNoAsn;
    }

    public void setRevocationDate(Time givenRevDate) {
        this.revDateAsn = givenRevDate;
    }

    public Time getRevocationDate() {
        return this.revDateAsn;
    }

    public void setExtensions(Extensions exts) {
        this.extsAsn = exts;
    }

    public Extensions getExtensions() {
        return this.extsAsn;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

