/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.check;

import java.util.Iterator;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.PAdESSignature;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.PadesChecker;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.ValidationResultDetailImpl;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.check.TSDigestChecker;
import tr.gov.tubitak.uekae.esya.api.signature.SignatureType;
import tr.gov.tubitak.uekae.esya.api.signature.ValidationResultDetail;
import tr.gov.tubitak.uekae.esya.api.signature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.SignaturePolicyIdentifier;

public class PadesProfileRevocationValueMatcherChecker
implements PadesChecker {
    CertificateStatusInfo a;

    public PadesProfileRevocationValueMatcherChecker(CertificateStatusInfo aCsi) {
        this.a = aCsi;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidationResultDetail check(PAdESSignature signature) {
        Iterator iterator;
        String string = CMSSignatureI18n.getMsg((Enum)E_KEYS.PROFILE_REVOCATION_VALUE_MATCHER_CHECKER, (String[])new String[0]);
        String string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.PROFILE_REVOCATION_VALUE_MATCHER_CHECKER_SUCCESSFUL, (String[])new String[0]);
        SignaturePolicyIdentifier signaturePolicyIdentifier = signature.getSignaturePolicy();
        int n = TSDigestChecker.b;
        try {
            TurkishESigProfile turkishESigProfile = signature.getContainer().getContext().getConfig().getCertificateValidationConfig().getValidationProfile();
            if (turkishESigProfile == null && signaturePolicyIdentifier != null) {
                turkishESigProfile = signaturePolicyIdentifier.getTurkishESigProfile();
            }
            if (turkishESigProfile == null) {
                return null;
            }
            SignatureType signatureType = signature.getSignatureType();
            boolean bl = true;
            if (signatureType == SignatureType.ES_BES || signatureType == SignatureType.ES_EPES || signatureType == SignatureType.ES_T || signatureType == SignatureType.ES_C) {
                bl = false;
            }
            if (!(bl || turkishESigProfile != TurkishESigProfile.P3_1 && turkishESigProfile != TurkishESigProfile.P4_1)) {
                string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.PROFILE_REVOCATION_VALUE_MATCHER_CHECKER_UNSUCCESSFUL, (String[])new String[0]);
                return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
            }
            if (turkishESigProfile != TurkishESigProfile.P3_1) {
                if (turkishESigProfile != TurkishESigProfile.P4_1) return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.VALID);
                List list = this.a.getOCSPResponseInfoList();
                for (OCSPResponseStatusInfo oCSPResponseStatusInfo : list) {
                    if (oCSPResponseStatusInfo.getOCSPResponseStatus() == OCSPResponseStatusInfo.OCSPResponseStatus.VALID) {
                        return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.VALID);
                    }
                    if (n == 0) continue;
                }
                string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.PROFILE_REVOCATION_VALUE_MATCHER_CHECKER_UNSUCCESSFUL, (String[])new String[0]);
                return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
            }
            List list = this.a.getCRLInfoList();
            iterator = list.iterator();
        }
        catch (Exception exception) {
            string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.PROFILE_REVOCATION_VALUE_MATCHER_CHECKER_UNSUCCESSFUL, (String[])new String[0]);
            return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
        }
        while (iterator.hasNext()) {
            CRLStatusInfo cRLStatusInfo = (CRLStatusInfo)iterator.next();
            if (cRLStatusInfo.getCRLStatus() == CRLStatus.VALID) {
                return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.VALID);
            }
            if (n == 0) continue;
        }
        string2 = CMSSignatureI18n.getMsg((Enum)E_KEYS.PROFILE_REVOCATION_VALUE_MATCHER_CHECKER_UNSUCCESSFUL, (String[])new String[0]);
        return new ValidationResultDetailImpl(this.getClass(), string, string2, ValidationResultType.INVALID);
    }
}

