/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.MA3APIEnvironment;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.SmartCardI18n;
import tr.gov.tubitak.uekae.esya.api.smartcard.keyfinder.ModulusFinderFromObjectID;
import tr.gov.tubitak.uekae.esya.api.smartcard.keyfinder.PublicKeyFinderWithLabel;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.ISmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.EncryptionSchemeFactory;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.IEncryptionScheme;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.ISignatureScheme;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.SignatureSchemeFactory;

public class SmartOp {
    private long a;
    private CardType b;
    private String c;
    private static Logger d;
    private static final String[] e;
    private static final String[] f;

    public SmartOp(long aSlotID, CardType aCardType, String aPassword) {
        this();
        this.initialize(aSlotID, aCardType, aPassword);
    }

    public SmartOp() {
        try {
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
        }
        catch (LE lE) {
            throw new RuntimeException(SmartOp.a(-3520, 27971) + lE.getMessage(), lE);
        }
    }

    public void initialize(long aSlotID, CardType aCardType, String aPassword) {
        this.a = aSlotID;
        this.b = aCardType;
        this.c = aPassword;
    }

    public static boolean _in(long aElement, long[] aList) {
        int n = CardType.b;
        if (aList == null) {
            return false;
        }
        for (int i = 0; i < aList.length; ++i) {
            if (aList[i] != aElement) continue;
            return true;
        }
        return false;
    }

    public static Pair<Long, CardType> findCardTypeAndSlot(Application aApp) throws SmartCardException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            int n = list.size();
            String string = "";
            CardTerminal cardTerminal = null;
            while (true) {
                if (n == 0) {
                    throw new SmartCardException(SmartOp.a(-3481, -30541));
                }
                if (n == 1) {
                    string = list.get(0).getName();
                    cardTerminal = list.get(0);
                    break;
                }
                int n2 = 0;
                n2 = SmartOp.a(list);
                if (n2 != -1) {
                    string = list.get(n2).getName();
                    cardTerminal = terminalFactory.terminals().getTerminal(string);
                    break;
                }
                list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
                n = list.size();
            }
            Card card = cardTerminal.connect("*");
            String string2 = SmartOp.a(card.getATR().getBytes());
            card.disconnect(false);
            CardType cardType = CardType.getCardTypeFromATR(string2, aApp);
            if (cardType == CardType.UNKNOWN) {
                return new Pair(null, (Object)cardType);
            }
            Long l = null;
            try {
                l = SmartOp.a(cardType, string);
            }
            catch (Exception exception) {
                d.warn(SmartOp.a(-3497, 28296), (Throwable)exception);
                l = null;
            }
            return new Pair((Object)l, (Object)cardType);
        }
        catch (SmartCardException smartCardException) {
            throw smartCardException;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-3474, 30712), exception);
        }
    }

    public static List<Pair<Long, CardType>> findCardTypesAndSlots(Application aApp) throws SmartCardException {
        int n = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            int n2 = list.size();
            if (n2 == 0) {
                throw new SmartCardException(SmartOp.a(-3511, -7540));
            }
            ArrayList<Pair<Long, CardType>> arrayList = new ArrayList<Pair<Long, CardType>>();
            for (CardTerminal cardTerminal : list) {
                block11: {
                    CardType cardType;
                    String string;
                    block10: {
                        string = cardTerminal.getName();
                        Card card = cardTerminal.connect("*");
                        String string2 = SmartOp.a(card.getATR().getBytes());
                        card.disconnect(false);
                        cardType = SmartCard.findCardType(string2, aApp);
                        if (cardType != CardType.UNKNOWN) break block10;
                        arrayList.add((Pair<Long, CardType>)new Pair(null, (Object)cardType));
                        if (n == 0) break block11;
                    }
                    Long l = null;
                    try {
                        l = SmartOp.a(cardType, string);
                    }
                    catch (Exception exception) {
                        d.warn(SmartOp.a(-3497, 28296), (Throwable)exception);
                        l = null;
                    }
                    arrayList.add((Pair<Long, CardType>)new Pair((Object)l, (Object)cardType));
                }
                if (n == 0) continue;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-3494, -31301), exception);
        }
    }

    public static Pair<Long, CardType> findCardTypeAndSlot() throws SmartCardException {
        return SmartOp.findCardTypeAndSlot(Application.ESIGNATURE);
    }

    public static List<Pair<Long, CardType>> findCardTypesAndSlots() throws SmartCardException {
        return SmartOp.findCardTypesAndSlots(Application.ESIGNATURE);
    }

    private static List<CardTerminal> a(TerminalFactory terminalFactory, CardTerminals.State state) throws CardException {
        return SmartOp.a(terminalFactory, state, true);
    }

    private static List<CardTerminal> a(TerminalFactory terminalFactory, CardTerminals.State state, boolean bl) throws CardException {
        ArrayList<CardTerminal> arrayList = new ArrayList();
        try {
            arrayList = terminalFactory.terminals().list(state);
        }
        catch (CardException cardException) {
            block11: {
                if (!bl || cardException.getCause() == null) break block11;
                if (!SmartOp.a(-3499, 28902).equals(cardException.getCause().getMessage())) break block11;
                SmartOp.a();
                return SmartOp.a(terminalFactory, state, false);
            }
            if (!cardException.getCause().getMessage().contains(SmartOp.a(-3483, -27554))) {
                throw cardException;
            }
        }
        return arrayList;
    }

    private static void a() {
        try {
            d.warn(SmartOp.a(-3473, -11265));
            Class<?> clazz = Class.forName(SmartOp.a(-3486, -29485));
            Field field = clazz.getDeclaredField(SmartOp.a(-3492, 22428));
            field.setAccessible(true);
            if (field.getLong(clazz) != 0L) {
                Class<?> clazz2 = Class.forName(SmartOp.a(-3464, 19876));
                Method method = clazz2.getDeclaredMethod(SmartOp.a(-3507, 1941), Integer.TYPE);
                method.setAccessible(true);
                Field field2 = clazz2.getDeclaredField(SmartOp.a(-3506, -31354));
                field2.setAccessible(true);
                long l = (Long)method.invoke(clazz2, field2.getInt(clazz2));
                field.setLong(clazz, l);
                TerminalFactory terminalFactory = TerminalFactory.getDefault();
                CardTerminals cardTerminals = terminalFactory.terminals();
                Field field3 = clazz.getDeclaredField(SmartOp.a(-3493, -32652));
                field3.setAccessible(true);
                Class<?> clazz3 = Class.forName(SmartOp.a(-3514, -5842));
                Method method2 = clazz3.getDeclaredMethod(SmartOp.a(-3501, 7115), new Class[0]);
                method2.invoke(field3.get(cardTerminals), new Object[0]);
                Field field4 = clazz.getDeclaredField(SmartOp.a(-3489, 17106));
                field4.setAccessible(true);
                method2.invoke(field4.get(cardTerminals), new Object[0]);
                d.info(SmartOp.a(-3509, 29779));
            }
        }
        catch (Exception exception) {
            d.warn(SmartOp.a(-3477, -20484), (Throwable)exception);
        }
    }

    private static int a(List<CardTerminal> list) {
        int n = list.size();
        int n2 = CardType.b;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = list.get(i).getName();
            if (n2 == 0) continue;
        }
        return SmartOp.secenekSor(null, null, stringArray, SmartOp.a(-3488, -18849), new String[]{SmartCardI18n.getMsg(E_KEYS.OK, null)});
    }

    private static long a(CardType cardType, String string) throws PKCS11Exception, IOException {
        SmartCard smartCard = new SmartCard(cardType);
        long[] lArray = smartCard.getTokenPresentSlotList();
        long l = 0L;
        long[] lArray2 = lArray;
        int n = lArray2.length;
        int n2 = CardType.b;
        for (int i = 0; i < n; ++i) {
            long l2 = lArray2[i];
            String string2 = new String(smartCard.getSlotInfo((long)l2).slotDescription).trim();
            if (!string.contains(string2)) continue;
            l = l2;
            if (n2 == 0) break;
            if (n2 == 0) continue;
            break;
        }
        return l;
    }

    private static String a(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = CardType.b;
        if (byArray == null) {
            return SmartOp.a(-3476, 25024);
        }
        if (byArray.length == 0) {
            return SmartOp.a(-3478, 14428);
        }
        byte[] byArray2 = new byte[byArray.length * 2];
        int n2 = 0;
        for (byte by : byArray) {
            byArray2[n2++] = (byte)cArray[(by & 0xF0) >> 4];
            byArray2[n2++] = (byte)cArray[by & 0xF];
            if (n == 0) continue;
            break;
        }
        return new String(byArray2);
    }

    public static String[] getCardTerminals() throws SmartCardException {
        int n = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).getName();
                if (n == 0) continue;
            }
            return stringArray;
        }
        catch (CardException cardException) {
            throw new SmartCardException(SmartOp.a(-3508, 14238), cardException);
        }
    }

    public static String[] getCardATRs() throws SmartCardException {
        String[] stringArray = null;
        int n = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String string;
                CardTerminal cardTerminal = list.get(i);
                Card card = cardTerminal.connect("*");
                stringArray[i] = string = StringUtil.toHexString((byte[])card.getATR().getBytes());
                if (n == 0) continue;
                break;
            }
        }
        catch (CardException cardException) {
            throw new SmartCardException(SmartOp.a(-3459, 5015), cardException);
        }
        return stringArray;
    }

    public static Pair<Long, CardType> getSlotAndCardType(String terminal, Application aApp) throws SmartCardException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminal cardTerminal = terminalFactory.terminals().getTerminal(terminal);
            Card card = cardTerminal.connect("*");
            String string = SmartOp.a(card.getATR().getBytes());
            card.disconnect(false);
            CardType cardType = CardType.getCardTypeFromATR(string, aApp);
            Long l = null;
            try {
                if (cardType != CardType.UNKNOWN) {
                    l = SmartOp.a(cardType, terminal);
                }
            }
            catch (Exception exception) {
                d.warn(SmartOp.a(-3504, -31910), (Throwable)exception);
                l = null;
            }
            Pair pair = new Pair((Object)l, (Object)cardType);
            return pair;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-3491, -7115), exception);
        }
    }

    public static Pair<Long, CardType> getSlotAndCardType(String terminal) throws SmartCardException {
        return SmartOp.getSlotAndCardType(terminal, Application.ESIGNATURE);
    }

    public String getCardSerialNumber() throws PKCS11Exception, IOException {
        SmartCard smartCard = new SmartCard(this.b);
        return new String(smartCard.getTokenInfo((long)this.a).serialNumber).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importCertificateAndKey(String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.importCertificateAndKey(l, aCertLabel, aKeyLabel, aPrivKey, aCert);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) throws PKCS11Exception, IOException {
        boolean bl;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            bl = smartCard.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertData, aSignOrEnc);
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importKeyPair(String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.importKeyPair(l, aLabel, aKeyPair, aSubject, aIsSign, aIsEncrypt);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readCertificate(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.readCertificate(l, aLabel);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getSignCertificates() throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.getSignatureCertificates(l);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getEncryptCertificates() throws IOException, PKCS11Exception, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.getEncryptionCertificates(l);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importCertificate(String aCertLabel, X509Certificate aCert) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        int n = CardType.b;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.importCertificate(l, aCertLabel, aCert);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-3516, 9451))) throw pKCS11Exception;
            smartCard.login(l, this.c);
            smartCard.importCertificate(l, aCertLabel, aCert);
            smartCard.logout(l);
            if (n == 0) return;
            throw pKCS11Exception;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readPrivateData(String aLabel) throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            List<byte[]> list2 = smartCard.readPrivateData(l, aLabel);
            smartCard.logout(l);
            list = list2;
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readPublicData(String aLabel) throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            List<byte[]> list2;
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = list2 = smartCard.readPublicData(l, aLabel);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePrivateData(String aLabel, byte[] aData) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.writePrivateData(l, aLabel, aData);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePublicData(String aLabel, byte[] aData) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.writePublicData(l, aLabel, aData);
            smartCard.logout(l);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.warn(SmartOp.a(-3497, 28296), (Throwable)pKCS11Exception);
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-3515, 22466))) return;
            smartCard.login(l, this.c);
            smartCard.writePublicData(l, aLabel, aData);
            smartCard.logout(l);
            return;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deletePrivateData(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.deletePrivateData(l, aLabel);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePublicData(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        int n = CardType.b;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.deletePublicData(l, aLabel);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-3515, 22466))) throw pKCS11Exception;
            smartCard.login(l, this.c);
            smartCard.deletePublicData(l, aLabel);
            smartCard.logout(l);
            if (n == 0) return;
            throw pKCS11Exception;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isObjectExist(String aLabel, boolean aIsPrivate) throws IOException, PKCS11Exception {
        boolean bl;
        SmartCard smartCard = null;
        int n = CardType.b;
        long l = -1L;
        try {
            boolean bl2;
            block9: {
                block8: {
                    smartCard = new SmartCard(this.b);
                    l = smartCard.openSession(this.a);
                    if (!aIsPrivate) break block8;
                    smartCard.login(l, this.c);
                    bl2 = smartCard.isObjectExist(l, aLabel);
                    smartCard.logout(l);
                    if (n == 0) break block9;
                }
                bl2 = smartCard.isObjectExist(l, aLabel);
            }
            bl = bl2;
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCardEmpty() throws PKCS11Exception, IOException {
        boolean bl;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            bl = smartCard.isAnyObjectExist(l);
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateKeyPair(String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        int n = CardType.b;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-3495, -24770));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            boolean bl = smartCard.isObjectExist(l, aKeyLabel);
            if (bl) {
                throw new SmartCardException(aKeyLabel + SmartOp.a(-3503, -13072));
            }
            smartCard.createKeyPair(l, aKeyLabel, aParamSpec, aIsSign, aIsEncrypt);
            smartCard.logout(l);
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
        if (n != 0) {
            SmartCardException.b = !SmartCardException.b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeySpec getPublicKeySpec(String aKeyLabel) throws PKCS11Exception, IOException, SmartCardException {
        KeySpec keySpec;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            KeySpec keySpec2;
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-3495, -24770));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            keySpec = keySpec2 = smartCard.readPublicKeySpec(l, aKeyLabel);
            if (smartCard == null) return keySpec;
            if (l == -1L) return keySpec;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return keySpec;
    }

    public byte[] sign(byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, IOException, SmartCardException {
        return this.sign(aCertSerialNo, aToBeSigned, aSigningAlg, null);
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.sign(aSC, aSessionID, aSlotID, aCertSerialNo, aToBeSigned, aSigningAlg, null);
    }

    public byte[] sign(String aKeyLabel, byte[] aToBeSigned, String aSigningAlg) throws IOException, PKCS11Exception, SmartCardException {
        return this.sign(aKeyLabel, aToBeSigned, aSigningAlg, null);
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.sign(aSC, aSessionID, aSlotID, aKeyLabel, aToBeSigned, aSigningAlg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg, AlgorithmParameterSpec aParams) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-3495, -24770));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.sign((ISmartCard)smartCard, l, this.a, aCertSerialNo, aToBeSigned, aSigningAlg, aParams);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, byte[] aCertSerialNo, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, aParamSpec, lArray, modulusFinderFromObjectID);
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanacak);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray2 = aSC.signDataWithKeyID(aSessionID, l, cK_MECHANISM, byArray);
            return byArray2;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-3519, 8786), aSC.getCardType(), aSlotID, StringUtil.toHexString((byte[])aCertSerialNo), aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-3519, 8786), aSC.getCardType(), aSlotID, StringUtil.toHexString((byte[])aCertSerialNo), aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(String aAnahtarAdi, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParams) throws IOException, PKCS11Exception, SmartCardException {
        byte[] byArray;
        SmartCard smartCard = null;
        long l = -1L;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-3495, -24770));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.sign((ISmartCard)smartCard, l, this.a, aAnahtarAdi, aImzalanacak, aSigningAlg, aParams);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, String aAnahtarAdi, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, aParamSpec, lArray, modulusFinderFromObjectID);
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanacak);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray2 = aSC.signData(aSessionID, aAnahtarAdi, byArray, cK_MECHANISM);
            return byArray2;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-3479, -21366), aSC.getCardType(), aSlotID, aAnahtarAdi, aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-3479, -21366), aSC.getCardType(), aSlotID, aAnahtarAdi, aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(String aAnahtarAdi, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg) throws IOException, PKCS11Exception, SmartCardException {
        boolean bl;
        ISmartCard iSmartCard = null;
        long l = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-3498, 31047));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            iSmartCard = new SmartCard(this.b);
            l = iSmartCard.openSession(this.a);
            iSmartCard.login(l, this.c);
            boolean bl2 = SmartOp.verify(iSmartCard, l, this.a, aAnahtarAdi, aImzalanan, aDogrulanacak, aSigningAlg);
            iSmartCard.logout(l);
            bl = bl2;
            if (iSmartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (iSmartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            iSmartCard.closeSession(l);
            throw throwable;
        }
        iSmartCard.closeSession(l);
        return bl;
    }

    public static boolean verify(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        try {
            PublicKeyFinderWithLabel publicKeyFinderWithLabel = new PublicKeyFinderWithLabel(aSC, aSessionID, aKeyLabel);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(false, aSigningAlg, null, lArray, publicKeyFinderWithLabel);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanan);
            boolean bl = false;
            try {
                aSC.verifyData(aSessionID, aKeyLabel, byArray, aDogrulanacak, cK_MECHANISM.mechanism);
                bl = true;
            }
            catch (PKCS11Exception pKCS11Exception) {
                d.error(SmartOp.a(-3460, 22587), (Throwable)pKCS11Exception);
            }
            return bl;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-3513, 9940), aSC.getCardType(), aSlotID, aKeyLabel, aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-3479, -21366), aSC.getCardType(), aSlotID, aKeyLabel, aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encrypt(String aAnahtarAdi, byte[] aSifrelenecek, String aAlgoritma, AlgorithmParameterSpec aParametreler) throws IOException, PKCS11Exception, SmartCardException {
        byte[] byArray;
        ISmartCard iSmartCard = null;
        long l = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-3495, -24770));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            iSmartCard = new SmartCard(this.b);
            l = iSmartCard.openSession(this.a);
            iSmartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.encrypt(iSmartCard, l, aAnahtarAdi, aSifrelenecek, aAlgoritma, aParametreler);
            iSmartCard.logout(l);
            byArray = byArray2;
            if (iSmartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (iSmartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            iSmartCard.closeSession(l);
            throw throwable;
        }
        iSmartCard.closeSession(l);
        return byArray;
    }

    public static byte[] encrypt(ISmartCard aSC, long aSessionID, String aAnahtarAdi, byte[] aSifrelenecek, String aAlgoritma, AlgorithmParameterSpec aParametreler) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(true, aAlgoritma, aParametreler, aSC, aSessionID, modulusFinderFromObjectID);
            byte[] byArray = aSC.encryptData(aSessionID, aAnahtarAdi, iEncryptionScheme.getResult(aSifrelenecek), iEncryptionScheme.getMechanism());
            return byArray;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-3484, 780), aSC.getCardType(), aAnahtarAdi, aAlgoritma), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-3490, -20142), aSC.getCardType(), aAnahtarAdi, aAlgoritma), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(String aAnahtarAdi, byte[] aCozulecek, String aAlgoritma, AlgorithmParameterSpec aParam) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-3495, -24770));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.decrypt((ISmartCard)smartCard, l, this.a, aAnahtarAdi, aCozulecek, aAlgoritma, aParam);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    @Deprecated
    public byte[] decrypt(String aKeyLabel, byte[] aEncryptedData) throws PKCS11Exception, IOException, SmartCardException {
        return this.decrypt(aKeyLabel, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public byte[] decrypt(byte[] aCertSerialNo, byte[] aEncryptedData) throws PKCS11Exception, IOException, SmartCardException {
        return this.decrypt(aCertSerialNo, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public static byte[] decrypt(ISmartCard aSC, long aSessionID, byte[] aCertSerialNo, byte[] aEncryptedData) throws SmartCardException, PKCS11Exception {
        long l = aSC.getSessionInfo((long)aSessionID).slotID;
        return SmartOp.decrypt(aSC, aSessionID, l, aCertSerialNo, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public static byte[] decrypt(ISmartCard aSC, long aSessionID, String aKeyLabel, byte[] aEncryptedData) throws SmartCardException, PKCS11Exception {
        long l = aSC.getSessionInfo((long)aSessionID).slotID;
        return SmartOp.decrypt(aSC, aSessionID, l, aKeyLabel, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(byte[] aCertSerialNo, byte[] aCozulecek, String aAlgoritma, AlgorithmParameterSpec aParam) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        int n;
        block11: {
            n = CardType.b;
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-3495, -24770));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            SmartCard smartCard = null;
            long l = -1L;
            try {
                smartCard = new SmartCard(this.b);
                l = smartCard.openSession(this.a);
                smartCard.login(l, this.c);
                byte[] byArray2 = SmartOp.decrypt((ISmartCard)smartCard, l, this.a, aCertSerialNo, aCozulecek, aAlgoritma, aParam);
                smartCard.logout(l);
                byArray = byArray2;
                if (smartCard == null || l == -1L) break block11;
            }
            catch (Throwable throwable) {
                if (smartCard == null) throw throwable;
                if (l == -1L) throw throwable;
                smartCard.closeSession(l);
                throw throwable;
            }
            smartCard.closeSession(l);
        }
        if (!SmartCardException.b) return byArray;
        CardType.b = ++n;
        return byArray;
    }

    public static byte[] decrypt(ISmartCard aSC, long aSessionID, long aSlot, byte[] aCertSerialNo, byte[] aCozulecek, String aAlgorithm, AlgorithmParameterSpec aParams) throws SmartCardException, PKCS11Exception {
        try {
            long l = aSC.getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.decryptDataWithCertSerialNo(aSessionID, aCertSerialNo, iEncryptionScheme.getMechanism(), aCozulecek);
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-3500, -17748), aSC.getCardType(), aSlot, StringUtil.toHexString((byte[])aCertSerialNo), aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-3519, 8786), aSC.getCardType(), aSlot, StringUtil.toHexString((byte[])aCertSerialNo), aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static byte[] decrypt(ISmartCard aSC, long aSessionID, long aSlot, String aAnahtarAdi, byte[] aCozulecek, String aAlgorithm, AlgorithmParameterSpec aParams) throws SmartCardException, PKCS11Exception {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.decryptData(aSessionID, aAnahtarAdi, aCozulecek, iEncryptionScheme.getMechanism());
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-3479, -21366), aSC.getCardType(), aSlot, aAnahtarAdi, aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-3479, -21366), aSC.getCardType(), aSlot, aAnahtarAdi, aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static byte[] wrap(ISmartCard aSC, long aSessionID, long aSlot, String aAlgorithm, String wrapperKeyLabel, String labelOfKeyToWrap, AlgorithmParameterSpec aParams) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPublicKeyObjIDFromPublicKeyLabel(aSessionID, wrapperKeyLabel);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.wrapKey(aSessionID, iEncryptionScheme.getMechanism(), wrapperKeyLabel, labelOfKeyToWrap);
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-3517, 11549), aSC.getCardType(), aSlot, wrapperKeyLabel, labelOfKeyToWrap, aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-3496, -23942), aSC.getCardType(), aSlot, wrapperKeyLabel, labelOfKeyToWrap, aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static void unwrap(ISmartCard aSC, long aSessionID, long aSlot, String aAlgorithm, String unwrapperKeyLabel, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate, AlgorithmParameterSpec aParams) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, unwrapperKeyLabel);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            aSC.unwrapKey(aSessionID, iEncryptionScheme.getMechanism(), unwrapperKeyLabel, wrappedKey, unwrappedKeyTemplate);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-3485, 28422), aSC.getCardType(), aSlot, unwrapperKeyLabel), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-3512, -12429), aSC.getCardType(), aSlot, unwrapperKeyLabel), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public long getSlot() {
        return this.a;
    }

    public CardType getCardType() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void formatToken(String aSOpin, String aNewPIN, String aLabel) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.formatToken(aSOpin, aNewPIN, aLabel, (int)this.a);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePassword(String aOldPass, String aNewPass) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.changePassword(aOldPass, aNewPass, l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePuk(byte[] aSOPin, byte[] aNewSOPin) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.setSOPin(aSOPin, aNewSOPin, l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    public static long findSlotNumber(CardType aCardType) throws PKCS11Exception, IOException, SmartCardException {
        return SmartOp.findSlotNumber(aCardType, SmartOp.a(-3510, 30045));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long findSlotNumber(CardType aCardType, String message) throws PKCS11Exception, IOException, SmartCardException {
        int n = 1;
        int n2 = CardType.b;
        do {
            Object[] objectArray;
            JComboBox<String> jComboBox;
            SmartCard smartCard;
            long[] lArray;
            int n3;
            if ((n3 = (lArray = (smartCard = new SmartCard(aCardType)).getTokenPresentSlotList()).length) == 0) {
                throw new SmartCardException(SmartOp.a(-3518, -11488));
            }
            if (n3 == 1) {
                return lArray[0];
            }
            String[] stringArray = new String[n3];
            int n4 = lArray.length;
            for (int i = 0; i < n4; ++i) {
                long l = lArray[i];
                String string = "";
                try {
                    string = string + " " + new String(smartCard.getSlotInfo((long)l).slotDescription).trim();
                }
                catch (Exception exception) {
                    d.warn(SmartOp.a(-3497, 28296), (Throwable)exception);
                }
                try {
                    string = string + " " + new String(smartCard.getTokenInfo((long)l).label).trim().split("\u0000")[0];
                }
                catch (Exception exception) {
                    d.warn(SmartOp.a(-3497, 28296), (Throwable)exception);
                }
                stringArray[i] = string;
                if (n2 == 0) continue;
            }
            if ((n = JOptionPane.showOptionDialog(null, jComboBox = new JComboBox<String>(stringArray), message, 2, -1, null, objectArray = new String[]{SmartOp.a(-3505, -10558), SmartOp.a(-3462, 24548), SmartOp.a(-3480, -15227)}, objectArray[0])) == 0) {
                return lArray[jComboBox.getSelectedIndex()];
            }
            if (n != 2) continue;
            throw new SmartCardException(SmartOp.a(-3463, 17122));
        } while (n == 1 && n2 == 0);
        throw new ESYARuntimeException(SmartOp.a(-3475, 27154) + n);
    }

    public static int secenekSor(Component aParent, Icon aIcon, String[] aSecenekList, String aBaslik, String[] aOptions) {
        JComboBox<String> jComboBox = new JComboBox<String>(aSecenekList);
        int n = JOptionPane.showOptionDialog(aParent, jComboBox, aBaslik, 2, -1, null, aOptions, aOptions[0]);
        if (n == 1) {
            return -1;
        }
        return jComboBox.getSelectedIndex();
    }

    /*
     * Unable to fully structure code
     */
    static {
        block25: {
            block24: {
                block23: {
                    var5 = new String[54];
                    var3_1 = 0;
                    var2_2 = "\u0013\u009a\u008c!\u0084H\u00fd\u00b8?\u00f5\u00d1\u00e3\u0095r\u0002\u00fa\u009d\u0015\u0014\u00b9S9\u00f2\u00aa\u0095#iA\u00cc\u0091y\u009e\u001d\u0098(6\tQB\u00ffE5,3\u00f9\u0010\u00b3\u00f0\u0094\u00ecT/\u001f\u00e6\u00beW\u00b08\u0099aV\u00d8{h`'`\u00e7\u00a3\u0089\u001fQ\u00cd\u00b0\u001c\u0084\u00f6A\u00aa\u00e7Z\u00ac\u00bf\u0088\t\u00ad\u00be8\u001ck4\u0003\u00c4\u0080,]\u0018*\u00e5\u00e1\u00c1\u00a5\u00b7\f\u00ebh+\u00cdb\f\u00c6\u00e1I\u00bd\u0089\u00ec\u00c4\u00a4\u00c8\u008f\u00aa\u00d9jS\u00dc9a\u00bc\u0083\u0091K\u008f0\u00e4\u00a9k\u00d0\u001bw\u0018g\u00farlM\u00c7]\u00ae\u00e0Il\u008d\u00f0(\u00d7\u00bc`Af|A^7.\u0015:\u00bc\u00c4\u0090\u007fjW FG\u00b7ae#\u0006\u00be^\u007f\u00c3l\u00e6\u0010\u00a1\u00b4\u0097\u00b1\u0011p\u009e\ru\u0001\u0013\u00eb\u00db\u00b95\u008c\u0002@4\u001bB=%\u00dc\u0019\u00a4\u0083\u0016\u00ebq\u00d51.U\u00c6\u00bb\u00bal\u00c4\u00a0\u00d4\u00c4\u0005n\u0099i'?OR\u00078\u00f5k\u00d3\u00dc\u00fayir\u0082@\u00e0\u00bc\u00c1\u00dd\u009f\u00a0\"\u001a\u00dc\u00ceP\u00af\u00d1\u00d0\u00db\u00a3\u009b\u00d8W[\u0090\"\u00ad\u0000\u00a0nH\u00c6\u008a\u00c9\u008cq6w\u0017\u00f2z\u008b\u009fF\u0019\u00a3\u00fb3\u00fb\u00d8\u00b7\r\u00bc\u000f\u00af\u00d9\u0089\u0084\u00ba\u00ec]u\u00e3#9\u00e5\u008a\u00ec\u0018U\u001b&\u008d\u00b6\u00a4\u00ba\u00f9\u00e6\u00bf>\u00c1\u009a\u0097]B\u001f\u0095\u00a9\u0015.s\u00cb\u00f6\u00f4\u0015\u00e8y8\u00ce\u00be9{\u00178\u001d\u00bfN7\u009b\u00c1\u0002^\u00133\u00fb\u00cbp~;R\u00efc^\u00e9C\u00ee@A\u00beD\\.\u0080s3t>W\u00af\u00b0\u00f3.\u00ed\u0095\u00fdJw\u00f5\u0012\u00f2Cpo=p\u0016\u00c8\u008d\u00bb\u0092\u00f4\u00b4\u0007\t\u0082\u00ac\u00f5\u0088F\u00a0\u00c7F\u00c2|}<\t\u0089\u0016\u0019~\u0081\u00ec\u00b3{\u00ef\u00f0\u009f\u0093Vo2\\I\u00d9\u0013\u008fGBNF\r\u0081\u00c9\u00baK\u000fP]L\u00ed8OC|@ \u00ff\u00ea\u008dH\u00ddd\n\f\u00a3\u00b7)Y+\u009b\u00d1\u00aepr\u0015\u009f\u00ack\u0018\u00a6u\u000f\u008b\u0000\u00c8\u00e0\u00b5:\u00fdl\u0080d\u00cfZZ7(\u014a\u0007\u00a5\u00b8l\u007f\u00f6\u00e9\u00e6\u00ae\u008c\u0095iz\u0091\u00b3~w\u00e1\u00e9\b\u00a0Ulic_y\u0087BA\u00c8\u00ca/\u0004J\u008e\u00f9e\u00e2\u00e6\u00fb\u00c7\u00ae\u00f6MSb\u001c\u0097\u00a6\u0013m\u0082\u0001`w\u00f3V\u0093\n fu\u00aa\u00fd\u00ad&\u0018\u00cb\u0004L\u001d\u0001\u008a\u0083\u00d4\u00f8I7\u00b5P\u00da\u0081\u00fd;\tD;\u00d0\u00ber\u008dH\u0089\u009aa\u0013\u00d4\u00aa&\u00a9\u00884?\u0081\u00d4\u00ad\u0011\u00e3\u00a6\u00fe\u00a3y\u00e4\u00a2[\u00da\u0010R\u00a88g<\u008b\u0093.\u0087\u00d8\u0010\u00bb\u00b07\u00b3\u00fbn\u00e1\u00e7\u00cb\u00e1\u00d4\u0085\u00c0F\u0018 Se(\u00fc>\u00e5^\u0095\u0090\u00cab,2\u008d\u008f3@\u00a7\u00ffp\u0013G\u00b6\u008e\u00a9b\u00bf\t&'\u0097\u001eil+\u00b6\u008b\t\u00f94\u0085.\u00b8F\u0089\u0002\u007f\u0017\u00a3\u00d4\u00ea\u00a9^\u007f?\u00b9\u00ac\u00ab\u00e5\u00d1\u00c1\u00a3\u00f1\u00cd\u00a4o\u00fe\u00b9R\u00e6U5O\u00c1\u0007J\u00f5%\u00d3\u0015\u00fa@iU\u0082\u00a4\u00e0 \u00c1N\u009f\u00d2\"F\u00de\u001bN\u0094\u00cc9\u0000\u008a\u009b\u0157o\u00dc\u00c8z\u00a0\u00af\u00b8\u00d3^W\u00b1\u00c3\u0006n\"[8\u007f\u00d1\"\r\t\u00f2w\r\u0014:-A\u009e\u00c6\u0012P\u000b\u001e\u001cXO\u000b\u009eSBPvB\u00b5\u000e_i?\u0010Sv\u00ed0w7\u00a3\u00c8\u00d0\u0088 \u001f@\u00bd\u00d5u \u00aeP}\u00a1\u00b1\u00bbk?\u00c0\u008e\u000e\"\u0014B\u00f0\u00e4w\u00fb\u007f\u00e5\u00b1a\u00b3pB.\u00cbe\u00bb3\u00e2\f\u0005\u009cG\"61?\u0097\u00a8\u001cg\u0096\u0080\u00bf\u00a1w\u00d6\u00d8\u0087\u00b4\u00fe&k\u0019'\u0084\u00ffA\u00f1\u00b0\u00b3\u00dd\u0000`%\u00ed\u001d]\u000f\u008f\u00a1\u008b}\u00ce\u00eb\u00cc\u0013\u00c5i;<\u00ba\u00cf\u00f0\u00a0\u00cf\ba\u00d4\u00fc\u00adu\u00dev\u009cJ-\u0081\u00b3z\u0017\u0080\u0002\u00b3g\u0095\u00aa\u0018Jmc\u0098\u0019C\u00df\u00b9_RU\u00f2%\u008bO\u00bf\u0011\u00ef\u009b\u007f\u0004I\u0010\u00a4\u00c5\u001a\u00c3J\u00d2;(\\b\u009f\u0012\u00f9\u00d1+G\u00fe$\u00df\u00f3\u00c9\u00ef\u0003\u00c3(\u0003C\u0089\u00c0\u00e5\u0006:\u00db\u00d9\u000b3\u0003@I\u0006\u00c7\u00b2\u00ed:\u00d0\u00f6\u009a<e\u00da\u0003U\u00d0\u001e\u00c7\u0089_*:K\u00df\u00e40\u00ea\u00ddxZ\u00b6\u00abzS\u0004A\u00bf\u00c1(\u00ee\u00a6\u00a1\u00b7\u0198\u00f4\u00ff\u00c6'\u00b0\u009f\u0010\u00cb\u0091)r\u00dd\u0086\u0007,\u00ac\u0084\u00bb\u0097Co\u000b\u00e3\u00d3\u001e\u0090\n\u00c9U\u009bE\u00f5\u00b3 \u00da2\u001e\u00d9,qggw\u00ed@2S\u00deQDP\u00eb\u00c29\u0006\u00fa\f\u0018\u009eEv\u00de\u0094.\u0086\u00a5\u0004\u00c8p\r\u00e7\u000f\u0098\u000f\\r,\u009bJ>{V+\u00d0\u001c\u00d2\u0084.-\u00bdE\u0017\u001a\u00a2\u00e6I\u00c4\u00b7\u00b2\u0001K\u008d\u00d0\u00eb\u00ec}u\u00ff\u00cf\u00bd\u00a9\u008cO\b\u00c0Z`;y\u0019'\u00eaf\u00ec\rj%\u00a1\u00ed\u00e0\u00dbc\u00c8\u00e6e\u00b8\u00ee\u00941e;\u0016\u00d6o(\u00afW\u00b5A\u00e6\u00ad\u00a9\u00ce4\u00b56\u0003^\u0000\u0006\u0097\u00f3}\u0012\u00d0\u00dc\u0087t\u00d0(\t\u001dE\u00bc\u00ca2/\u001c\u0010\u00971\u00b0b\u008c\u00d5u \u00feq\u009f\\\u00a1\u00ed\b?(.\u0099gDb\u00ee\u00a1_\u00e8T\u0017\u00a1\u00fd\u00a0\u0005\u00f8\u001bn\u0085\u0095;\u00cem1\u00e1\u00bc\u00ea\u00fd\t2\u00f0Y\u00a8\u00f7\u0090\u009e\u00c7\u00e1\u00aaZ\u000f\n\u009dI\u0092If\u00a4\u0017\u00d3t\u0092p+\u00a41\u0007\u00ff=\u0088\u008aU\u009e\u00a1&\u00f2)\u00f6\u008e\u00c0^E\u0083\u0005\u0019\u00b6\u00d0\u0003\u001c\u0012/+\u0082\u00f4\u00ca\u00c0\u0084\u009d\u00cc\u0087\u0085Y\u009a\u00b7\u00eec/\u0006\u00b1M\u00e7\u00b6\u00194p&\u00e0\u00b6\t\u00baL\u00e6\t>\u0017\u009aM]\u0019\u001f\u00fe\u00a9x.\u00de\u00cbC\u00f4\u00a3\u00e8\u00af8\u0014\u00beb{~$D\u00a1\u0084\u00a3\u00f3\u00a1s\u00fe\u00eaJ!?\u00a8\u0015\u00f7P8\u00b85\u00d4\u00f0tl\u009b\u00e1\u001e\u008dCS^7d\u00e8<\u00a9Z\u007f\u00ec\u00f4L\u0082\u0013\u0083\u00f7\u0087\u00fb[\u00e6\u00c6G\u01de\u00f4\u00ed\u00bb\\\u00cekuK\u00e7D\u0086\u00a1\u00e0\"\u00fe\u00d2\u00a3N\u00a2\u0004c\u001c\u00ee\u00cc~\u00be,\u0091/-\u0096\u0085T\u008az+\u0012\u0099\u0007\u00d3i\u0003\u00ec\u00bc\u0098ild\u00a9\u00e0\u0003K$\u0011\u001f\u000e\u0015J\u00c5\u009b7\u0015\u0083V\u00c1\u00b97\u001d\u008a\u00a0\u00fea\u00b4L\u00b8\u0013\u00b2\u00f0#\u00cf\u00106\r\u0096U\u00cf\u001d\u001cG+C{\u00e72\u00b4\u00eb\u00ffk\f\u00b8\u0087e\\\u00c5\u00ec)\u0007{=\u00ea\u00fbic\u0084F\f\u001d2\u00f0\u0007/\u00c7\u009c\u0096\u00cff\u0084\u00d9\u00ad\u0098/\u00abq\u00a4\u0081\u00bd\f\u001c?C\u00bf3q1\u0098p\u0007\u001a\u00ac\u00e6p\u00dd@9?\u00c3e\u0010\u00b8\u00eeni\u00dfq\u0083\u00d7\u0088\u00b4|VL\u0001o\u0001\u00bd+\u00f4\u0013\u00ae\u00d5T\u0092\u00e4/EV\u00e1I\u00a4\u00c11\u00c0J\u00e0l\u00f4\u00bd:\u00c8r\u00fd\u00d5\u00cc\u00b3\u009c*\u0016\u00a4U<\u00d0!ws\u001a)Kn";
                    var4_3 = "\u0013\u009a\u008c!\u0084H\u00fd\u00b8?\u00f5\u00d1\u00e3\u0095r\u0002\u00fa\u009d\u0015\u0014\u00b9S9\u00f2\u00aa\u0095#iA\u00cc\u0091y\u009e\u001d\u0098(6\tQB\u00ffE5,3\u00f9\u0010\u00b3\u00f0\u0094\u00ecT/\u001f\u00e6\u00beW\u00b08\u0099aV\u00d8{h`'`\u00e7\u00a3\u0089\u001fQ\u00cd\u00b0\u001c\u0084\u00f6A\u00aa\u00e7Z\u00ac\u00bf\u0088\t\u00ad\u00be8\u001ck4\u0003\u00c4\u0080,]\u0018*\u00e5\u00e1\u00c1\u00a5\u00b7\f\u00ebh+\u00cdb\f\u00c6\u00e1I\u00bd\u0089\u00ec\u00c4\u00a4\u00c8\u008f\u00aa\u00d9jS\u00dc9a\u00bc\u0083\u0091K\u008f0\u00e4\u00a9k\u00d0\u001bw\u0018g\u00farlM\u00c7]\u00ae\u00e0Il\u008d\u00f0(\u00d7\u00bc`Af|A^7.\u0015:\u00bc\u00c4\u0090\u007fjW FG\u00b7ae#\u0006\u00be^\u007f\u00c3l\u00e6\u0010\u00a1\u00b4\u0097\u00b1\u0011p\u009e\ru\u0001\u0013\u00eb\u00db\u00b95\u008c\u0002@4\u001bB=%\u00dc\u0019\u00a4\u0083\u0016\u00ebq\u00d51.U\u00c6\u00bb\u00bal\u00c4\u00a0\u00d4\u00c4\u0005n\u0099i'?OR\u00078\u00f5k\u00d3\u00dc\u00fayir\u0082@\u00e0\u00bc\u00c1\u00dd\u009f\u00a0\"\u001a\u00dc\u00ceP\u00af\u00d1\u00d0\u00db\u00a3\u009b\u00d8W[\u0090\"\u00ad\u0000\u00a0nH\u00c6\u008a\u00c9\u008cq6w\u0017\u00f2z\u008b\u009fF\u0019\u00a3\u00fb3\u00fb\u00d8\u00b7\r\u00bc\u000f\u00af\u00d9\u0089\u0084\u00ba\u00ec]u\u00e3#9\u00e5\u008a\u00ec\u0018U\u001b&\u008d\u00b6\u00a4\u00ba\u00f9\u00e6\u00bf>\u00c1\u009a\u0097]B\u001f\u0095\u00a9\u0015.s\u00cb\u00f6\u00f4\u0015\u00e8y8\u00ce\u00be9{\u00178\u001d\u00bfN7\u009b\u00c1\u0002^\u00133\u00fb\u00cbp~;R\u00efc^\u00e9C\u00ee@A\u00beD\\.\u0080s3t>W\u00af\u00b0\u00f3.\u00ed\u0095\u00fdJw\u00f5\u0012\u00f2Cpo=p\u0016\u00c8\u008d\u00bb\u0092\u00f4\u00b4\u0007\t\u0082\u00ac\u00f5\u0088F\u00a0\u00c7F\u00c2|}<\t\u0089\u0016\u0019~\u0081\u00ec\u00b3{\u00ef\u00f0\u009f\u0093Vo2\\I\u00d9\u0013\u008fGBNF\r\u0081\u00c9\u00baK\u000fP]L\u00ed8OC|@ \u00ff\u00ea\u008dH\u00ddd\n\f\u00a3\u00b7)Y+\u009b\u00d1\u00aepr\u0015\u009f\u00ack\u0018\u00a6u\u000f\u008b\u0000\u00c8\u00e0\u00b5:\u00fdl\u0080d\u00cfZZ7(\u014a\u0007\u00a5\u00b8l\u007f\u00f6\u00e9\u00e6\u00ae\u008c\u0095iz\u0091\u00b3~w\u00e1\u00e9\b\u00a0Ulic_y\u0087BA\u00c8\u00ca/\u0004J\u008e\u00f9e\u00e2\u00e6\u00fb\u00c7\u00ae\u00f6MSb\u001c\u0097\u00a6\u0013m\u0082\u0001`w\u00f3V\u0093\n fu\u00aa\u00fd\u00ad&\u0018\u00cb\u0004L\u001d\u0001\u008a\u0083\u00d4\u00f8I7\u00b5P\u00da\u0081\u00fd;\tD;\u00d0\u00ber\u008dH\u0089\u009aa\u0013\u00d4\u00aa&\u00a9\u00884?\u0081\u00d4\u00ad\u0011\u00e3\u00a6\u00fe\u00a3y\u00e4\u00a2[\u00da\u0010R\u00a88g<\u008b\u0093.\u0087\u00d8\u0010\u00bb\u00b07\u00b3\u00fbn\u00e1\u00e7\u00cb\u00e1\u00d4\u0085\u00c0F\u0018 Se(\u00fc>\u00e5^\u0095\u0090\u00cab,2\u008d\u008f3@\u00a7\u00ffp\u0013G\u00b6\u008e\u00a9b\u00bf\t&'\u0097\u001eil+\u00b6\u008b\t\u00f94\u0085.\u00b8F\u0089\u0002\u007f\u0017\u00a3\u00d4\u00ea\u00a9^\u007f?\u00b9\u00ac\u00ab\u00e5\u00d1\u00c1\u00a3\u00f1\u00cd\u00a4o\u00fe\u00b9R\u00e6U5O\u00c1\u0007J\u00f5%\u00d3\u0015\u00fa@iU\u0082\u00a4\u00e0 \u00c1N\u009f\u00d2\"F\u00de\u001bN\u0094\u00cc9\u0000\u008a\u009b\u0157o\u00dc\u00c8z\u00a0\u00af\u00b8\u00d3^W\u00b1\u00c3\u0006n\"[8\u007f\u00d1\"\r\t\u00f2w\r\u0014:-A\u009e\u00c6\u0012P\u000b\u001e\u001cXO\u000b\u009eSBPvB\u00b5\u000e_i?\u0010Sv\u00ed0w7\u00a3\u00c8\u00d0\u0088 \u001f@\u00bd\u00d5u \u00aeP}\u00a1\u00b1\u00bbk?\u00c0\u008e\u000e\"\u0014B\u00f0\u00e4w\u00fb\u007f\u00e5\u00b1a\u00b3pB.\u00cbe\u00bb3\u00e2\f\u0005\u009cG\"61?\u0097\u00a8\u001cg\u0096\u0080\u00bf\u00a1w\u00d6\u00d8\u0087\u00b4\u00fe&k\u0019'\u0084\u00ffA\u00f1\u00b0\u00b3\u00dd\u0000`%\u00ed\u001d]\u000f\u008f\u00a1\u008b}\u00ce\u00eb\u00cc\u0013\u00c5i;<\u00ba\u00cf\u00f0\u00a0\u00cf\ba\u00d4\u00fc\u00adu\u00dev\u009cJ-\u0081\u00b3z\u0017\u0080\u0002\u00b3g\u0095\u00aa\u0018Jmc\u0098\u0019C\u00df\u00b9_RU\u00f2%\u008bO\u00bf\u0011\u00ef\u009b\u007f\u0004I\u0010\u00a4\u00c5\u001a\u00c3J\u00d2;(\\b\u009f\u0012\u00f9\u00d1+G\u00fe$\u00df\u00f3\u00c9\u00ef\u0003\u00c3(\u0003C\u0089\u00c0\u00e5\u0006:\u00db\u00d9\u000b3\u0003@I\u0006\u00c7\u00b2\u00ed:\u00d0\u00f6\u009a<e\u00da\u0003U\u00d0\u001e\u00c7\u0089_*:K\u00df\u00e40\u00ea\u00ddxZ\u00b6\u00abzS\u0004A\u00bf\u00c1(\u00ee\u00a6\u00a1\u00b7\u0198\u00f4\u00ff\u00c6'\u00b0\u009f\u0010\u00cb\u0091)r\u00dd\u0086\u0007,\u00ac\u0084\u00bb\u0097Co\u000b\u00e3\u00d3\u001e\u0090\n\u00c9U\u009bE\u00f5\u00b3 \u00da2\u001e\u00d9,qggw\u00ed@2S\u00deQDP\u00eb\u00c29\u0006\u00fa\f\u0018\u009eEv\u00de\u0094.\u0086\u00a5\u0004\u00c8p\r\u00e7\u000f\u0098\u000f\\r,\u009bJ>{V+\u00d0\u001c\u00d2\u0084.-\u00bdE\u0017\u001a\u00a2\u00e6I\u00c4\u00b7\u00b2\u0001K\u008d\u00d0\u00eb\u00ec}u\u00ff\u00cf\u00bd\u00a9\u008cO\b\u00c0Z`;y\u0019'\u00eaf\u00ec\rj%\u00a1\u00ed\u00e0\u00dbc\u00c8\u00e6e\u00b8\u00ee\u00941e;\u0016\u00d6o(\u00afW\u00b5A\u00e6\u00ad\u00a9\u00ce4\u00b56\u0003^\u0000\u0006\u0097\u00f3}\u0012\u00d0\u00dc\u0087t\u00d0(\t\u001dE\u00bc\u00ca2/\u001c\u0010\u00971\u00b0b\u008c\u00d5u \u00feq\u009f\\\u00a1\u00ed\b?(.\u0099gDb\u00ee\u00a1_\u00e8T\u0017\u00a1\u00fd\u00a0\u0005\u00f8\u001bn\u0085\u0095;\u00cem1\u00e1\u00bc\u00ea\u00fd\t2\u00f0Y\u00a8\u00f7\u0090\u009e\u00c7\u00e1\u00aaZ\u000f\n\u009dI\u0092If\u00a4\u0017\u00d3t\u0092p+\u00a41\u0007\u00ff=\u0088\u008aU\u009e\u00a1&\u00f2)\u00f6\u008e\u00c0^E\u0083\u0005\u0019\u00b6\u00d0\u0003\u001c\u0012/+\u0082\u00f4\u00ca\u00c0\u0084\u009d\u00cc\u0087\u0085Y\u009a\u00b7\u00eec/\u0006\u00b1M\u00e7\u00b6\u00194p&\u00e0\u00b6\t\u00baL\u00e6\t>\u0017\u009aM]\u0019\u001f\u00fe\u00a9x.\u00de\u00cbC\u00f4\u00a3\u00e8\u00af8\u0014\u00beb{~$D\u00a1\u0084\u00a3\u00f3\u00a1s\u00fe\u00eaJ!?\u00a8\u0015\u00f7P8\u00b85\u00d4\u00f0tl\u009b\u00e1\u001e\u008dCS^7d\u00e8<\u00a9Z\u007f\u00ec\u00f4L\u0082\u0013\u0083\u00f7\u0087\u00fb[\u00e6\u00c6G\u01de\u00f4\u00ed\u00bb\\\u00cekuK\u00e7D\u0086\u00a1\u00e0\"\u00fe\u00d2\u00a3N\u00a2\u0004c\u001c\u00ee\u00cc~\u00be,\u0091/-\u0096\u0085T\u008az+\u0012\u0099\u0007\u00d3i\u0003\u00ec\u00bc\u0098ild\u00a9\u00e0\u0003K$\u0011\u001f\u000e\u0015J\u00c5\u009b7\u0015\u0083V\u00c1\u00b97\u001d\u008a\u00a0\u00fea\u00b4L\u00b8\u0013\u00b2\u00f0#\u00cf\u00106\r\u0096U\u00cf\u001d\u001cG+C{\u00e72\u00b4\u00eb\u00ffk\f\u00b8\u0087e\\\u00c5\u00ec)\u0007{=\u00ea\u00fbic\u0084F\f\u001d2\u00f0\u0007/\u00c7\u009c\u0096\u00cff\u0084\u00d9\u00ad\u0098/\u00abq\u00a4\u0081\u00bd\f\u001c?C\u00bf3q1\u0098p\u0007\u001a\u00ac\u00e6p\u00dd@9?\u00c3e\u0010\u00b8\u00eeni\u00dfq\u0083\u00d7\u0088\u00b4|VL\u0001o\u0001\u00bd+\u00f4\u0013\u00ae\u00d5T\u0092\u00e4/EV\u00e1I\u00a4\u00c11\u00c0J\u00e0l\u00f4\u00bd:\u00c8r\u00fd\u00d5\u00cc\u00b3\u009c*\u0016\u00a4U<\u00d0!ws\u001a)Kn".length();
                    var1_4 = 52;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = ++var0_5;
                        v1 = var2_2.substring(v0, v0 + var1_4);
                        v2 = -1;
                        break block23;
                        break;
                    }
lbl12:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v3.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "v`\u008a\u0001\u00d1\u0083L\u00ce=\u00f2\u00b0\u00c8\u00a5\u00033:\u0018\u00d8z\u0085|\u00b3\u00c5\u0082\u00ee\u001bA\u0013\u008c\u001f\b*\u00b8\u00df\u00c1\u0091l\u00bf\\\u00e8n";
                        var4_3 = "v`\u008a\u0001\u00d1\u0083L\u00ce=\u00f2\u00b0\u00c8\u00a5\u00033:\u0018\u00d8z\u0085|\u00b3\u00c5\u0082\u00ee\u001bA\u0013\u008c\u001f\b*\u00b8\u00df\u00c1\u0091l\u00bf\\\u00e8n".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl21:
                        // 2 sources

                        while (true) {
                            v4 = ++var0_5;
                            v1 = var2_2.substring(v4, v4 + var1_4);
                            v2 = 0;
                            break block23;
                            break;
                        }
                        break;
                    }
lbl26:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v3.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block24;
                        break;
                    }
                }
                v5 = v1.toCharArray();
                var6_6 = 0;
                v6 = v5.length;
                v7 = v5;
                v8 = v6;
                if (v6 > 1) ** GOTO lbl76
                do {
                    v9 = v7;
                    v10 = v7;
                    v11 = var6_6;
                    while (true) {
                        v12 = v9[v11];
                        switch (var6_6 % 7) {
                            case 0: {
                                v13 = 53;
                                break;
                            }
                            case 1: {
                                v13 = 49;
                                break;
                            }
                            case 2: {
                                v13 = 125;
                                break;
                            }
                            case 3: {
                                v13 = 120;
                                break;
                            }
                            case 4: {
                                v13 = 97;
                                break;
                            }
                            case 5: {
                                v13 = 14;
                                break;
                            }
                            default: {
                                v13 = 15;
                            }
                        }
                        v9[v11] = (char)(v12 ^ v13);
                        ++var6_6;
                        v7 = v10;
                        v8 = v8;
                        if (v8 != 0) break;
                        v10 = v7;
                        v14 = v8;
                        v11 = v8;
                        v9 = v7;
                    }
lbl76:
                    // 2 sources

                    v15 = v7;
                    v14 = v8;
                } while (v8 > var6_6);
                v3 = new String(v15);
                switch (v2) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl85:
                    // 1 sources

                    ** continue;
                }
            }
            SmartOp.e = var5;
            SmartOp.f = new String[54];
            SmartOp.d = LoggerFactory.getLogger(SmartOp.class);
            var7_7 = System.getProperty(SmartOp.a(-3487, 14944)).toLowerCase();
            if (var7_7.indexOf(SmartOp.a(-3482, -18088)) < 0 || !MA3APIEnvironment.SET_MAC_OS_PCSC_PATH) break block25;
            System.setProperty(SmartOp.a(-3502, 8179), SmartOp.a(-3461, -3388));
        }
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFF248) & 0xFFFF;
        if (f[n3] == null) {
            int n4;
            int n5;
            char[] cArray = e[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 115;
                    break;
                }
                case 1: {
                    n5 = 211;
                    break;
                }
                case 2: {
                    n5 = 38;
                    break;
                }
                case 3: {
                    n5 = 248;
                    break;
                }
                case 4: {
                    n5 = 91;
                    break;
                }
                case 5: {
                    n5 = 196;
                    break;
                }
                case 6: {
                    n5 = 240;
                    break;
                }
                case 7: {
                    n5 = 144;
                    break;
                }
                case 8: {
                    n5 = 60;
                    break;
                }
                case 9: {
                    n5 = 168;
                    break;
                }
                case 10: {
                    n5 = 199;
                    break;
                }
                case 11: {
                    n5 = 9;
                    break;
                }
                case 12: {
                    n5 = 64;
                    break;
                }
                case 13: {
                    n5 = 56;
                    break;
                }
                case 14: {
                    n5 = 29;
                    break;
                }
                case 15: {
                    n5 = 57;
                    break;
                }
                case 16: {
                    n5 = 7;
                    break;
                }
                case 17: {
                    n5 = 73;
                    break;
                }
                case 18: {
                    n5 = 22;
                    break;
                }
                case 19: {
                    n5 = 13;
                    break;
                }
                case 20: {
                    n5 = 164;
                    break;
                }
                case 21: {
                    n5 = 119;
                    break;
                }
                case 22: {
                    n5 = 152;
                    break;
                }
                case 23: {
                    n5 = 59;
                    break;
                }
                case 24: {
                    n5 = 159;
                    break;
                }
                case 25: {
                    n5 = 217;
                    break;
                }
                case 26: {
                    n5 = 129;
                    break;
                }
                case 27: {
                    n5 = 28;
                    break;
                }
                case 28: {
                    n5 = 39;
                    break;
                }
                case 29: {
                    n5 = 102;
                    break;
                }
                case 30: {
                    n5 = 58;
                    break;
                }
                case 31: {
                    n5 = 216;
                    break;
                }
                case 32: {
                    n5 = 158;
                    break;
                }
                case 33: {
                    n5 = 155;
                    break;
                }
                case 34: {
                    n5 = 221;
                    break;
                }
                case 35: {
                    n5 = 156;
                    break;
                }
                case 36: {
                    n5 = 139;
                    break;
                }
                case 37: {
                    n5 = 143;
                    break;
                }
                case 38: {
                    n5 = 5;
                    break;
                }
                case 39: {
                    n5 = 75;
                    break;
                }
                case 40: {
                    n5 = 93;
                    break;
                }
                case 41: {
                    n5 = 74;
                    break;
                }
                case 42: {
                    n5 = 160;
                    break;
                }
                case 43: {
                    n5 = 173;
                    break;
                }
                case 44: {
                    n5 = 83;
                    break;
                }
                case 45: {
                    n5 = 30;
                    break;
                }
                case 46: {
                    n5 = 183;
                    break;
                }
                case 47: {
                    n5 = 103;
                    break;
                }
                case 48: {
                    n5 = 88;
                    break;
                }
                case 49: {
                    n5 = 250;
                    break;
                }
                case 50: {
                    n5 = 252;
                    break;
                }
                case 51: {
                    n5 = 84;
                    break;
                }
                case 52: {
                    n5 = 48;
                    break;
                }
                case 53: {
                    n5 = 104;
                    break;
                }
                case 54: {
                    n5 = 142;
                    break;
                }
                case 55: {
                    n5 = 184;
                    break;
                }
                case 56: {
                    n5 = 4;
                    break;
                }
                case 57: {
                    n5 = 193;
                    break;
                }
                case 58: {
                    n5 = 54;
                    break;
                }
                case 59: {
                    n5 = 67;
                    break;
                }
                case 60: {
                    n5 = 18;
                    break;
                }
                case 61: {
                    n5 = 229;
                    break;
                }
                case 62: {
                    n5 = 181;
                    break;
                }
                case 63: {
                    n5 = 239;
                    break;
                }
                case 64: {
                    n5 = 241;
                    break;
                }
                case 65: {
                    n5 = 210;
                    break;
                }
                case 66: {
                    n5 = 189;
                    break;
                }
                case 67: {
                    n5 = 53;
                    break;
                }
                case 68: {
                    n5 = 77;
                    break;
                }
                case 69: {
                    n5 = 249;
                    break;
                }
                case 70: {
                    n5 = 71;
                    break;
                }
                case 71: {
                    n5 = 14;
                    break;
                }
                case 72: {
                    n5 = 212;
                    break;
                }
                case 73: {
                    n5 = 44;
                    break;
                }
                case 74: {
                    n5 = 94;
                    break;
                }
                case 75: {
                    n5 = 12;
                    break;
                }
                case 76: {
                    n5 = 149;
                    break;
                }
                case 77: {
                    n5 = 243;
                    break;
                }
                case 78: {
                    n5 = 120;
                    break;
                }
                case 79: {
                    n5 = 114;
                    break;
                }
                case 80: {
                    n5 = 79;
                    break;
                }
                case 81: {
                    n5 = 25;
                    break;
                }
                case 82: {
                    n5 = 141;
                    break;
                }
                case 83: {
                    n5 = 148;
                    break;
                }
                case 84: {
                    n5 = 222;
                    break;
                }
                case 85: {
                    n5 = 188;
                    break;
                }
                case 86: {
                    n5 = 89;
                    break;
                }
                case 87: {
                    n5 = 19;
                    break;
                }
                case 88: {
                    n5 = 147;
                    break;
                }
                case 89: {
                    n5 = 105;
                    break;
                }
                case 90: {
                    n5 = 2;
                    break;
                }
                case 91: {
                    n5 = 82;
                    break;
                }
                case 92: {
                    n5 = 72;
                    break;
                }
                case 93: {
                    n5 = 207;
                    break;
                }
                case 94: {
                    n5 = 162;
                    break;
                }
                case 95: {
                    n5 = 177;
                    break;
                }
                case 96: {
                    n5 = 118;
                    break;
                }
                case 97: {
                    n5 = 63;
                    break;
                }
                case 98: {
                    n5 = 138;
                    break;
                }
                case 99: {
                    n5 = 85;
                    break;
                }
                case 100: {
                    n5 = 202;
                    break;
                }
                case 101: {
                    n5 = 40;
                    break;
                }
                case 102: {
                    n5 = 170;
                    break;
                }
                case 103: {
                    n5 = 3;
                    break;
                }
                case 104: {
                    n5 = 24;
                    break;
                }
                case 105: {
                    n5 = 107;
                    break;
                }
                case 106: {
                    n5 = 154;
                    break;
                }
                case 107: {
                    n5 = 20;
                    break;
                }
                case 108: {
                    n5 = 52;
                    break;
                }
                case 109: {
                    n5 = 70;
                    break;
                }
                case 110: {
                    n5 = 204;
                    break;
                }
                case 111: {
                    n5 = 101;
                    break;
                }
                case 112: {
                    n5 = 190;
                    break;
                }
                case 113: {
                    n5 = 27;
                    break;
                }
                case 114: {
                    n5 = 175;
                    break;
                }
                case 115: {
                    n5 = 163;
                    break;
                }
                case 116: {
                    n5 = 15;
                    break;
                }
                case 117: {
                    n5 = 136;
                    break;
                }
                case 118: {
                    n5 = 224;
                    break;
                }
                case 119: {
                    n5 = 8;
                    break;
                }
                case 120: {
                    n5 = 218;
                    break;
                }
                case 121: {
                    n5 = 116;
                    break;
                }
                case 122: {
                    n5 = 32;
                    break;
                }
                case 123: {
                    n5 = 109;
                    break;
                }
                case 124: {
                    n5 = 86;
                    break;
                }
                case 125: {
                    n5 = 112;
                    break;
                }
                case 126: {
                    n5 = 69;
                    break;
                }
                case 127: {
                    n5 = 238;
                    break;
                }
                case 128: {
                    n5 = 205;
                    break;
                }
                case 129: {
                    n5 = 215;
                    break;
                }
                case 130: {
                    n5 = 209;
                    break;
                }
                case 131: {
                    n5 = 34;
                    break;
                }
                case 132: {
                    n5 = 106;
                    break;
                }
                case 133: {
                    n5 = 192;
                    break;
                }
                case 134: {
                    n5 = 21;
                    break;
                }
                case 135: {
                    n5 = 17;
                    break;
                }
                case 136: {
                    n5 = 195;
                    break;
                }
                case 137: {
                    n5 = 51;
                    break;
                }
                case 138: {
                    n5 = 176;
                    break;
                }
                case 139: {
                    n5 = 47;
                    break;
                }
                case 140: {
                    n5 = 78;
                    break;
                }
                case 141: {
                    n5 = 33;
                    break;
                }
                case 142: {
                    n5 = 167;
                    break;
                }
                case 143: {
                    n5 = 161;
                    break;
                }
                case 144: {
                    n5 = 6;
                    break;
                }
                case 145: {
                    n5 = 203;
                    break;
                }
                case 146: {
                    n5 = 43;
                    break;
                }
                case 147: {
                    n5 = 185;
                    break;
                }
                case 148: {
                    n5 = 191;
                    break;
                }
                case 149: {
                    n5 = 230;
                    break;
                }
                case 150: {
                    n5 = 96;
                    break;
                }
                case 151: {
                    n5 = 178;
                    break;
                }
                case 152: {
                    n5 = 146;
                    break;
                }
                case 153: {
                    n5 = 150;
                    break;
                }
                case 154: {
                    n5 = 76;
                    break;
                }
                case 155: {
                    n5 = 11;
                    break;
                }
                case 156: {
                    n5 = 16;
                    break;
                }
                case 157: {
                    n5 = 125;
                    break;
                }
                case 158: {
                    n5 = 201;
                    break;
                }
                case 159: {
                    n5 = 124;
                    break;
                }
                case 160: {
                    n5 = 100;
                    break;
                }
                case 161: {
                    n5 = 219;
                    break;
                }
                case 162: {
                    n5 = 194;
                    break;
                }
                case 163: {
                    n5 = 131;
                    break;
                }
                case 164: {
                    n5 = 228;
                    break;
                }
                case 165: {
                    n5 = 255;
                    break;
                }
                case 166: {
                    n5 = 251;
                    break;
                }
                case 167: {
                    n5 = 68;
                    break;
                }
                case 168: {
                    n5 = 180;
                    break;
                }
                case 169: {
                    n5 = 1;
                    break;
                }
                case 170: {
                    n5 = 87;
                    break;
                }
                case 171: {
                    n5 = 111;
                    break;
                }
                case 172: {
                    n5 = 108;
                    break;
                }
                case 173: {
                    n5 = 26;
                    break;
                }
                case 174: {
                    n5 = 253;
                    break;
                }
                case 175: {
                    n5 = 179;
                    break;
                }
                case 176: {
                    n5 = 35;
                    break;
                }
                case 177: {
                    n5 = 132;
                    break;
                }
                case 178: {
                    n5 = 200;
                    break;
                }
                case 179: {
                    n5 = 157;
                    break;
                }
                case 180: {
                    n5 = 80;
                    break;
                }
                case 181: {
                    n5 = 0;
                    break;
                }
                case 182: {
                    n5 = 55;
                    break;
                }
                case 183: {
                    n5 = 92;
                    break;
                }
                case 184: {
                    n5 = 231;
                    break;
                }
                case 185: {
                    n5 = 113;
                    break;
                }
                case 186: {
                    n5 = 236;
                    break;
                }
                case 187: {
                    n5 = 246;
                    break;
                }
                case 188: {
                    n5 = 61;
                    break;
                }
                case 189: {
                    n5 = 197;
                    break;
                }
                case 190: {
                    n5 = 95;
                    break;
                }
                case 191: {
                    n5 = 110;
                    break;
                }
                case 192: {
                    n5 = 140;
                    break;
                }
                case 193: {
                    n5 = 128;
                    break;
                }
                case 194: {
                    n5 = 130;
                    break;
                }
                case 195: {
                    n5 = 62;
                    break;
                }
                case 196: {
                    n5 = 123;
                    break;
                }
                case 197: {
                    n5 = 90;
                    break;
                }
                case 198: {
                    n5 = 121;
                    break;
                }
                case 199: {
                    n5 = 31;
                    break;
                }
                case 200: {
                    n5 = 234;
                    break;
                }
                case 201: {
                    n5 = 65;
                    break;
                }
                case 202: {
                    n5 = 187;
                    break;
                }
                case 203: {
                    n5 = 245;
                    break;
                }
                case 204: {
                    n5 = 237;
                    break;
                }
                case 205: {
                    n5 = 153;
                    break;
                }
                case 206: {
                    n5 = 165;
                    break;
                }
                case 207: {
                    n5 = 186;
                    break;
                }
                case 208: {
                    n5 = 198;
                    break;
                }
                case 209: {
                    n5 = 36;
                    break;
                }
                case 210: {
                    n5 = 208;
                    break;
                }
                case 211: {
                    n5 = 244;
                    break;
                }
                case 212: {
                    n5 = 213;
                    break;
                }
                case 213: {
                    n5 = 122;
                    break;
                }
                case 214: {
                    n5 = 169;
                    break;
                }
                case 215: {
                    n5 = 232;
                    break;
                }
                case 216: {
                    n5 = 23;
                    break;
                }
                case 217: {
                    n5 = 46;
                    break;
                }
                case 218: {
                    n5 = 174;
                    break;
                }
                case 219: {
                    n5 = 214;
                    break;
                }
                case 220: {
                    n5 = 145;
                    break;
                }
                case 221: {
                    n5 = 41;
                    break;
                }
                case 222: {
                    n5 = 42;
                    break;
                }
                case 223: {
                    n5 = 98;
                    break;
                }
                case 224: {
                    n5 = 97;
                    break;
                }
                case 225: {
                    n5 = 99;
                    break;
                }
                case 226: {
                    n5 = 182;
                    break;
                }
                case 227: {
                    n5 = 172;
                    break;
                }
                case 228: {
                    n5 = 254;
                    break;
                }
                case 229: {
                    n5 = 227;
                    break;
                }
                case 230: {
                    n5 = 226;
                    break;
                }
                case 231: {
                    n5 = 50;
                    break;
                }
                case 232: {
                    n5 = 37;
                    break;
                }
                case 233: {
                    n5 = 166;
                    break;
                }
                case 234: {
                    n5 = 81;
                    break;
                }
                case 235: {
                    n5 = 242;
                    break;
                }
                case 236: {
                    n5 = 225;
                    break;
                }
                case 237: {
                    n5 = 233;
                    break;
                }
                case 238: {
                    n5 = 127;
                    break;
                }
                case 239: {
                    n5 = 66;
                    break;
                }
                case 240: {
                    n5 = 133;
                    break;
                }
                case 241: {
                    n5 = 126;
                    break;
                }
                case 242: {
                    n5 = 223;
                    break;
                }
                case 243: {
                    n5 = 151;
                    break;
                }
                case 244: {
                    n5 = 137;
                    break;
                }
                case 245: {
                    n5 = 134;
                    break;
                }
                case 246: {
                    n5 = 235;
                    break;
                }
                case 247: {
                    n5 = 220;
                    break;
                }
                case 248: {
                    n5 = 117;
                    break;
                }
                case 249: {
                    n5 = 206;
                    break;
                }
                case 250: {
                    n5 = 247;
                    break;
                }
                case 251: {
                    n5 = 10;
                    break;
                }
                case 252: {
                    n5 = 171;
                    break;
                }
                case 253: {
                    n5 = 45;
                    break;
                }
                case 254: {
                    n5 = 49;
                    break;
                }
                default: {
                    n5 = 135;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            SmartOp.f[n3] = new String(cArray).intern();
        }
        return f[n3];
    }
}

